/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.grammar;

import java.io.Reader;
import org.eclipse.tm4e.core.internal.grammar.RawCaptures;
import org.eclipse.tm4e.core.internal.grammar.RawGrammar;
import org.eclipse.tm4e.core.internal.grammar.RawRepository;
import org.eclipse.tm4e.core.internal.grammar.RawRule;
import org.eclipse.tm4e.core.internal.parser.PListParser;
import org.eclipse.tm4e.core.internal.parser.PListParserJSON;
import org.eclipse.tm4e.core.internal.parser.PListParserXML;
import org.eclipse.tm4e.core.internal.parser.PListParserYAML;
import org.eclipse.tm4e.core.internal.parser.PListPath;
import org.eclipse.tm4e.core.internal.parser.PropertySettable;
import org.eclipse.tm4e.core.internal.types.IRawGrammar;
import org.eclipse.tm4e.core.registry.IGrammarSource;

public final class GrammarReader {
    public static final PropertySettable.Factory<PListPath> OBJECT_FACTORY = path -> {
        if (path.size() == 0) {
            return new RawGrammar();
        }
        return switch (path.last()) {
            case "repository" -> new RawRepository();
            case "whileCaptures", "endCaptures", "captures", "beginCaptures" -> new RawCaptures();
            default -> new RawRule();
        };
    };
    private static final PListParser<RawGrammar> JSON_PARSER = new PListParserJSON<RawGrammar>(OBJECT_FACTORY);
    private static final PListParser<RawGrammar> XML_PARSER = new PListParserXML<RawGrammar>(OBJECT_FACTORY);
    private static final PListParser<RawGrammar> YAML_PARSER = new PListParserYAML<RawGrammar>(OBJECT_FACTORY);

    public static IRawGrammar readGrammar(IGrammarSource source) throws Exception {
        Throwable throwable = null;
        Object var2_3 = null;
        try (Reader reader = source.getReader();){
            switch (source.getContentType()) {
                case JSON: {
                    return JSON_PARSER.parse(reader);
                }
                case YAML: {
                    return YAML_PARSER.parse(reader);
                }
            }
            return XML_PARSER.parse(reader);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private GrammarReader() {
    }
}

