/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.theme.reader;

import java.io.InputStream;
import org.eclipse.tm4e.core.internal.parser.PListParser;
import org.eclipse.tm4e.core.internal.parser.PListParserJSON;
import org.eclipse.tm4e.core.internal.parser.PListParserXML;
import org.eclipse.tm4e.core.internal.parser.PListParserYAML;
import org.eclipse.tm4e.core.internal.parser.PListPath;
import org.eclipse.tm4e.core.internal.parser.PropertySettable;
import org.eclipse.tm4e.core.internal.theme.IRawTheme;
import org.eclipse.tm4e.core.internal.theme.ThemeRaw;
import org.eclipse.tm4e.core.internal.theme.reader.SyncThemeReader;

public final class ThemeReader {
    private static final PropertySettable.Factory<PListPath> OBJECT_FACTORY = path -> new ThemeRaw();
    private static final PListParserJSON<ThemeRaw> JSON_PARSER = new PListParserJSON(OBJECT_FACTORY);
    private static final PListParserYAML<ThemeRaw> YAML_PARSER = new PListParserYAML(OBJECT_FACTORY);
    private static final PListParserXML<ThemeRaw> XML_PARSER = new PListParserXML(OBJECT_FACTORY);

    public static IRawTheme readThemeSync(String filePath, InputStream in) throws Exception {
        SyncThemeReader reader = new SyncThemeReader(in, ThemeReader.getThemeParser(filePath));
        return reader.load();
    }

    private static PListParser<ThemeRaw> getThemeParser(String filePath) {
        String extension;
        switch (extension = filePath.substring(filePath.lastIndexOf(46) + 1).trim().toLowerCase()) {
            case "json": {
                return JSON_PARSER;
            }
            case "yml": 
            case "yaml": {
                return YAML_PARSER;
            }
        }
        return XML_PARSER;
    }

    private ThemeReader() {
    }
}

