/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.efs;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.HashMap;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.provider.FileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.rse.internal.efs.Activator;
import org.eclipse.rse.internal.efs.Messages;
import org.eclipse.rse.internal.efs.RSEFileStoreImpl;
import org.eclipse.rse.internal.efs.RSEFileSystem;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class RSEFileStore
extends FileStore {
    private RSEFileStore _parent;
    private String _host;
    private String _name;
    private String _alias;
    private IPath _absolutePath;
    private transient RSEFileStoreImpl _impl = null;
    private static HashMap instanceMap = new HashMap();
    private static Bundle resourcesBundle = null;

    private RSEFileStore(RSEFileStore parent, String name) {
        this._parent = parent;
        this._host = parent.getHost();
        this._name = name;
        this._absolutePath = parent._absolutePath.append(name);
    }

    private RSEFileStore(String host, String absolutePath) {
        this._parent = null;
        this._host = host;
        this._absolutePath = new Path(absolutePath);
        this._name = this._absolutePath.lastSegment();
        if (this._name == null) {
            this._name = this._absolutePath.getDevice();
            if (this._name == null) {
                this._name = "";
            }
        }
    }

    private RSEFileStore(String host, String absolutePath, String aliasName) {
        this._parent = null;
        this._host = host;
        this._absolutePath = new Path(absolutePath);
        this._alias = aliasName;
        this._name = this._absolutePath.lastSegment();
        if (this._name == null) {
            this._name = this._absolutePath.getDevice();
            if (this._name == null) {
                this._name = "";
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RSEFileStore getInstance(URI uri) {
        HashMap hashMap = instanceMap;
        synchronized (hashMap) {
            RSEFileStore store = (RSEFileStore)((Object)instanceMap.get(uri));
            if (store == null) {
                String path = uri.getPath();
                String hostName = uri.getHost();
                String aliasName = uri.getQuery();
                store = new RSEFileStore(hostName, path, aliasName);
                instanceMap.put(uri, store);
            }
            return store;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IFileStore getChild(String name) {
        RSEFileStore tmpChild = new RSEFileStore(this, name);
        URI uri = tmpChild.toURI();
        HashMap hashMap = instanceMap;
        synchronized (hashMap) {
            RSEFileStore storedChild = (RSEFileStore)((Object)instanceMap.get(uri));
            if (storedChild == null) {
                instanceMap.put(uri, tmpChild);
            } else {
                tmpChild = storedChild;
            }
        }
        return tmpChild;
    }

    String getHost() {
        return this._host;
    }

    String getAlias() {
        return this._alias;
    }

    String getAbsolutePath() {
        return this._absolutePath.toString();
    }

    public String getName() {
        return this._name;
    }

    public IFileStore getParent() {
        if (this._parent == null && this._absolutePath.segmentCount() > 0) {
            String parentPath = this._absolutePath.removeLastSegments(1).toString();
            URI parentUri = RSEFileSystem.getURIFor(this._host, parentPath);
            this._parent = RSEFileStore.getInstance(parentUri);
        }
        return this._parent;
    }

    RSEFileStore getParentStore() {
        return this._parent;
    }

    RSEFileStoreImpl getImpl() throws CoreException {
        if (this._impl == null) {
            if (!RSEFileStore.isResourcesPluginUp()) {
                throw new CoreException((IStatus)new Status(2, Activator.getDefault().getBundle().getSymbolicName(), Messages.RESOURCES_NOT_LOADED));
            }
            this._impl = new RSEFileStoreImpl(this);
        }
        return this._impl;
    }

    private static boolean isResourcesPluginUp() {
        if (resourcesBundle == null) {
            BundleContext ctx = Activator.getDefault().getBundle().getBundleContext();
            Bundle[] bundles = ctx.getBundles();
            int i = 0;
            while (i < bundles.length) {
                if ("org.eclipse.core.resources".equals(bundles[i].getSymbolicName()) && resourcesBundle == null && bundles[i].getState() == 32) {
                    resourcesBundle = bundles[i];
                }
                ++i;
            }
        }
        return resourcesBundle != null && resourcesBundle.getState() == 32;
    }

    public String[] childNames(int options, IProgressMonitor monitor) throws CoreException {
        return this.getImpl().childNames(options, monitor);
    }

    public IFileInfo[] childInfos(int options, IProgressMonitor monitor) throws CoreException {
        return this.getImpl().childInfos(options, monitor);
    }

    public IFileInfo fetchInfo(int options, IProgressMonitor monitor) throws CoreException {
        return this.getImpl().fetchInfo(options, monitor);
    }

    public void putInfo(IFileInfo info, int options, IProgressMonitor monitor) throws CoreException {
        this.getImpl().putInfo(info, options, monitor);
    }

    public InputStream openInputStream(int options, IProgressMonitor monitor) throws CoreException {
        try {
            return this.getImpl().openInputStream(options, monitor);
        }
        catch (OperationCanceledException ex) {
            monitor.setCanceled(true);
            return null;
        }
    }

    public URI toURI() {
        return RSEFileSystem.getURIFor(this.getHost(), this.getAbsolutePath());
    }

    public IFileStore mkdir(int options, IProgressMonitor monitor) throws CoreException {
        return this.getImpl().mkdir(options, monitor);
    }

    public OutputStream openOutputStream(int options, IProgressMonitor monitor) throws CoreException {
        return this.getImpl().openOutputStream(options, monitor);
    }

    public void delete(int options, IProgressMonitor monitor) throws CoreException {
        this.getImpl().delete(options, monitor);
    }
}

