/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.synchronize.provisional;

import java.util.Calendar;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.rse.internal.synchronize.filesystem.FileSystemOperations;
import org.eclipse.rse.internal.synchronize.filesystem.FileSystemProvider;
import org.eclipse.rse.internal.synchronize.provisional.ISynchronizeFilter;
import org.eclipse.rse.internal.synchronize.provisional.ISynchronizeOperation;
import org.eclipse.rse.internal.synchronize.provisional.ISynchronizePerspectiveSelector;
import org.eclipse.rse.internal.synchronize.provisional.SynchronizePerspectiveSelector;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchronizeOperation
implements ISynchronizeOperation {
    private ISynchronizePerspectiveSelector switcher = new SynchronizePerspectiveSelector();

    @Override
    public void synchronize(List<IResource> local, IRemoteFile remote, ISynchronizeFilter filter, Calendar lastSyncDate, int options) throws CoreException {
        switch (options) {
            case 2: {
                this.exportTo(local, remote, filter);
                break;
            }
            case 1: {
                this.importFrom(local, remote, filter);
                break;
            }
            case 3: {
                this.synchronizeWith(local, remote, filter, lastSyncDate);
                break;
            }
            case 4: {
                this.synchronizeManually(local, remote, filter, lastSyncDate);
                break;
            }
            case 5: {
                this.initialSynchronizeManually(local, remote, filter, lastSyncDate);
            }
        }
    }

    private void importFrom(List<IResource> local, IRemoteFile remote, ISynchronizeFilter filter) throws TeamException {
        for (IResource resource : local) {
            FileSystemProvider provider = (FileSystemProvider)RepositoryProvider.getProvider((IProject)resource.getProject());
            FileSystemOperations operations = provider.getOperations();
            operations.get(new IResource[]{resource}, 2, true, null);
        }
    }

    private void exportTo(List<IResource> local, IRemoteFile remote, ISynchronizeFilter filter) throws TeamException {
        for (IResource resource : local) {
            FileSystemProvider provider = (FileSystemProvider)RepositoryProvider.getProvider((IProject)resource.getProject());
            FileSystemOperations operations = provider.getOperations();
            operations.checkin(new IResource[]{resource}, 2, false, null);
        }
    }

    private void synchronizeWith(List<IResource> local, IRemoteFile remote, ISynchronizeFilter filter, Calendar lastSyncDate) {
    }

    private void synchronizeManually(List<IResource> local, IRemoteFile remote, ISynchronizeFilter filter, Calendar lastSyncDate) {
        this.switcher.openSynchronizePerspective(local);
    }

    private void initialSynchronizeManually(List<IResource> local, IRemoteFile remote, ISynchronizeFilter filter, Calendar lastSyncDate) {
        this.switcher.openSynchronizePerspective(local);
    }
}

