/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.connectorservice.telnet;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.net.telnet.TelnetClient;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.IPropertySet;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.model.PropertyType;
import org.eclipse.rse.core.model.SystemSignonInformation;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.SubSystemConfiguration;
import org.eclipse.rse.internal.connectorservice.telnet.Activator;
import org.eclipse.rse.internal.connectorservice.telnet.TelnetConnectorResources;
import org.eclipse.rse.internal.services.telnet.ITelnetSessionProvider;
import org.eclipse.rse.services.clientserver.messages.CommonMessages;
import org.eclipse.rse.services.clientserver.messages.SimpleSystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.rse.ui.messages.SystemMessageDialog;
import org.eclipse.rse.ui.subsystems.StandardConnectorService;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class TelnetConnectorService
extends StandardConnectorService
implements ITelnetSessionProvider {
    public static final String PROPERTY_SET_NAME = "Telnet Settings";
    public static final String PROPERTY_LOGIN_REQUIRED = "Login.Required";
    public static final String PROPERTY_LOGIN_PROMPT = "Login.Prompt";
    public static final String PROPERTY_PASSWORD_PROMPT = "Password.Prompt";
    public static final String PROPERTY_COMMAND_PROMPT = "Command.Prompt";
    private static final int TELNET_DEFAULT_PORT = 23;
    private static final int TELNET_CONNECT_TIMEOUT = 60;
    private List fTelnetClients = new ArrayList();
    private SessionLostHandler fSessionLostHandler = null;
    private IPropertySet telnetPropertySet = this.getTelnetPropertySet();
    private static final int ERROR_CODE = 100;
    private static final int SUCCESS_CODE = 150;
    private static final int CONNECT_CLOSED = 200;
    private static final int CONNECT_CANCELLED = 250;

    public TelnetConnectorService(IHost host) {
        super(TelnetConnectorResources.TelnetConnectorService_Name, TelnetConnectorResources.TelnetConnectorService_Description, host, 23);
    }

    protected IPropertySet getTelnetPropertySet() {
        IPropertySet telnetSet = this.getPropertySet(PROPERTY_SET_NAME);
        if (telnetSet == null) {
            telnetSet = this.createPropertySet(PROPERTY_SET_NAME, TelnetConnectorResources.PropertySet_Description);
            telnetSet.addProperty(PROPERTY_LOGIN_REQUIRED, "true", PropertyType.getEnumPropertyType((String[])new String[]{"true", "false"}));
            telnetSet.addProperty(PROPERTY_LOGIN_PROMPT, "ogin: ", PropertyType.getStringPropertyType());
            telnetSet.addProperty(PROPERTY_PASSWORD_PROMPT, "assword: ", PropertyType.getStringPropertyType());
            telnetSet.addProperty(PROPERTY_COMMAND_PROMPT, "$", PropertyType.getStringPropertyType());
        }
        return telnetSet;
    }

    public static void checkCancelled(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalConnect(IProgressMonitor monitor) throws Exception {
        block6: {
            try {
                this.fireCommunicationsEvent(1);
                TelnetClient client = this.makeNewTelnetClient(monitor);
                if (client == null) break block6;
                TelnetConnectorService telnetConnectorService = this;
                synchronized (telnetConnectorService) {
                    this.fTelnetClients.add(client);
                    if (this.fSessionLostHandler == null) {
                        this.fSessionLostHandler = new SessionLostHandler((IConnectorService)this);
                    }
                }
                this.notifyConnection();
            }
            catch (Exception e) {
                if (!(e instanceof SystemMessageException)) break block6;
                this.internalDisconnect(null);
                throw e;
            }
        }
    }

    protected int getTelnetPort() {
        int port = this.getPort();
        if (port <= 0) {
            port = 23;
        }
        return port;
    }

    public TelnetClient makeNewTelnetClient(IProgressMonitor monitor) throws Exception {
        TelnetClient client = new TelnetClient();
        return this.loginTelnetClient(client, monitor);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TelnetClient loginTelnetClient(TelnetClient client, IProgressMonitor monitor) throws SystemMessageException {
        SimpleSystemMessage msg2;
        Exception nestedException;
        int status;
        block21: {
            String host = this.getHostName();
            String user = this.getUserId();
            String password = "";
            status = 100;
            nestedException = null;
            try {
                try {
                    Activator.trace("Telnet Service: Connecting.....");
                    client.connect(host, this.getTelnetPort());
                    SystemSignonInformation ssi = this.getSignonInformation();
                    if (ssi != null) {
                        password = ssi.getPassword();
                    }
                    long millisToEnd = System.currentTimeMillis() + 60000L;
                    LoginThread checkLogin = new LoginThread(user, password, client.getInputStream(), new PrintStream(client.getOutputStream()));
                    checkLogin.start();
                    while (checkLogin.isAlive() && System.currentTimeMillis() < millisToEnd) {
                        Display d;
                        if (monitor != null) {
                            monitor.worked(1);
                            if (monitor.isCanceled()) {
                                status = 250;
                                break;
                            }
                        }
                        if ((d = Display.getCurrent()) != null) {
                            while (d.readAndDispatch()) {
                            }
                        }
                        checkLogin.join(500L);
                    }
                    if (status != 250) {
                        status = checkLogin.getLoginStatus();
                        checkLogin.join();
                    }
                }
                catch (Exception e) {
                    Activator.trace("Telnet Service failed: " + e.toString());
                    nestedException = e;
                }
            }
            catch (Throwable throwable) {
                SimpleSystemMessage msg2;
                Object var13_14 = null;
                if (status == 250) {
                    Activator.trace("Telnet Service: Cancelled");
                    try {
                        client.disconnect();
                    }
                    catch (Exception exception) {}
                    client = null;
                    throw throwable;
                }
                if (status == 150) {
                    Activator.trace("Telnet Service: Connected");
                    throw throwable;
                }
                Activator.trace("Telnet Service: Connect failed");
                if (nestedException != null) {
                    msg2 = new SimpleSystemMessage("org.eclipse.rse.connectorservice.telnet", "RSEG1003", 4, CommonMessages.MSG_EXCEPTION_OCCURRED, (Throwable)nestedException);
                    throw new SystemMessageException((SystemMessage)msg2);
                }
                msg2 = new SimpleSystemMessage("org.eclipse.rse.connectorservice.telnet", "RSEC1002", 4, CommonMessages.MSG_COMM_AUTH_FAILED, NLS.bind((String)CommonMessages.MSG_COMM_AUTH_FAILED_DETAILS, (Object)this.getHost().getAliasName()));
                msg2.makeSubstitution((Object)this.getHost().getAliasName());
                throw new SystemMessageException((SystemMessage)msg2);
            }
            {
                Object var13_15 = null;
                if (status != 250) break block21;
            }
            Activator.trace("Telnet Service: Cancelled");
            try {}
            catch (Exception exception) {}
            client.disconnect();
            return null;
        }
        if (status == 150) {
            Activator.trace("Telnet Service: Connected");
            return client;
        }
        Activator.trace("Telnet Service: Connect failed");
        if (nestedException != null) {
            msg2 = new SimpleSystemMessage("org.eclipse.rse.connectorservice.telnet", "RSEG1003", 4, CommonMessages.MSG_EXCEPTION_OCCURRED, (Throwable)nestedException);
            throw new SystemMessageException((SystemMessage)msg2);
        }
        msg2 = new SimpleSystemMessage("org.eclipse.rse.connectorservice.telnet", "RSEC1002", 4, CommonMessages.MSG_COMM_AUTH_FAILED, NLS.bind((String)CommonMessages.MSG_COMM_AUTH_FAILED_DETAILS, (Object)this.getHost().getAliasName()));
        msg2.makeSubstitution((Object)this.getHost().getAliasName());
        throw new SystemMessageException((SystemMessage)msg2);
    }

    private synchronized void sessionDisconnect() {
        Activator.trace("TelnetConnectorService.sessionDisconnect");
        Iterator it = this.fTelnetClients.iterator();
        while (it.hasNext()) {
            block4: {
                TelnetClient client = (TelnetClient)it.next();
                if (client.isConnected()) {
                    try {
                        client.disconnect();
                    }
                    catch (IOException e) {
                        if (!Activator.isTracingOn()) break block4;
                        e.printStackTrace();
                    }
                }
            }
            it.remove();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int readUntil(String pattern, InputStream in) {
        try {
            char lastChar = pattern.charAt(pattern.length() - 1);
            StringBuffer sb = new StringBuffer();
            int ch = in.read();
            while (true) {
                if (ch < 0) {
                    return 200;
                }
                char tch = (char)ch;
                if (Activator.isTracingOn()) {
                    System.out.print(tch);
                }
                sb.append(tch);
                if (tch == 't' && sb.indexOf("incorrect") >= 0) {
                    return 100;
                }
                if (tch == 'd' && sb.indexOf("closed") >= 0) {
                    return 200;
                }
                if (tch == lastChar && sb.toString().endsWith(pattern)) {
                    return 150;
                }
                ch = in.read();
            }
        }
        catch (Exception e) {
            SystemBasePlugin.logError((String)(e.getMessage() == null ? e.getClass().getName() : e.getMessage()), (Throwable)e);
        }
        return 200;
    }

    public void write(String value, PrintStream out) {
        try {
            out.println(value);
            out.flush();
            if (Activator.isTracingOn()) {
                int len = value.length() + 6;
                Activator.trace("write: ******************".substring(0, len <= 24 ? len : 24));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void internalDisconnect(IProgressMonitor monitor) throws Exception {
        Activator.trace("Telnet Service: Disconnecting .....");
        boolean sessionLost = this.fSessionLostHandler != null && this.fSessionLostHandler.isSessionLost();
        this.fSessionLostHandler = null;
        if (sessionLost) {
            this.notifyError();
        } else {
            this.fireCommunicationsEvent(3);
        }
        this.sessionDisconnect();
        this.notifyDisconnection();
    }

    protected static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnected() {
        boolean anyConnected = false;
        TelnetConnectorService telnetConnectorService = this;
        synchronized (telnetConnectorService) {
            Iterator it = this.fTelnetClients.iterator();
            while (it.hasNext()) {
                TelnetClient client = (TelnetClient)it.next();
                if (client.isConnected()) {
                    anyConnected = true;
                    continue;
                }
                it.remove();
            }
        }
        if (!anyConnected && this.fSessionLostHandler != null) {
            Activator.trace("TelnetConnectorService.isConnected: false -> sessionLost");
            this.fSessionLostHandler.sessionLost();
        }
        return anyConnected;
    }

    public boolean requiresPassword() {
        return false;
    }

    public boolean requiresUserId() {
        return false;
    }

    protected boolean supportsLogin() {
        String login_required;
        boolean result = true;
        if (this.telnetPropertySet != null && (login_required = this.telnetPropertySet.getPropertyValue(PROPERTY_LOGIN_REQUIRED)) != null && login_required.equalsIgnoreCase("false")) {
            result = false;
        }
        return result;
    }

    public boolean supportsPassword() {
        return this.supportsLogin();
    }

    public boolean supportsUserId() {
        return this.supportsLogin();
    }

    private class LoginThread
    extends Thread {
        private String username;
        private String password;
        private int status = 150;
        private InputStream in;
        private PrintStream out;

        public LoginThread(String username, String password, InputStream in, PrintStream out) {
            this.username = username;
            this.password = password;
            this.in = in;
            this.out = out;
        }

        public void run() {
            TelnetConnectorService.this.telnetPropertySet = TelnetConnectorService.this.getTelnetPropertySet();
            String login_required = TelnetConnectorService.this.telnetPropertySet.getPropertyValue(TelnetConnectorService.PROPERTY_LOGIN_REQUIRED);
            String login_prompt = TelnetConnectorService.this.telnetPropertySet.getPropertyValue(TelnetConnectorService.PROPERTY_LOGIN_PROMPT);
            String password_prompt = TelnetConnectorService.this.telnetPropertySet.getPropertyValue(TelnetConnectorService.PROPERTY_PASSWORD_PROMPT);
            String command_prompt = TelnetConnectorService.this.telnetPropertySet.getPropertyValue(TelnetConnectorService.PROPERTY_COMMAND_PROMPT);
            if (Boolean.valueOf(login_required).booleanValue()) {
                this.status = 150;
                if (login_prompt != null && login_prompt.length() > 0) {
                    this.status = TelnetConnectorService.this.readUntil(login_prompt, this.in);
                    TelnetConnectorService.this.write(this.username, this.out);
                }
                if (this.status == 150 && password_prompt != null && password_prompt.length() > 0) {
                    this.status = TelnetConnectorService.this.readUntil(password_prompt, this.in);
                    TelnetConnectorService.this.write(this.password, this.out);
                }
                if (this.status == 150 && command_prompt != null && command_prompt.length() > 0) {
                    this.status = TelnetConnectorService.this.readUntil(command_prompt, this.in);
                }
            } else if (command_prompt != null && command_prompt.length() > 0) {
                this.status = TelnetConnectorService.this.readUntil(command_prompt, this.in);
            }
        }

        public int getLoginStatus() {
            return this.status;
        }
    }

    public static class SessionLostHandler
    implements Runnable,
    IRunnableWithProgress {
        private IConnectorService _connection;
        private boolean fSessionLost;

        public SessionLostHandler(IConnectorService cs) {
            this._connection = cs;
            this.fSessionLost = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sessionLost() {
            boolean showSessionLostDlg = false;
            SessionLostHandler sessionLostHandler = this;
            synchronized (sessionLostHandler) {
                if (!this.fSessionLost) {
                    this.fSessionLost = true;
                    showSessionLostDlg = true;
                }
            }
            if (showSessionLostDlg) {
                Display.getDefault().asyncExec((Runnable)this);
            }
        }

        public synchronized boolean isSessionLost() {
            return this.fSessionLost;
        }

        public void run() {
            Shell shell = this.getShell();
            SimpleSystemMessage msg = new SimpleSystemMessage("org.eclipse.rse.connectorservice.telnet", "RSEG1058", 8, NLS.bind((String)CommonMessages.MSG_CONNECT_CANCELLED, (Object)this._connection.getHost().getAliasName()));
            SystemMessageDialog dialog = new SystemMessageDialog(this.getShell(), (SystemMessage)msg);
            dialog.open();
            try {
                IRunnableContext runnableContext = this.getRunnableContext(this.getShell());
                runnableContext.run(true, true, (IRunnableWithProgress)this);
                this._connection.reset();
                ISystemRegistry sr = RSECorePlugin.getTheSystemRegistry();
                sr.connectedStatusChange(this._connection.getPrimarySubSystem(), false, true, true);
            }
            catch (InterruptedException interruptedException) {
                if (shell != null) {
                    this.showDisconnectCancelledMessage(shell, this._connection.getHostName(), this._connection.getPort());
                }
            }
            catch (InvocationTargetException invokeExc) {
                Exception exc = (Exception)invokeExc.getTargetException();
                if (shell != null) {
                    this.showDisconnectErrorMessage(shell, this._connection.getHostName(), this._connection.getPort(), exc);
                }
            }
            catch (Exception e) {
                SystemBasePlugin.logError((String)TelnetConnectorResources.TelnetConnectorService_ErrorDisconnecting, (Throwable)e);
            }
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            String message = null;
            message = SubSystemConfiguration.getDisconnectingMessage((String)this._connection.getHostName(), (int)this._connection.getPort());
            monitor.beginTask(message, -1);
            try {
                try {
                    this._connection.disconnect(monitor);
                }
                catch (Exception exc) {
                    if (exc instanceof InvocationTargetException) {
                        throw (InvocationTargetException)exc;
                    }
                    if (!(exc instanceof InterruptedException)) throw new InvocationTargetException(exc);
                    throw (InterruptedException)exc;
                }
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                monitor.done();
                throw throwable;
            }
            {
                Object var4_6 = null;
            }
            monitor.done();
        }

        public Shell getShell() {
            Shell activeShell = SystemBasePlugin.getActiveWorkbenchShell();
            if (activeShell != null) {
                return activeShell;
            }
            IWorkbenchWindow window = null;
            try {
                window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            }
            catch (Exception exception) {
                return null;
            }
            if (window == null) {
                IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
                if (windows != null && windows.length > 0) {
                    return windows[0].getShell();
                }
            } else {
                return window.getShell();
            }
            return null;
        }

        protected IRunnableContext getRunnableContext(Shell rshell) {
            Shell shell = this.getShell();
            IWorkbenchWindow win = SystemBasePlugin.getActiveWorkbenchWindow();
            if (win != null) {
                Shell winShell = RSEUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
                if (winShell != null && !winShell.isDisposed() && winShell.isVisible()) {
                    SystemBasePlugin.logInfo((String)"Using active workbench window as runnable context");
                    shell = winShell;
                    return win;
                }
                win = null;
            }
            if (shell == null || shell.isDisposed() || !shell.isVisible()) {
                SystemBasePlugin.logInfo((String)"Using progress monitor dialog with given shell as parent");
                shell = rshell;
            }
            ProgressMonitorDialog dlg = new ProgressMonitorDialog(rshell);
            return dlg;
        }

        protected void showDisconnectErrorMessage(Shell shell, String hostName, int port, Exception exc) {
            SimpleSystemMessage msg = new SimpleSystemMessage("org.eclipse.rse.connectorservice.telnet", "RSEG1061", 4, NLS.bind((String)CommonMessages.MSG_DISCONNECT_FAILED, (Object)hostName), (Throwable)exc);
            SystemMessageDialog msgDlg = new SystemMessageDialog(shell, (SystemMessage)msg);
            msgDlg.setException((Throwable)exc);
            msgDlg.open();
        }

        protected void showDisconnectCancelledMessage(Shell shell, String hostName, int port) {
            SimpleSystemMessage msg = new SimpleSystemMessage("org.eclipse.rse.connectorservice.telnet", "RSEG1062", 8, NLS.bind((String)CommonMessages.MSG_DISCONNECT_CANCELLED, (Object)hostName));
            SystemMessageDialog msgDlg = new SystemMessageDialog(shell, (SystemMessage)msg);
            msgDlg.open();
        }
    }
}

