/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.files.ui.compare;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.ZipFileStructureCreator;
import org.eclipse.compare.internal.BufferedResourceNode;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.DiffTreeViewer;
import org.eclipse.compare.structuremergeviewer.Differencer;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.compare.structuremergeviewer.IStructureComparator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rse.ui.view.ISystemEditableRemoteObject;
import org.eclipse.swt.widgets.Composite;

public class SystemCompareInput
extends CompareEditorInput {
    private static final boolean NORMALIZE_CASE = true;
    private Object fRoot;
    private List _remoteEditables = new ArrayList();
    private DiffTreeViewer _diffViewer;
    private IResource _leftResource;
    private IResource _rightResource;

    public SystemCompareInput(CompareConfiguration configuration) {
        super(configuration);
    }

    private IStructureComparator getStructure(IResource input) {
        if (input instanceof IContainer) {
            return new BufferedResourceNode(input);
        }
        if (input instanceof IFile) {
            BufferedResourceNode rn = new BufferedResourceNode(input);
            IFile file = (IFile)input;
            String type = this.normalizeCase(file.getFileExtension());
            if ("JAR".equals(type) || "ZIP".equals(type)) {
                return new ZipFileStructureCreator().getStructure((Object)rn);
            }
            return rn;
        }
        return null;
    }

    private String normalizeCase(String s) {
        if (s != null) {
            return s.toUpperCase();
        }
        return s;
    }

    public IResource getLeftResource() {
        return this._leftResource;
    }

    public IResource getRightResource() {
        return this._rightResource;
    }

    public Object prepareInput(IProgressMonitor monitor) {
        ISystemEditableRemoteObject ef1 = (ISystemEditableRemoteObject)this._remoteEditables.get(0);
        ISystemEditableRemoteObject ef2 = (ISystemEditableRemoteObject)this._remoteEditables.get(1);
        try {
            ef1.download(monitor);
            ef2.download(monitor);
            ef1.addAsListener();
            ef2.addAsListener();
            ef1.setLocalResourceProperties();
            ef2.setLocalResourceProperties();
            this._leftResource = ef1.getLocalResource();
            this._rightResource = ef2.getLocalResource();
            String format = Utilities.getString((String)"ResourceCompare.twoWay.title");
            String title = NLS.bind((String)format, (Object)this._leftResource.getName(), (Object)this._rightResource.getName());
            this.setTitle(title);
        }
        catch (Exception exception) {}
        IStructureComparator c1 = this.getStructure(this._leftResource);
        IStructureComparator c2 = this.getStructure(this._rightResource);
        Differencer d = new Differencer(){

            protected Object visit(Object parent, int description, Object ancestor, Object left, Object right) {
                return new MyDiffNode((IDiffContainer)parent, description, (ITypedElement)ancestor, (ITypedElement)left, (ITypedElement)right);
            }
        };
        this.fRoot = d.findDifferences(false, monitor, null, null, (Object)c1, (Object)c2);
        return this.fRoot;
    }

    public Viewer createDiffViewer(Composite parent) {
        this._diffViewer = new DiffTreeViewer(parent, this.getCompareConfiguration()){

            protected void fillContextMenu(IMenuManager manager) {
                super.fillContextMenu(manager);
            }
        };
        return this._diffViewer;
    }

    public void addRemoteEditable(ISystemEditableRemoteObject file) {
        this._remoteEditables.add(file);
    }

    public void saveChanges(IProgressMonitor pm) throws CoreException {
        super.saveChanges(pm);
        if (this.fRoot instanceof DiffNode) {
            try {
                this.commit((DiffNode)this.fRoot, pm);
            }
            finally {
                if (this._diffViewer != null) {
                    this._diffViewer.refresh();
                }
                this.setDirty(false);
            }
        }
    }

    private void commit(DiffNode node, IProgressMonitor pm) throws CoreException {
        IDiffElement[] children;
        ITypedElement right;
        ITypedElement left;
        if (node instanceof MyDiffNode) {
            ((MyDiffNode)node).clearDirty();
        }
        if ((left = node.getLeft()) instanceof BufferedResourceNode) {
            ((BufferedResourceNode)left).commit(pm);
        }
        if ((right = node.getRight()) instanceof BufferedResourceNode) {
            ((BufferedResourceNode)right).commit(pm);
        }
        if ((children = node.getChildren()) != null) {
            int i = 0;
            while (i < children.length) {
                IDiffElement element = children[i];
                if (element instanceof DiffNode) {
                    this.commit((DiffNode)element, pm);
                }
                ++i;
            }
        }
    }

    class MyDiffNode
    extends DiffNode {
        private boolean fDirty;
        private ITypedElement fLastId;
        private String fLastName;

        public MyDiffNode(IDiffContainer parent, int description, ITypedElement ancestor, ITypedElement left, ITypedElement right) {
            super(parent, description, ancestor, left, right);
            this.fDirty = false;
        }

        public void fireChange() {
            super.fireChange();
            SystemCompareInput.this.setDirty(true);
            this.fDirty = true;
            if (SystemCompareInput.this._diffViewer != null) {
                SystemCompareInput.this._diffViewer.refresh((Object)this);
            }
        }

        void clearDirty() {
            this.fDirty = false;
        }

        public String getName() {
            if (this.fLastName == null) {
                this.fLastName = super.getName();
            }
            if (this.fDirty) {
                return String.valueOf('<') + this.fLastName + '>';
            }
            return this.fLastName;
        }

        public ITypedElement getId() {
            ITypedElement id = super.getId();
            if (id == null) {
                return this.fLastId;
            }
            this.fLastId = id;
            return id;
        }
    }
}

