/*******************************************************************************
 * Copyright (c) 2004, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Xuan Chen (IBM) - copied and adapted from org.eclipse.core.tests.harness/FileSystemHelper
 *******************************************************************************/
package org.eclipse.rse.tests.subsystems.files;

import java.io.IOException;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.rse.subsystems.files.core.servicesubsystem.IFileServiceSubSystem;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;

/**
 * Home for file system-related utility methods. 
 */
public class FileServiceHelper {
	/** counter for generating unique random file system locations */
	protected static int nextLocationCounter = 0;
	private static final long MASK = 0x00000000FFFFFFFFL;

	/*
	 * Return the root directory for the temp dir.
	 */
	public static IPath getTempDir() {
		String tempPath = System.getProperty("java.io.tmpdir");
		try {
			tempPath = new java.io.File(tempPath).getCanonicalPath();
		} catch (IOException e) {
			//ignore and use non-canonical path
		}
		return new Path(tempPath);
	}

	/**
	 * Returns a unique location on the remote file system.  It is guaranteed that no file currently
	 * exists at that location.  The returned location will be unique with respect 
	 * to all other locations generated by this method in the current session.  
	 * If the caller creates a folder or file at this location, they are responsible for 
	 * deleting it when finished.
	 * @param fss The FileServiceSubSystem where we want to get this location
	 * @param parentPath The path of the parent folder
	 * @param baseName the name where the calculated extension will be appended to
	 * @param mon Progress Monitor needed for necessary remote query
	 * @return the generated name of this location
	 */
	public static String getRandomLocation(IFileServiceSubSystem fss, String parentPath, String baseName, IProgressMonitor mon) {
		String resultName = computeRandomLocation(fss, baseName);
		try
		{
			IRemoteFile remoteFile = fss.getRemoteFileObject(parentPath + fss.getSeparator() + resultName, mon);
			boolean fileExist = (remoteFile != null) && remoteFile.exists();
			while (fileExist) 
			{
				try 
				{
					Thread.sleep(10);
				} catch (InterruptedException e) {
				// ignore
				}
				resultName = computeRandomLocation(fss, baseName);
				remoteFile = fss.getRemoteFileObject(parentPath + fss.getSeparator() + resultName, mon);
				fileExist = (remoteFile != null) && remoteFile.exists();
			}
		}
		catch (Exception e)
		{
			return null;
		}
		return resultName;
	
	}

	public static String computeRandomLocation(IFileServiceSubSystem fss, String path) {
		long segment = (((long) ++nextLocationCounter) << 32) | (System.currentTimeMillis() & MASK);
		return path +(Long.toString(segment));
	}

}
