/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.services.clientserver.java;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.rse.internal.services.clientserver.java.AbstractAttributeInfo;
import org.eclipse.rse.internal.services.clientserver.java.AbstractCPInfo;
import org.eclipse.rse.internal.services.clientserver.java.ClassFileUTF8Reader;
import org.eclipse.rse.internal.services.clientserver.java.ClassInfo;
import org.eclipse.rse.internal.services.clientserver.java.DoubleInfo;
import org.eclipse.rse.internal.services.clientserver.java.EnhancedDataInputStream;
import org.eclipse.rse.internal.services.clientserver.java.FieldInfo;
import org.eclipse.rse.internal.services.clientserver.java.FieldRefInfo;
import org.eclipse.rse.internal.services.clientserver.java.FloatInfo;
import org.eclipse.rse.internal.services.clientserver.java.IntegerInfo;
import org.eclipse.rse.internal.services.clientserver.java.InterfaceMethodRefInfo;
import org.eclipse.rse.internal.services.clientserver.java.LongInfo;
import org.eclipse.rse.internal.services.clientserver.java.MethodInfo;
import org.eclipse.rse.internal.services.clientserver.java.MethodRefInfo;
import org.eclipse.rse.internal.services.clientserver.java.NameAndTypeInfo;
import org.eclipse.rse.internal.services.clientserver.java.StringInfo;
import org.eclipse.rse.internal.services.clientserver.java.UTF8Info;

public class BasicClassFileParser {
    private int constant_pool_count;
    private List constant_pool;
    private int this_class;
    private int interfaces_count;
    private int[] interfaces;
    private int fields_count;
    private int methods_count;
    private MethodInfo[] methods;
    private int attributes_count;
    private InputStream stream;

    public BasicClassFileParser(InputStream stream) {
        this.stream = stream;
    }

    public String getQualifiedClassName() {
        ClassInfo info = (ClassInfo)this.getCPInfo(this.this_class);
        int nameIndex = info.getNameIndex();
        String name = this.getString(nameIndex);
        return name.replace('/', '.');
    }

    public boolean isExecutable() {
        int i = 0;
        while (i < this.methods_count) {
            int descriptorIndex;
            String descriptor;
            int accessFlags;
            MethodInfo info = this.methods[i];
            int nameIndex = info.getNameIndex();
            String name = this.getString(nameIndex);
            if (name.equals("main") && ((accessFlags = info.getAccessFlags()) & 0xF) == 9 && (descriptor = this.getString(descriptorIndex = info.getDescriptorIndex())).equals("([Ljava/lang/String;)V")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void parse() throws IOException {
        EnhancedDataInputStream dataStream = new EnhancedDataInputStream(this.stream);
        dataStream.readUnsignedInt();
        dataStream.readUnsignedShort();
        dataStream.readUnsignedShort();
        this.constant_pool_count = dataStream.readUnsignedShort();
        this.readConstantPool(dataStream);
        dataStream.readUnsignedShort();
        this.this_class = dataStream.readUnsignedShort();
        dataStream.readUnsignedShort();
        this.interfaces_count = dataStream.readUnsignedShort();
        this.readInterfaces(dataStream);
        this.fields_count = dataStream.readUnsignedShort();
        this.readFields(dataStream);
        this.methods_count = dataStream.readUnsignedShort();
        this.readMethods(dataStream);
        dataStream.close();
    }

    protected void readConstantPool(EnhancedDataInputStream dataStream) throws IOException {
        this.constant_pool = new ArrayList();
        int i = 0;
        while (i < this.constant_pool_count - 1) {
            AbstractCPInfo info = this.readConstantInfo(dataStream);
            this.constant_pool.add(i, info);
            if (info instanceof LongInfo || info instanceof DoubleInfo) {
                this.constant_pool.add(++i, new Object());
            }
            ++i;
        }
    }

    protected AbstractCPInfo readConstantInfo(EnhancedDataInputStream dataStream) throws IOException {
        short tag = (short)dataStream.readUnsignedByte();
        switch (tag) {
            case 7: {
                int nameIndex = dataStream.readUnsignedShort();
                return new ClassInfo(tag, nameIndex);
            }
            case 9: {
                int classIndex = dataStream.readUnsignedShort();
                int nameAndTypeIndex = dataStream.readUnsignedShort();
                return new FieldRefInfo(tag, classIndex, nameAndTypeIndex);
            }
            case 10: {
                int classIndex = dataStream.readUnsignedShort();
                int nameAndTypeIndex = dataStream.readUnsignedShort();
                return new MethodRefInfo(tag, classIndex, nameAndTypeIndex);
            }
            case 11: {
                int classIndex = dataStream.readUnsignedShort();
                int nameAndTypeIndex = dataStream.readUnsignedShort();
                return new InterfaceMethodRefInfo(tag, classIndex, nameAndTypeIndex);
            }
            case 8: {
                int stringIndex = dataStream.readUnsignedShort();
                return new StringInfo(tag, stringIndex);
            }
            case 3: {
                long bytes = dataStream.readUnsignedInt();
                return new IntegerInfo(tag, bytes);
            }
            case 4: {
                long bytes = dataStream.readUnsignedInt();
                return new FloatInfo(tag, bytes);
            }
            case 5: {
                long highBytes = dataStream.readUnsignedInt();
                long lowBytes = dataStream.readUnsignedInt();
                return new LongInfo(tag, highBytes, lowBytes);
            }
            case 6: {
                long highBytes = dataStream.readUnsignedInt();
                long lowBytes = dataStream.readUnsignedInt();
                return new DoubleInfo(tag, highBytes, lowBytes);
            }
            case 12: {
                int nameIndex = dataStream.readUnsignedShort();
                int descriptorIndex = dataStream.readUnsignedShort();
                return new NameAndTypeInfo(tag, nameIndex, descriptorIndex);
            }
            case 1: {
                int length = dataStream.readUnsignedShort();
                short[] bytes = new short[length];
                int i = 0;
                while (i < length) {
                    bytes[i] = (short)dataStream.readUnsignedByte();
                    ++i;
                }
                return new UTF8Info(tag, length, bytes);
            }
        }
        return null;
    }

    protected void readInterfaces(EnhancedDataInputStream dataStream) throws IOException {
        this.interfaces = new int[this.interfaces_count];
        int i = 0;
        while (i < this.interfaces_count) {
            this.interfaces[i] = dataStream.readUnsignedShort();
            ++i;
        }
    }

    protected void readFields(EnhancedDataInputStream dataStream) throws IOException {
        int i = 0;
        while (i < this.fields_count) {
            this.readField(dataStream);
            ++i;
        }
    }

    protected FieldInfo readField(EnhancedDataInputStream dataStream) throws IOException {
        dataStream.readUnsignedShort();
        dataStream.readUnsignedShort();
        dataStream.readUnsignedShort();
        int attributesCount = dataStream.readUnsignedShort();
        int i = 0;
        while (i < attributesCount) {
            this.readAttribute(dataStream);
            ++i;
        }
        return null;
    }

    protected void readMethods(EnhancedDataInputStream dataStream) throws IOException {
        this.methods = new MethodInfo[this.methods_count];
        int i = 0;
        while (i < this.methods_count) {
            this.methods[i] = this.readMethod(dataStream);
            ++i;
        }
    }

    protected MethodInfo readMethod(EnhancedDataInputStream dataStream) throws IOException {
        int accessFlags = dataStream.readUnsignedShort();
        int nameIndex = dataStream.readUnsignedShort();
        int descriptorIndex = dataStream.readUnsignedShort();
        int attributesCount = dataStream.readUnsignedShort();
        int i = 0;
        while (i < attributesCount) {
            this.readAttribute(dataStream);
            ++i;
        }
        return new MethodInfo(accessFlags, nameIndex, descriptorIndex, this.attributes_count, null);
    }

    protected AbstractAttributeInfo readAttribute(EnhancedDataInputStream dataStream) throws IOException {
        dataStream.skip(2L);
        long length = dataStream.readUnsignedInt();
        if (length > 0L) {
            dataStream.skip(length);
        }
        return null;
    }

    protected AbstractCPInfo getCPInfo(int index) {
        return (AbstractCPInfo)this.constant_pool.get(index - 1);
    }

    protected String getString(int index) {
        UTF8Info nameInfo = (UTF8Info)this.getCPInfo(index);
        String name = ClassFileUTF8Reader.getInstance().getString(nameInfo.getBytes());
        return name;
    }
}

