/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.core.filters;

import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.rse.core.filters.ISystemFilter;
import org.eclipse.rse.core.filters.ISystemFilterPool;
import org.eclipse.rse.core.filters.ISystemFilterPoolManager;
import org.eclipse.rse.core.filters.ISystemFilterPoolManagerProvider;
import org.eclipse.rse.core.filters.ISystemFilterPoolReference;
import org.eclipse.rse.core.filters.ISystemFilterPoolReferenceManager;
import org.eclipse.rse.core.filters.ISystemFilterPoolReferenceManagerProvider;
import org.eclipse.rse.core.filters.ISystemFilterReference;
import org.eclipse.rse.core.model.IRSEPersistableContainer;
import org.eclipse.rse.core.references.IRSEBasePersistableReferencingObject;
import org.eclipse.rse.core.references.IRSEPersistableReferencingObject;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.internal.core.filters.SystemFilterPoolReference;
import org.eclipse.rse.internal.references.SystemPersistableReferenceManager;

public class SystemFilterPoolReferenceManager
extends SystemPersistableReferenceManager
implements ISystemFilterPoolReferenceManager {
    private ISystemFilterPoolManagerProvider poolMgrProvider = null;
    private ISystemFilterPoolManager defaultPoolMgr = null;
    private ISystemFilterPoolReferenceManagerProvider caller = null;
    private Object mgrData = null;
    private boolean initialized = false;
    private boolean noEvents;
    private boolean fireEvents = true;
    private ISystemFilterPoolReference[] fpRefsArray = null;
    private static final ISystemFilterPoolReference[] emptyFilterPoolRefArray = new ISystemFilterPoolReference[0];

    public static ISystemFilterPoolReferenceManager createSystemFilterPoolReferenceManager(ISystemFilterPoolReferenceManagerProvider caller, ISystemFilterPoolManagerProvider relatedPoolManagerProvider, String name) {
        SystemFilterPoolReferenceManager mgr = null;
        if (mgr == null) {
            mgr = SystemFilterPoolReferenceManager.createManager();
        }
        if (mgr != null) {
            mgr.initialize(caller, name, relatedPoolManagerProvider);
        }
        return mgr;
    }

    protected static SystemFilterPoolReferenceManager createManager() {
        SystemFilterPoolReferenceManager mgr = new SystemFilterPoolReferenceManager();
        return mgr;
    }

    protected void initialize(ISystemFilterPoolReferenceManagerProvider caller, String name, ISystemFilterPoolManagerProvider relatedPoolManagerProvider) {
        if (!this.initialized) {
            this.initialize(caller, name);
        }
        this.setSystemFilterPoolManagerProvider(relatedPoolManagerProvider);
    }

    protected void initialize(ISystemFilterPoolReferenceManagerProvider caller, String name) {
        this.setProvider(caller);
        this.setName(name);
        this.initialized = true;
    }

    private void invalidateFilterPoolReferencesCache() {
        this.fpRefsArray = null;
        this.invalidateCache();
    }

    public void setSystemFilterPoolManagerProvider(ISystemFilterPoolManagerProvider poolMgrProvider) {
        this.poolMgrProvider = poolMgrProvider;
    }

    public ISystemFilterPoolManagerProvider getSystemFilterPoolManagerProvider() {
        return this.poolMgrProvider;
    }

    public ISystemFilterPoolManager[] getSystemFilterPoolManagers() {
        ISystemFilterPoolManager[] result = new ISystemFilterPoolManager[]{};
        if (this.poolMgrProvider != null) {
            result = this.poolMgrProvider.getSystemFilterPoolManagers();
        }
        return result;
    }

    public ISystemFilterPoolManager[] getAdditionalSystemFilterPoolManagers() {
        ISystemFilterPoolManager[] poolMgrs = this.getSystemFilterPoolManagers();
        Vector<ISystemFilterPoolManager> v = new Vector<ISystemFilterPoolManager>();
        ISystemFilterPoolReference[] fpRefs = this.getSystemFilterPoolReferences();
        int idx = 0;
        while (idx < fpRefs.length) {
            ISystemFilterPoolManager mgr;
            ISystemFilterPool pool = fpRefs[idx].getReferencedFilterPool();
            if (pool != null && !this.managerExists(poolMgrs, mgr = pool.getSystemFilterPoolManager()) && !v.contains(mgr)) {
                System.out.println("Found unmatched manager: " + mgr.getName());
                v.addElement(mgr);
            }
            ++idx;
        }
        ISystemFilterPoolManager[] additionalMgrs = null;
        if (v.size() > 0) {
            additionalMgrs = new ISystemFilterPoolManager[v.size()];
            int idx2 = 0;
            while (idx2 < v.size()) {
                additionalMgrs[idx2] = (ISystemFilterPoolManager)v.elementAt(idx2);
                ++idx2;
            }
        }
        return additionalMgrs;
    }

    private boolean managerExists(ISystemFilterPoolManager[] mgrs, ISystemFilterPoolManager mgr) {
        boolean match = false;
        int idx = 0;
        while (!match && idx < mgrs.length) {
            if (mgr == mgrs[idx]) {
                match = true;
            }
            ++idx;
        }
        return match;
    }

    public void setDefaultSystemFilterPoolManager(ISystemFilterPoolManager mgr) {
        this.defaultPoolMgr = mgr;
    }

    public ISystemFilterPoolManager getDefaultSystemFilterPoolManager() {
        return this.defaultPoolMgr;
    }

    public ISystemFilterPoolReferenceManagerProvider getProvider() {
        return this.caller;
    }

    public void setProvider(ISystemFilterPoolReferenceManagerProvider caller) {
        this.caller = caller;
    }

    public void setProviderEventNotification(boolean fireEvents) {
        this.fireEvents = fireEvents;
    }

    public void setSystemFilterPoolReferenceManagerData(Object data) {
        this.mgrData = data;
    }

    public Object getSystemFilterPoolReferenceManagerData() {
        return this.mgrData;
    }

    public void regenerateReferencedSystemFilterPoolNames() {
        ISystemFilterPoolReference[] fpRefs = this.getSystemFilterPoolReferences();
        int idx = 0;
        while (idx < fpRefs.length) {
            ISystemFilterPool pool = fpRefs[idx].getReferencedFilterPool();
            if (pool != null) {
                fpRefs[idx].resetReferencedFilterPoolName(pool.getReferenceName());
            }
            ++idx;
        }
        this.invalidateFilterPoolReferencesCache();
    }

    public ISystemFilterPoolReference[] getSystemFilterPoolReferences() {
        IRSEBasePersistableReferencingObject[] refObjs = super.getReferencingObjects();
        if (refObjs.length == 0) {
            return emptyFilterPoolRefArray;
        }
        if (this.fpRefsArray == null || this.fpRefsArray.length != refObjs.length) {
            this.fpRefsArray = new ISystemFilterPoolReference[refObjs.length];
            int idx = 0;
            while (idx < this.fpRefsArray.length) {
                this.fpRefsArray[idx] = (ISystemFilterPoolReference)refObjs[idx];
                ++idx;
            }
        }
        return this.fpRefsArray;
    }

    public void setSystemFilterPoolReferences(ISystemFilterPoolReference[] filterPoolReferences, boolean deReference) {
        super.setReferencingObjects(filterPoolReferences, deReference);
        this.invalidateFilterPoolReferencesCache();
        if (this.fireEvents && this.caller != null) {
            this.caller.filterEventFilterPoolReferencesReset();
        }
    }

    private ISystemFilterPoolReference createSystemFilterPoolReference(ISystemFilterPool filterPool) {
        SystemFilterPoolReference filterPoolReference = new SystemFilterPoolReference(filterPool);
        filterPoolReference.setParentReferenceManager(this);
        this.invalidateFilterPoolReferencesCache();
        return filterPoolReference;
    }

    private ISystemFilterPoolReference createSystemFilterPoolReference(String filterPoolName) {
        SystemFilterPoolReference filterPoolReference = new SystemFilterPoolReference(filterPoolName);
        filterPoolReference.setParentReferenceManager(this);
        this.invalidateFilterPoolReferencesCache();
        return filterPoolReference;
    }

    public int addSystemFilterPoolReference(ISystemFilterPoolReference filterPoolReference) {
        int count = this.addReferencingObject(filterPoolReference);
        filterPoolReference.setParentReferenceManager(this);
        this.invalidateFilterPoolReferencesCache();
        return count;
    }

    public void resetSystemFilterPoolReference(ISystemFilterPoolReference filterPoolReference, ISystemFilterPool newPool) {
        filterPoolReference.removeReference();
        filterPoolReference.setReferencedObject(newPool);
        if (this.fireEvents && this.caller != null) {
            this.caller.filterEventFilterPoolReferenceReset(filterPoolReference);
        }
    }

    public int removeSystemFilterPoolReference(ISystemFilterPoolReference filterPoolReference, boolean deReference) {
        int count = 0;
        count = !deReference ? super.removeReferencingObject(filterPoolReference) : super.removeAndDeReferenceReferencingObject(filterPoolReference);
        this.invalidateFilterPoolReferencesCache();
        if (this.fireEvents && this.caller != null) {
            this.caller.filterEventFilterPoolReferenceDeleted(filterPoolReference);
        }
        return count;
    }

    public int getSystemFilterPoolReferenceCount() {
        return super.getReferencingObjectCount();
    }

    public int getSystemFilterPoolReferencePosition(ISystemFilterPoolReference filterPoolRef) {
        return super.getReferencingObjectPosition(filterPoolRef);
    }

    public void moveSystemFilterPoolReference(ISystemFilterPoolReference filterPoolRef, int pos) {
        int oldPos = this.getReferencingObjectPosition(filterPoolRef);
        this.moveReferencingObjectPosition(pos, filterPoolRef);
        this.invalidateFilterPoolReferencesCache();
        if (this.fireEvents && this.caller != null && !this.noEvents) {
            ISystemFilterPoolReference[] refs = new ISystemFilterPoolReference[]{filterPoolRef};
            this.caller.filterEventFilterPoolReferencesRePositioned(refs, pos - oldPos);
        }
        if (this.caller instanceof IRSEPersistableContainer) {
            ((IRSEPersistableContainer)((Object)this.caller)).setDirty(true);
        }
    }

    public void moveSystemFilterPoolReferences(ISystemFilterPoolReference[] filterPoolRefs, int delta) {
        int[] oldPositions = new int[filterPoolRefs.length];
        this.noEvents = true;
        int idx = 0;
        while (idx < filterPoolRefs.length) {
            oldPositions[idx] = this.getSystemFilterPoolReferencePosition(filterPoolRefs[idx]);
            ++idx;
        }
        if (delta > 0) {
            idx = filterPoolRefs.length - 1;
            while (idx >= 0) {
                this.moveSystemFilterPoolReference(filterPoolRefs[idx], oldPositions[idx] + delta);
                --idx;
            }
        } else {
            idx = 0;
            while (idx < filterPoolRefs.length) {
                this.moveSystemFilterPoolReference(filterPoolRefs[idx], oldPositions[idx] + delta);
                ++idx;
            }
        }
        this.invalidateFilterPoolReferencesCache();
        this.noEvents = false;
        if (this.fireEvents && this.caller != null) {
            this.caller.filterEventFilterPoolReferencesRePositioned(filterPoolRefs, delta);
        }
    }

    public ISystemFilterPool[] getReferencedSystemFilterPools() {
        ISystemFilterPoolReference[] refs = this.getSystemFilterPoolReferences();
        ArrayList<ISystemFilterPool> pools = new ArrayList<ISystemFilterPool>(refs.length);
        int idx = 0;
        while (idx < refs.length) {
            ISystemFilterPool pool = refs[idx].getReferencedFilterPool();
            if (pool != null) {
                pools.add(pool);
            }
            ++idx;
        }
        ISystemFilterPool[] result = new ISystemFilterPool[pools.size()];
        pools.toArray(result);
        return result;
    }

    public boolean isSystemFilterPoolReferenced(ISystemFilterPool filterPool) {
        return super.isReferenced(filterPool);
    }

    public ISystemFilterPoolReference getReferenceToSystemFilterPool(ISystemFilterPool filterPool) {
        return (ISystemFilterPoolReference)super.getReferencedObject(filterPool);
    }

    public ISystemFilterPoolReference addReferenceToSystemFilterPool(ISystemFilterPool filterPool) {
        ISystemFilterPoolReference filterPoolReference = this.createSystemFilterPoolReference(filterPool);
        this.addReferencingObject(filterPoolReference);
        filterPoolReference.setParentReferenceManager(this);
        this.invalidateFilterPoolReferencesCache();
        if (this.fireEvents && this.caller != null) {
            this.caller.filterEventFilterPoolReferenceCreated(filterPoolReference);
        }
        return filterPoolReference;
    }

    public ISystemFilterPoolReference addReferenceToSystemFilterPool(String filterPoolName) {
        ISystemFilterPoolReference filterPoolReference = this.createSystemFilterPoolReference(filterPoolName);
        this.addReferencingObject(filterPoolReference);
        filterPoolReference.setParentReferenceManager(this);
        this.invalidateFilterPoolReferencesCache();
        if (this.fireEvents && this.caller != null) {
            this.caller.filterEventFilterPoolReferenceCreated(filterPoolReference);
        }
        return filterPoolReference;
    }

    public int removeReferenceToSystemFilterPool(ISystemFilterPool filterPool) {
        ISystemFilterPoolReference filterPoolReference = this.getReferenceToSystemFilterPool(filterPool);
        int newCount = 0;
        if (filterPoolReference != null) {
            filterPoolReference.removeReference();
            newCount = this.removeReferencingObject(filterPoolReference);
            this.invalidateFilterPoolReferencesCache();
            if (this.fireEvents && this.caller != null) {
                this.caller.filterEventFilterPoolReferenceDeleted(filterPoolReference);
            }
        } else {
            newCount = this.getSystemFilterPoolReferenceCount();
        }
        return newCount;
    }

    public void renameReferenceToSystemFilterPool(ISystemFilterPool pool) {
        IRSEPersistableReferencingObject poolRef = null;
        IRSEBasePersistableReferencingObject[] refs = this.getReferencingObjects();
        int idx = 0;
        while (poolRef == null && idx < refs.length) {
            if (refs[idx].getReferencedObject() == pool) {
                poolRef = (ISystemFilterPoolReference)refs[idx];
            }
            ++idx;
        }
        if (poolRef != null) {
            String oldName = poolRef.getReferencedObjectName();
            poolRef.resetReferencedFilterPoolName(pool.getReferenceName());
            this.invalidateFilterPoolReferencesCache();
            if (this.fireEvents && this.caller != null) {
                this.caller.filterEventFilterPoolReferenceRenamed((ISystemFilterPoolReference)poolRef, oldName);
            }
        }
    }

    public void setSystemFilterPoolReferences(ISystemFilterPool[] filterPools, boolean deReference) {
        if (deReference) {
            super.removeAndDeReferenceAllReferencingObjects();
        } else {
            this.removeAllReferencingObjects();
        }
        if (filterPools != null) {
            int idx = 0;
            while (idx < filterPools.length) {
                ISystemFilterPoolReference filterPoolReference = this.createSystemFilterPoolReference(filterPools[idx]);
                this.addReferencingObject(filterPoolReference);
                filterPoolReference.setParentReferenceManager(this);
                ++idx;
            }
            this.invalidateFilterPoolReferencesCache();
            if (this.fireEvents && this.caller != null) {
                this.caller.filterEventFilterPoolReferencesReset();
            }
        }
    }

    public ISystemFilterReference getSystemFilterReference(ISubSystem subSystem, ISystemFilter filter) {
        ISystemFilterPool pool = filter.getParentFilterPool();
        ISystemFilterPoolReference poolRef = this.getReferenceToSystemFilterPool(pool);
        if (poolRef != null) {
            return poolRef.getSystemFilterReference(subSystem, filter);
        }
        return null;
    }

    public ISystemFilterReference[] getSystemFilterReferences(ISubSystem subSystem) {
        ISystemFilterPoolReference[] poolRefs = this.getSystemFilterPoolReferences();
        Vector<ISystemFilterReference> v = new Vector<ISystemFilterReference>();
        int idx = 0;
        while (idx < poolRefs.length) {
            ISystemFilterReference[] filterRefs = poolRefs[idx].getSystemFilterReferences(subSystem);
            int jdx = 0;
            while (jdx < filterRefs.length) {
                v.addElement(filterRefs[jdx]);
                ++jdx;
            }
            ++idx;
        }
        ISystemFilterReference[] allRefs = new ISystemFilterReference[v.size()];
        int idx2 = 0;
        while (idx2 < v.size()) {
            allRefs[idx2] = (ISystemFilterReference)v.elementAt(idx2);
            ++idx2;
        }
        return allRefs;
    }

    public int getSystemFilterReferencePosition(ISystemFilterReference filterRef) {
        ISystemFilterPoolReference[] poolRefs = this.getSystemFilterPoolReferences();
        int match = -1;
        int totalCount = 0;
        int idx = 0;
        while (match == -1 && idx < poolRefs.length) {
            ISystemFilterReference[] filterRefs = poolRefs[idx].getSystemFilterReferences(filterRef.getSubSystem());
            int jdx = 0;
            while (match == -1 && jdx < filterRefs.length) {
                if (filterRefs[jdx] == filterRef) {
                    match = totalCount;
                } else {
                    ++totalCount;
                }
                ++jdx;
            }
            ++idx;
        }
        return match;
    }

    public int getSystemFilterReferencePosition(ISubSystem subSystem, ISystemFilter filter) {
        ISystemFilterPoolReference[] poolRefs = this.getSystemFilterPoolReferences();
        int match = -1;
        int totalCount = 0;
        int idx = 0;
        while (match == -1 && idx < poolRefs.length) {
            ISystemFilterReference[] filterRefs = poolRefs[idx].getSystemFilterReferences(subSystem);
            int jdx = 0;
            while (match == -1 && jdx < filterRefs.length) {
                if (filterRefs[jdx].getReferencedFilter() == filter) {
                    match = totalCount;
                } else {
                    ++totalCount;
                }
                ++jdx;
            }
            ++idx;
        }
        return match;
    }

    public static ISystemFilterPool getFilterPool(ISystemFilterPoolManager[] mgrs, String mgrName, String poolName) {
        ISystemFilterPoolManager mgr = SystemFilterPoolReferenceManager.getFilterPoolManager(mgrs, mgrName);
        if (mgr == null) {
            return null;
        }
        return mgr.getSystemFilterPool(poolName);
    }

    public static ISystemFilterPoolManager getFilterPoolManager(ISystemFilterPoolManager[] mgrs, String mgrName) {
        ISystemFilterPoolManager mgr = null;
        int idx = 0;
        while (mgr == null && idx < mgrs.length) {
            if (mgrs[idx].getName().equals(mgrName)) {
                mgr = mgrs[idx];
            }
            ++idx;
        }
        return mgr;
    }

    public String toString() {
        return this.getName();
    }
}

