/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.ui.view.team;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.IPropertySet;
import org.eclipse.rse.core.model.IPropertySetContainer;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.core.subsystems.ISubSystemConfigurationProxy;
import org.eclipse.rse.core.subsystems.SubSystemConfiguration;
import org.eclipse.rse.internal.ui.SystemResources;
import org.eclipse.rse.internal.ui.view.SystemViewResources;
import org.eclipse.rse.internal.ui.view.team.SystemTeamViewCategoryNode;
import org.eclipse.rse.internal.ui.view.team.SystemTeamViewPropertySetNode;
import org.eclipse.rse.internal.ui.view.team.SystemTeamViewSubSystemConfigurationNode;
import org.eclipse.rse.ui.SystemMenuManager;
import org.eclipse.rse.ui.view.AbstractSystemViewAdapter;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class SystemTeamViewCategoryAdapter
extends AbstractSystemViewAdapter {
    private boolean actionsCreated = false;
    private static PropertyDescriptor[] propertyDescriptorArray = null;

    public void addActions(SystemMenuManager menu, IStructuredSelection selection, Shell shell, String menuGroup) {
        if (!this.actionsCreated) {
            this.createActions();
        }
    }

    private void createActions() {
        this.actionsCreated = true;
    }

    public ImageDescriptor getImageDescriptor(Object element) {
        SystemTeamViewCategoryNode category = (SystemTeamViewCategoryNode)element;
        return category.getImageDescriptor();
    }

    public String getText(Object element) {
        SystemTeamViewCategoryNode category = (SystemTeamViewCategoryNode)element;
        return category.getLabel();
    }

    public String getName(Object element) {
        SystemTeamViewCategoryNode category = (SystemTeamViewCategoryNode)element;
        return category.getLabel();
    }

    public String getAbsoluteName(Object element) {
        SystemTeamViewCategoryNode category = (SystemTeamViewCategoryNode)element;
        return category.getProfile() + "." + category.getLabel();
    }

    public String getType(Object element) {
        return SystemViewResources.RESID_PROPERTY_TEAM_CATEGORY_TYPE_VALUE;
    }

    public String getStatusLineText(Object element) {
        SystemTeamViewCategoryNode category = (SystemTeamViewCategoryNode)element;
        return String.valueOf(SystemResources.RESID_TEAMVIEW_CATEGORY_VALUE) + ": " + category.getLabel() + " - " + category.getDescription();
    }

    public Object getParent(Object element) {
        SystemTeamViewCategoryNode category = (SystemTeamViewCategoryNode)element;
        return category.getProfile();
    }

    public Object[] getChildren(IAdaptable element, IProgressMonitor monitor) {
        SystemTeamViewCategoryNode category = (SystemTeamViewCategoryNode)element;
        ISystemProfile profile = category.getProfile();
        String categoryType = category.getMementoHandle();
        if (categoryType.equals("conns")) {
            return profile.getHosts();
        }
        if (categoryType.equals("propertysets")) {
            return this.createSystemTeamViewPropertySetNodes((IPropertySetContainer)profile, category);
        }
        return this.createSubSystemConfigurationNodes(profile, category);
    }

    private SystemTeamViewSubSystemConfigurationNode[] createSubSystemConfigurationNodes(ISystemProfile profile, SystemTeamViewCategoryNode category) {
        ISystemRegistry sr = RSECorePlugin.getTheSystemRegistry();
        final List<ISubSystemConfigurationProxy> proxies = Arrays.asList(sr.getSubSystemConfigurationProxies());
        Comparator comparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                SubSystemConfiguration c1 = (SubSystemConfiguration)o1;
                SubSystemConfiguration c2 = (SubSystemConfiguration)o2;
                ISubSystemConfigurationProxy proxy1 = c1.getSubSystemConfigurationProxy();
                ISubSystemConfigurationProxy proxy2 = c2.getSubSystemConfigurationProxy();
                Integer p1 = new Integer(proxies.indexOf(proxy1));
                Integer p2 = new Integer(proxies.indexOf(proxy2));
                int result = p1.compareTo(p2);
                return result;
            }
        };
        TreeSet<ISubSystemConfiguration> activeSubsystemConfigurations = new TreeSet<ISubSystemConfiguration>(comparator);
        for (ISubSystemConfigurationProxy proxy : proxies) {
            if (!proxy.isSubSystemConfigurationActive()) continue;
            ISubSystemConfiguration config = proxy.getSubSystemConfiguration();
            activeSubsystemConfigurations.add(config);
        }
        ArrayList<SystemTeamViewSubSystemConfigurationNode> nodes = new ArrayList<SystemTeamViewSubSystemConfigurationNode>();
        String categoryType = category.getMementoHandle();
        for (ISubSystemConfiguration ssf : activeSubsystemConfigurations) {
            boolean createNode = false;
            if (categoryType.equals("pools")) {
                createNode = ssf.supportsFilters() && profile.getFilterPools(ssf).length > 0;
            } else if (categoryType.equals("targets")) {
                createNode = ssf.supportsTargets();
            }
            if (!createNode) continue;
            nodes.add(new SystemTeamViewSubSystemConfigurationNode(profile, category, ssf));
        }
        SystemTeamViewSubSystemConfigurationNode[] result = new SystemTeamViewSubSystemConfigurationNode[nodes.size()];
        nodes.toArray(result);
        return result;
    }

    private SystemTeamViewPropertySetNode[] createSystemTeamViewPropertySetNodes(IPropertySetContainer profile, SystemTeamViewCategoryNode category) {
        IPropertySet[] propertySets = profile.getPropertySets();
        if (propertySets == null || propertySets.length == 0) {
            return new SystemTeamViewPropertySetNode[0];
        }
        ArrayList<SystemTeamViewPropertySetNode> nodes = new ArrayList<SystemTeamViewPropertySetNode>();
        int i = 0;
        while (i < propertySets.length) {
            nodes.add(new SystemTeamViewPropertySetNode(profile, propertySets[i]));
            ++i;
        }
        SystemTeamViewPropertySetNode[] result = new SystemTeamViewPropertySetNode[nodes.size()];
        nodes.toArray(result);
        return result;
    }

    public boolean hasChildren(IAdaptable element) {
        return true;
    }

    protected IPropertyDescriptor[] internalGetPropertyDescriptors() {
        return propertyDescriptorArray;
    }

    public Object internalGetPropertyValue(Object key) {
        return null;
    }

    public String getMementoHandle(Object element) {
        SystemTeamViewCategoryNode category = (SystemTeamViewCategoryNode)element;
        return category.getMementoHandle();
    }

    public String getMementoHandleKey(Object element) {
        SystemTeamViewCategoryNode category = (SystemTeamViewCategoryNode)element;
        return String.valueOf(category.getProfile().getName()) + "." + category.getLabel();
    }

    public boolean isRemote(Object element) {
        return false;
    }
}

