/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.useractions.ui.compile;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.internal.ui.view.SystemViewMenuListener;
import org.eclipse.rse.internal.useractions.api.files.compile.ISystemCompileManagerAdapter;
import org.eclipse.rse.internal.useractions.api.ui.compile.SystemCompileAction;
import org.eclipse.rse.internal.useractions.ui.compile.SystemCompileCommand;
import org.eclipse.rse.internal.useractions.ui.compile.SystemCompileManager;
import org.eclipse.rse.internal.useractions.ui.compile.SystemCompileProfile;
import org.eclipse.rse.internal.useractions.ui.compile.SystemCompileType;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.actions.ISystemViewMenuListener;
import org.eclipse.rse.ui.actions.SystemBaseDummyAction;
import org.eclipse.rse.ui.actions.SystemBaseSubMenuAction;
import org.eclipse.rse.ui.view.ISystemRemoteElementAdapter;
import org.eclipse.rse.ui.view.SystemAdapterHelpers;
import org.eclipse.swt.widgets.Shell;

public class SystemCompileCascadeByProfileAction
extends SystemBaseSubMenuAction
implements IMenuListener {
    private ISystemProfile profile;
    private Object firstSelection;
    private boolean isPrompt;

    public SystemCompileCascadeByProfileAction(Shell shell, Object firstSelection, ISystemProfile profile, boolean isPrompt) {
        super(profile.getName(), RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.systemprofileIcon"), shell);
        this.profile = profile;
        this.firstSelection = firstSelection;
        this.isPrompt = isPrompt;
        this.setCreateMenuEachTime(false);
        this.setPopulateMenuEachTime(true);
    }

    public IMenuManager populateSubMenu(IMenuManager menu) {
        menu.addMenuListener((IMenuListener)this);
        menu.setRemoveAllWhenShown(true);
        menu.add((IAction)new SystemBaseDummyAction());
        return menu;
    }

    public void menuAboutToShow(IMenuManager ourSubMenu) {
        Shell shell = this.getShell();
        SystemCompileCascadeByProfileAction.populateMenuWithCompileActions(ourSubMenu, shell, this.profile, this.firstSelection, this.isPrompt);
    }

    protected ISystemViewMenuListener createMnemonicsListener(boolean setMnemonicsOnlyOnce) {
        return new SystemViewMenuListener(false);
    }

    public static IMenuManager populateMenuWithCompileActions(IMenuManager ourSubMenu, Shell shell, ISystemProfile profile, Object firstSelection, boolean isPrompt) {
        SystemCompileManager thisCompileManager;
        SystemCompileProfile compileProfile;
        SystemCompileType compileType;
        ISystemCompileManagerAdapter adapter;
        String srcType = null;
        ISystemRemoteElementAdapter rmtAdapter = SystemAdapterHelpers.getRemoteAdapter((Object)firstSelection);
        if (rmtAdapter != null) {
            srcType = rmtAdapter.getRemoteSourceType(firstSelection);
            if (srcType == null) {
                srcType = "null";
            } else if (srcType.equals("")) {
                srcType = "blank";
            }
        } else {
            return ourSubMenu;
        }
        ISubSystem subsystem = rmtAdapter.getSubSystem(firstSelection);
        ISubSystemConfiguration ssc = subsystem.getSubSystemConfiguration();
        SystemCompileManager compileManager = null;
        if (firstSelection instanceof IAdaptable && (adapter = (ISystemCompileManagerAdapter)((IAdaptable)firstSelection).getAdapter(ISystemCompileManagerAdapter.class)) != null) {
            compileManager = adapter.getSystemCompileManager(ssc);
        }
        if (compileManager != null && (compileType = (compileProfile = (thisCompileManager = compileManager).getCompileProfile(profile)).getCompileType(srcType)) != null) {
            SystemCompileCommand[] cmds = compileType.getCompileCommandsArray();
            int idx = 0;
            while (idx < cmds.length) {
                SystemCompileAction action = new SystemCompileAction(shell, cmds[idx], isPrompt);
                ourSubMenu.add((IAction)action);
                ++idx;
            }
        }
        return ourSubMenu;
    }
}

