/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.tm.internal.terminal.actions.ActionMessages;
import org.eclipse.tm.internal.terminal.actions.ShowTerminalConnectionAction;
import org.eclipse.tm.internal.terminal.view.ITerminalViewConnection;
import org.eclipse.tm.internal.terminal.view.ITerminalViewConnectionManager;
import org.eclipse.tm.internal.terminal.view.TerminalViewPlugin;

public class TerminalActionSelectionDropDown
extends Action
implements IMenuCreator,
ITerminalViewConnectionManager.ITerminalViewConnectionListener {
    private ITerminalViewConnectionManager fConnections;
    private Menu fMenu;

    public TerminalActionSelectionDropDown(ITerminalViewConnectionManager view) {
        this.fConnections = view;
        this.setText(ActionMessages.ConsoleDropDownAction_0);
        this.setToolTipText(ActionMessages.ConsoleDropDownAction_1);
        this.setImageDescriptor(TerminalViewPlugin.getDefault().getImageRegistry().getDescriptor("TerminalView"));
        this.setMenuCreator(this);
        this.fConnections.addListener(this);
        this.connectionsChanged();
    }

    public void dispose() {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
        this.fConnections.removeListener(this);
        this.fConnections = null;
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    public Menu getMenu(Control parent) {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
        this.fMenu = new Menu(parent);
        ITerminalViewConnection[] consoles = this.fConnections.getConnections();
        ITerminalViewConnection active = this.fConnections.getActiveConnection();
        int i = 0;
        while (i < consoles.length) {
            ITerminalViewConnection console = consoles[i];
            ShowTerminalConnectionAction action = new ShowTerminalConnectionAction(this.fConnections, console);
            action.setChecked(console.equals(active));
            this.addActionToMenu(this.fMenu, action, i + 1);
            ++i;
        }
        return this.fMenu;
    }

    private void addActionToMenu(Menu parent, Action action, int accelerator) {
        if (accelerator < 10) {
            StringBuffer label = new StringBuffer();
            label.append('&');
            label.append(accelerator);
            label.append(' ');
            label.append(action.getText());
            action.setText(label.toString());
        }
        ActionContributionItem item = new ActionContributionItem((IAction)action);
        item.fill(parent, -1);
    }

    public void run() {
        this.fConnections.swapConnection();
    }

    public void connectionsChanged() {
        this.setEnabled(this.fConnections.size() > 1);
    }
}

