/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.core.internal.flow;

import org.jacoco.core.internal.flow.IClassProbesVisitor;
import org.jacoco.core.internal.flow.IMethodProbesVisitor;
import org.jacoco.core.internal.flow.IProbeIdGenerator;
import org.jacoco.core.internal.flow.LabelFlowAnalyzer;
import org.jacoco.core.internal.flow.MethodProbesAdapter;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.EmptyVisitor;
import org.objectweb.asm.commons.JSRInlinerAdapter;

public class ClassProbesAdapter
extends ClassAdapter
implements IProbeIdGenerator {
    private static final IMethodProbesVisitor EMPTY_BLOCK_METHOD_VISITOR;
    private final IClassProbesVisitor cv;
    private int counter = 0;
    private boolean interfaceType;

    public ClassProbesAdapter(IClassProbesVisitor cv) {
        super(cv);
        this.cv = cv;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.interfaceType = (access & 0x200) != 0;
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public final MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        IMethodProbesVisitor mv = this.cv.visitMethod(access, name, desc, signature, exceptions);
        final IMethodProbesVisitor methodProbes = mv == null ? EMPTY_BLOCK_METHOD_VISITOR : mv;
        return new JSRInlinerAdapter(null, access, name, desc, signature, exceptions){

            public void visitEnd() {
                super.visitEnd();
                this.accept(new LabelFlowAnalyzer());
                if (ClassProbesAdapter.this.interfaceType) {
                    ProbeCounter counter = new ProbeCounter();
                    this.accept(new MethodProbesAdapter(EMPTY_BLOCK_METHOD_VISITOR, counter));
                    ClassProbesAdapter.this.cv.visitTotalProbeCount(counter.count);
                }
                this.accept(new MethodProbesAdapter(methodProbes, ClassProbesAdapter.this));
            }
        };
    }

    public void visitEnd() {
        if (!this.interfaceType) {
            this.cv.visitTotalProbeCount(this.counter);
        }
        super.visitEnd();
    }

    public int nextId() {
        return this.counter++;
    }

    static {
        class Impl
        extends EmptyVisitor
        implements IMethodProbesVisitor {
            Impl() {
            }

            public void visitProbe(int probeId) {
            }

            public void visitJumpInsnWithProbe(int opcode, Label label, int probeId) {
            }

            public void visitInsnWithProbe(int opcode, int probeId) {
            }

            public void visitTableSwitchInsnWithProbes(int min, int max, Label dflt, Label[] labels) {
            }

            public void visitLookupSwitchInsnWithProbes(Label dflt, int[] keys, Label[] labels) {
            }
        }
        EMPTY_BLOCK_METHOD_VISITOR = new Impl();
    }

    private static class ProbeCounter
    implements IProbeIdGenerator {
        int count = 0;

        private ProbeCounter() {
        }

        public int nextId() {
            return this.count++;
        }
    }
}

