/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.provisional.api;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.tm.internal.terminal.control.impl.TerminalPlugin;

public final class Logger {
    public static final String TRACE_DEBUG_LOG = "org.eclipse.tm.terminal/debug/log";
    public static final String TRACE_DEBUG_LOG_ERROR = "org.eclipse.tm.terminal/debug/log/error";
    public static final String TRACE_DEBUG_LOG_INFO = "org.eclipse.tm.terminal/debug/log/info";
    public static final String TRACE_DEBUG_LOG_CHAR = "org.eclipse.tm.terminal/debug/log/char";
    public static final String TRACE_DEBUG_LOG_BUFFER_SIZE = "org.eclipse.tm.terminal/debug/log/buffer/size";
    private static PrintStream logStream;

    static {
        String logFile = null;
        File logDirWindows = new File("C:\\eclipselogs");
        File logDirUNIX = new File("/tmp/eclipselogs");
        if (logDirWindows.isDirectory()) {
            logFile = logDirWindows + "\\tmterminal.log";
        } else if (logDirUNIX.isDirectory()) {
            logFile = logDirUNIX + "/tmterminal.log";
        }
        if (logFile != null) {
            try {
                logStream = new PrintStream(new FileOutputStream(logFile, true));
            }
            catch (Exception ex) {
                logStream = System.err;
                logStream.println("Exception when opening log file -- logging to stderr!");
                ex.printStackTrace(logStream);
            }
        }
    }

    public static final String encode(String message) {
        boolean encoded = false;
        StringBuffer buf = new StringBuffer(message.length() + 32);
        int i = 0;
        while (i < message.length()) {
            char c = message.charAt(i);
            switch (c) {
                case '\'': 
                case '\\': {
                    buf.append('\\');
                    buf.append(c);
                    encoded = true;
                    break;
                }
                case '\r': {
                    buf.append('\\');
                    buf.append('r');
                    encoded = true;
                    break;
                }
                case '\n': {
                    buf.append('\\');
                    buf.append('n');
                    encoded = true;
                    break;
                }
                case '\t': {
                    buf.append('\\');
                    buf.append('t');
                    encoded = true;
                    break;
                }
                case '\f': {
                    buf.append('\\');
                    buf.append('f');
                    encoded = true;
                    break;
                }
                case '\b': {
                    buf.append('\\');
                    buf.append('b');
                    encoded = true;
                    break;
                }
                default: {
                    if (c <= '\u000f') {
                        buf.append('\\');
                        buf.append('x');
                        buf.append('0');
                        buf.append(Integer.toHexString(c));
                        encoded = true;
                        break;
                    }
                    if (c >= ' ' && c < '\u007f') {
                        buf.append(c);
                        break;
                    }
                    if (c <= '\u00ff') {
                        buf.append('\\');
                        buf.append('x');
                        buf.append(Integer.toHexString(c));
                        encoded = true;
                        break;
                    }
                    buf.append('\\');
                    buf.append('u');
                    if (c <= '\u0fff') {
                        buf.append('0');
                    }
                    buf.append(Integer.toHexString(c));
                    encoded = true;
                }
            }
            ++i;
        }
        if (encoded) {
            return buf.toString();
        }
        return message;
    }

    public static final boolean isLogEnabled() {
        return logStream != null;
    }

    public static final void log(String message) {
        if (logStream != null) {
            StackTraceElement caller = new Throwable().getStackTrace()[1];
            int lineNumber = caller.getLineNumber();
            String className = caller.getClassName();
            String methodName = caller.getMethodName();
            className = className.substring(className.lastIndexOf(46) + 1);
            logStream.println(String.valueOf(className) + "." + methodName + ":" + lineNumber + ": " + message);
            logStream.flush();
        }
    }

    public static final void logException(Exception ex) {
        if (TerminalPlugin.getDefault() != null) {
            TerminalPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.tm.terminal", 0, ex.getMessage(), (Throwable)ex));
        } else {
            ex.printStackTrace();
        }
        if (logStream != null) {
            StackTraceElement caller = new Throwable().getStackTrace()[1];
            int lineNumber = caller.getLineNumber();
            String className = caller.getClassName();
            String methodName = caller.getMethodName();
            className = className.substring(className.lastIndexOf(46) + 1);
            PrintStream tmpStream = System.err;
            if (logStream != null) {
                tmpStream = logStream;
            }
            tmpStream.println(String.valueOf(className) + "." + methodName + ":" + lineNumber + ": " + "Caught exception: " + ex);
            ex.printStackTrace(tmpStream);
        }
    }
}

