/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.rapi;

import org.eclipse.tm.internal.rapi.RapiSession;
import org.eclipse.tm.rapi.IRapiDevice;
import org.eclipse.tm.rapi.IRapiSession;
import org.eclipse.tm.rapi.RapiConnectionInfo;
import org.eclipse.tm.rapi.RapiDeviceInfo;
import org.eclipse.tm.rapi.RapiException;

public class RapiDevice
extends IRapiDevice {
    public RapiDevice(int addr) {
        super(addr);
    }

    public IRapiSession createSession() throws RapiException {
        int[] ppISession = new int[1];
        int rc = this.CreateSession(this.addr, ppISession);
        if (rc != 0) {
            throw new RapiException("CreateSession failed", rc);
        }
        return new RapiSession(ppISession[0]);
    }

    public RapiConnectionInfo getConnectionInfo() throws RapiException {
        RapiConnectionInfo connInfo = new RapiConnectionInfo();
        int rc = this.GetConnectionInfo(this.addr, connInfo);
        if (rc != 0) {
            throw new RapiException("GetConnectionInfo failed", rc);
        }
        return connInfo;
    }

    public RapiDeviceInfo getDeviceInfo() throws RapiException {
        RapiDeviceInfo devInfo = new RapiDeviceInfo();
        int rc = this.GetDeviceInfo(this.addr, devInfo);
        if (rc != 0) {
            throw new RapiException("GetDeviceInfo failed", rc);
        }
        return devInfo;
    }

    public boolean isConnected() throws RapiException {
        int[] status = new int[1];
        int rc = this.GetConnectStat(this.addr, status);
        if (rc != 0) {
            throw new RapiException("GetConnectStat failed", rc);
        }
        return status[0] == 1;
    }

    public String toString() {
        return "[RapiDevice] addr: " + Integer.toHexString(this.addr);
    }

    private final native int CreateSession(int var1, int[] var2);

    private final native int GetConnectionInfo(int var1, RapiConnectionInfo var2);

    private final native int GetDeviceInfo(int var1, RapiDeviceInfo var2);

    private final native int GetConnectStat(int var1, int[] var2);
}

