/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.services.wince.files;

import org.eclipse.rse.services.files.IHostFile;

public class WinCEHostFile
implements IHostFile {
    String name;
    String parentPath;
    boolean isDirectory;
    boolean isRoot;
    boolean isArchive = false;
    boolean isReadable = true;
    boolean isWritable = true;
    boolean exists = true;
    long lastModified = 0L;
    long size = 0L;

    public WinCEHostFile(String parentPath, String name, boolean isDirectory, boolean isRoot, boolean isWritable, long lastModified, long size) {
        this.parentPath = parentPath;
        this.name = name;
        this.isDirectory = isDirectory;
        this.isRoot = isRoot;
        this.isWritable = isWritable;
        this.lastModified = lastModified;
        this.size = size;
    }

    public boolean canRead() {
        return this.isReadable;
    }

    public boolean canWrite() {
        return this.isWritable;
    }

    public boolean exists() {
        return this.exists;
    }

    public void setExists(boolean exists) {
        this.exists = exists;
    }

    public String getAbsolutePath() {
        if (this.isRoot()) {
            return this.getName();
        }
        String path = this.parentPath;
        if (!this.parentPath.endsWith("\\")) {
            path = String.valueOf(path) + "\\";
        }
        path = String.valueOf(path) + this.name;
        return path;
    }

    public long getModifiedDate() {
        return this.lastModified;
    }

    public String getName() {
        return this.name;
    }

    public String getParentPath() {
        return this.parentPath;
    }

    public long getSize() {
        return this.size;
    }

    public boolean isArchive() {
        return this.isArchive;
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public boolean isFile() {
        return !this.isDirectory && !this.isRoot;
    }

    public boolean isHidden() {
        return false;
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public void renameTo(String newAbsolutePath) {
        int ind = newAbsolutePath.lastIndexOf("\\");
        if (ind == -1) {
            this.name = newAbsolutePath;
        } else {
            this.parentPath = newAbsolutePath.substring(0, ind);
            this.name = newAbsolutePath.substring(ind + 1);
        }
    }
}

