/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.tests.framework.scripting;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.rse.internal.tests.framework.TestFrameworkPlugin;
import org.osgi.framework.Bundle;

public abstract class ScriptContext {
    private boolean failed = false;
    private URL home;

    public ScriptContext(URL home) {
        this.home = home;
    }

    public final URL getResourceURL(String resourceName) {
        URL result = null;
        try {
            result = new URL(this.home, resourceName);
        }
        catch (MalformedURLException e) {
            this.setFailing(true);
            TestFrameworkPlugin plugin = TestFrameworkPlugin.getDefault();
            Bundle bundle = plugin.getBundle();
            String pluginId = bundle.getSymbolicName();
            ILog log = plugin.getLog();
            Status status = new Status(4, pluginId, 0, "bad resource name in script", (Throwable)e);
            log.log((IStatus)status);
        }
        return result;
    }

    public final boolean getFailed() {
        return this.failed;
    }

    public final void setFailing(boolean flag) {
        this.failed = flag;
    }

    public abstract void pause(String var1);

    public abstract void show(String var1);

    public abstract void tell(String var1);
}

