/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.tests.core;

import org.eclipse.swt.widgets.Display;

public final class RSEWaitAndDispatchUtil {
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.tests.core.RSEWaitAndDispatchUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    private RSEWaitAndDispatchUtil() {
    }

    public static boolean isDispatchThread() {
        return Display.findDisplay((Thread)Thread.currentThread()) != null;
    }

    public static void waitAndDispatch(long timeout) {
        if (!$assertionsDisabled && timeout <= 0L) {
            throw new AssertionError();
        }
        if (timeout > 0L) {
            long start = System.currentTimeMillis();
            Display display = Display.findDisplay((Thread)Thread.currentThread());
            if (display != null) {
                long current = System.currentTimeMillis();
                while (current - start < timeout && !display.isDisposed()) {
                    if (!display.readAndDispatch()) {
                        display.sleep();
                    }
                    current = System.currentTimeMillis();
                }
            } else {
                try {
                    Thread.sleep(timeout);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public static boolean waitAndDispatch(long timeout, IInterruptCondition condition) {
        if (!($assertionsDisabled || timeout >= 0L && condition != null)) {
            throw new AssertionError();
        }
        boolean isTimedOut = false;
        if (timeout >= 0L && condition != null) {
            long start = System.currentTimeMillis();
            Display display = Display.findDisplay((Thread)Thread.currentThread());
            if (display != null) {
                long current = System.currentTimeMillis();
                while (timeout == 0L || current - start < timeout && !display.isDisposed()) {
                    if (condition.isTrue()) break;
                    if (!display.readAndDispatch()) {
                        display.sleep();
                    }
                    current = System.currentTimeMillis();
                }
                isTimedOut = current - start >= timeout && timeout > 0L;
            } else {
                long current = System.currentTimeMillis();
                while (timeout == 0L || current - start < timeout) {
                    if (condition.isTrue()) break;
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {}
                    current = System.currentTimeMillis();
                }
                isTimedOut = current - start >= timeout && timeout > 0L;
            }
        }
        condition.dispose();
        return isTimedOut;
    }

    public static interface IInterruptCondition {
        public boolean isTrue();

        public void dispose();
    }
}

