/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.files.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.rse.core.model.ISystemResourceSet;
import org.eclipse.rse.core.model.SystemRemoteResourceSet;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.ISystemDragDropAdapter;
import org.eclipse.rse.internal.files.ui.Activator;
import org.eclipse.rse.internal.files.ui.FileResources;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.ui.messages.SystemMessageDialog;
import org.eclipse.rse.ui.view.ISystemViewElementAdapter;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class SynchronizeCacheActionDelegate
implements IActionDelegate {
    protected IStructuredSelection fSelection;
    private IStatus errorStatus;
    private SystemMessage systemMessage;
    static /* synthetic */ Class class$0;

    public void run(IAction action) {
        this.errorStatus = null;
        this.systemMessage = null;
        IRemoteFile[] files = this.getRemoteFiles(this.fSelection);
        boolean completed = this.performCacheRemoteFiles(files);
        if (!completed) {
            return;
        }
        if (this.errorStatus != null) {
            ErrorDialog.openError((Shell)this.getShell(), (String)FileResources.MESSAGE_ERROR_CACHING_REMOTE_FILES, null, (IStatus)this.errorStatus);
            this.errorStatus = null;
        } else if (this.systemMessage != null) {
            SystemMessageDialog dlg = new SystemMessageDialog(this.getShell(), this.systemMessage);
            dlg.open();
            this.systemMessage = null;
        }
    }

    private void cacheRemoteFiles(IRemoteFile[] files, IProgressMonitor monitor) throws SystemMessageException {
        SystemRemoteResourceSet[] sets = this.getResourceSetsFor(files);
        int i = 0;
        while (i < sets.length) {
            SystemRemoteResourceSet set = sets[i];
            ISystemResourceSet resultSet = set.getAdapter().doDrag(set, monitor);
            this.systemMessage = resultSet.getMessage();
            ++i;
        }
    }

    private SystemRemoteResourceSet[] getResourceSetsFor(IRemoteFile[] files) {
        ISystemViewElementAdapter adapter = null;
        HashMap<IRemoteFileSubSystem, SystemRemoteResourceSet> sets = new HashMap<IRemoteFileSubSystem, SystemRemoteResourceSet>();
        int i = 0;
        while (i < files.length) {
            IRemoteFileSubSystem ss;
            SystemRemoteResourceSet set;
            IRemoteFile file = files[i];
            if (adapter == null) {
                IAdaptable iAdaptable = (IAdaptable)file;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.rse.ui.view.ISystemViewElementAdapter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                adapter = (ISystemViewElementAdapter)iAdaptable.getAdapter((Class)clazz);
            }
            if ((set = (SystemRemoteResourceSet)sets.get(ss = file.getParentRemoteFileSubSystem())) == null) {
                set = new SystemRemoteResourceSet((ISubSystem)ss, (ISystemDragDropAdapter)adapter);
                sets.put(ss, set);
            }
            set.addResource((Object)file);
            ++i;
        }
        Iterator iterator = sets.values().iterator();
        ArrayList results = new ArrayList();
        while (iterator.hasNext()) {
            results.add(iterator.next());
        }
        return results.toArray(new SystemRemoteResourceSet[results.size()]);
    }

    boolean performCacheRemoteFiles(final IRemoteFile[] files) {
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
                try {
                    SynchronizeCacheActionDelegate.this.cacheRemoteFiles(files, monitor);
                }
                catch (Exception e) {
                    if (e.getCause() instanceof CoreException) {
                        SynchronizeCacheActionDelegate.this.recordError((CoreException)e.getCause());
                    }
                    Activator.getDefault().getLog().log((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), -1, e.getMessage(), (Throwable)e));
                    SynchronizeCacheActionDelegate.this.displayError(e.getMessage());
                }
            }
        };
        try {
            ProgressMonitorDialog mon = new ProgressMonitorDialog(this.getShell()){

                protected void configureShell(Shell shell) {
                    super.configureShell(shell);
                    shell.setText(FileResources.MESSAGE_SYNCHRONIZING_REMOTE_FILE_CACHE);
                }
            };
            mon.run(true, true, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            this.displayError("Internal Error: " + e.getTargetException().getMessage());
            return false;
        }
        return true;
    }

    void displayError(String message) {
        MessageDialog.openError((Shell)this.getShell(), (String)FileResources.MESSAGE_ERROR_CACHING_REMOTE_FILES, (String)message);
    }

    final void recordError(CoreException error) {
        this.errorStatus = error.getStatus();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.fSelection = selection instanceof IStructuredSelection ? (IStructuredSelection)selection : StructuredSelection.EMPTY;
    }

    protected IRemoteFile[] getRemoteFiles(IStructuredSelection selection) {
        IRemoteFile[] files = new IRemoteFile[selection.size()];
        Iterator iter = selection.iterator();
        int i = 0;
        while (iter.hasNext()) {
            files[i++] = (IRemoteFile)iter.next();
        }
        return files;
    }

    protected IWorkbench getWorkbench() {
        return PlatformUI.getWorkbench();
    }

    protected Shell getShell() {
        return Display.getDefault().getActiveShell();
    }

    protected IStructuredSelection getSelection() {
        return this.fSelection;
    }
}

