/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.telnet;

import org.eclipse.tm.internal.terminal.provisional.api.ISettingsStore;
import org.eclipse.tm.internal.terminal.telnet.ITelnetSettings;
import org.eclipse.tm.internal.terminal.telnet.TelnetProperties;

public class TelnetSettings
implements ITelnetSettings {
    protected String fHost;
    protected String fNetworkPort;
    protected String fTimeout;
    private final TelnetProperties fProperties = new TelnetProperties();

    public String getHost() {
        return this.fHost;
    }

    public void setHost(String strHost) {
        this.fHost = strHost;
    }

    public String getNetworkPortString() {
        return this.fNetworkPort;
    }

    public int getNetworkPort() {
        try {
            return Integer.parseInt(this.fNetworkPort);
        }
        catch (NumberFormatException numberFormatException) {
            return 1313;
        }
    }

    public void setNetworkPort(String strNetworkPort) {
        this.fNetworkPort = strNetworkPort;
    }

    public String getSummary() {
        return String.valueOf(this.getHost()) + ":" + this.getNetworkPortString();
    }

    public void load(ISettingsStore store) {
        this.fHost = store.get("Host", this.fProperties.getDefaultHost());
        this.fNetworkPort = store.get("NetworkPort", this.fProperties.getDefaultNetworkPort());
        this.fTimeout = store.get("Timeout", "10");
    }

    public void save(ISettingsStore store) {
        store.put("Host", this.fHost);
        store.put("NetworkPort", this.fNetworkPort);
        store.put("Timeout", this.fTimeout);
    }

    public TelnetProperties getProperties() {
        return this.fProperties;
    }

    public int getTimeout() {
        try {
            return Integer.parseInt(this.fTimeout);
        }
        catch (NumberFormatException numberFormatException) {
            return 10;
        }
    }

    public String getTimeoutString() {
        return this.fTimeout;
    }

    public void setTimeout(String timeout) {
        this.fTimeout = timeout;
    }
}

