/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.connector;

import java.io.OutputStream;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.tm.internal.terminal.control.impl.TerminalMessages;
import org.eclipse.tm.internal.terminal.provisional.api.ISettingsPage;
import org.eclipse.tm.internal.terminal.provisional.api.ISettingsStore;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalConnector;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalControl;
import org.eclipse.tm.internal.terminal.provisional.api.Logger;
import org.eclipse.tm.internal.terminal.provisional.api.TerminalState;
import org.eclipse.tm.internal.terminal.provisional.api.provider.TerminalConnectorImpl;

public class TerminalConnector
implements ITerminalConnector {
    private final Factory fTerminalConnectorFactory;
    private final String fName;
    private final String fId;
    private TerminalConnectorImpl fConnector;
    private Exception fException;
    private ISettingsStore fStore;

    public TerminalConnector(Factory terminalConnectorFactory, String id, String name) {
        this.fTerminalConnectorFactory = terminalConnectorFactory;
        this.fId = id;
        this.fName = name;
    }

    public String getInitializationErrorMessage() {
        this.getConnectorImpl();
        if (this.fException != null) {
            return this.fException.getLocalizedMessage();
        }
        return null;
    }

    public String getId() {
        return this.fId;
    }

    public String getName() {
        return this.fName;
    }

    private TerminalConnectorImpl getConnectorImpl() {
        if (!this.isInitialized()) {
            try {
                this.fConnector = this.fTerminalConnectorFactory.makeConnector();
                this.fConnector.initialize();
            }
            catch (Exception e) {
                this.fException = e;
                this.fConnector = new TerminalConnectorImpl(){

                    public void connect(ITerminalControl control) {
                        control.setState(TerminalState.CLOSED);
                        control.setMsg(TerminalConnector.this.getInitializationErrorMessage());
                    }

                    public OutputStream getTerminalToRemoteStream() {
                        return null;
                    }

                    public String getSettingsSummary() {
                        return null;
                    }
                };
                Logger.logException(e);
            }
            if (this.fConnector != null && this.fStore != null) {
                this.fConnector.load(this.fStore);
            }
        }
        return this.fConnector;
    }

    public boolean isInitialized() {
        return this.fConnector != null || this.fException != null;
    }

    public void connect(ITerminalControl control) {
        this.getConnectorImpl().connect(control);
    }

    public void disconnect() {
        this.getConnectorImpl().disconnect();
    }

    public OutputStream getTerminalToRemoteStream() {
        return this.getConnectorImpl().getTerminalToRemoteStream();
    }

    public String getSettingsSummary() {
        if (this.fConnector != null) {
            return this.getConnectorImpl().getSettingsSummary();
        }
        return TerminalMessages.NotInitialized;
    }

    public boolean isLocalEcho() {
        return this.getConnectorImpl().isLocalEcho();
    }

    public void load(ISettingsStore store) {
        if (this.fConnector == null) {
            this.fStore = store;
        } else {
            this.getConnectorImpl().load(store);
        }
    }

    public ISettingsPage makeSettingsPage() {
        return this.getConnectorImpl().makeSettingsPage();
    }

    public void save(ISettingsStore store) {
        if (this.fConnector != null) {
            this.getConnectorImpl().save(store);
        }
    }

    public void setTerminalSize(int newWidth, int newHeight) {
        if (this.fConnector != null) {
            this.fConnector.setTerminalSize(newWidth, newHeight);
        }
    }

    public Object getAdapter(Class adapter) {
        TerminalConnectorImpl connector = null;
        if (this.isInitialized()) {
            connector = this.getConnectorImpl();
        }
        if (connector != null) {
            if (connector instanceof IAdaptable) {
                Object result = ((IAdaptable)connector).getAdapter(adapter);
                if (result == null) {
                    result = Platform.getAdapterManager().getAdapter((Object)connector, adapter);
                }
                if (result != null) {
                    return result;
                }
            }
            if (adapter.isInstance(connector)) {
                return connector;
            }
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public static interface Factory {
        public TerminalConnectorImpl makeConnector() throws Exception;
    }
}

