/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.efs.ui;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.rse.core.filters.ISystemFilterReference;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.files.ui.dialogs.SystemRemoteFolderDialog;
import org.eclipse.rse.internal.efs.RSEFileStoreImpl;
import org.eclipse.rse.services.clientserver.PathUtility;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.ui.messages.SystemMessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ide.fileSystem.FileSystemContributor;

public class RSEFileSystemContributor
extends FileSystemContributor {
    public URI browseFileSystem(String initialPath, Shell shell) {
        IHost host;
        SystemRemoteFolderDialog dlg = new SystemRemoteFolderDialog(shell);
        if (!initialPath.equals("")) {
            try {
                URI uri = new URI(initialPath);
                host = RSEFileStoreImpl.getConnectionFor((String)uri.getHost(), null);
                IRemoteFileSubSystem fs = RSEFileStoreImpl.getRemoteFileSubSystem((IHost)host);
                dlg.setInputObject((Object)fs.getRemoteFileObject(uri.getPath(), (IProgressMonitor)new NullProgressMonitor()));
            }
            catch (Exception exception) {}
        }
        dlg.setNeedsProgressMonitor(true);
        if (dlg.open() == 0) {
            ISubSystem targetSubSystem;
            ISubSystemConfiguration factory;
            Object selected = dlg.getSelectedObject();
            if (selected instanceof ISystemFilterReference && (factory = (targetSubSystem = ((ISystemFilterReference)selected).getSubSystem()).getSubSystemConfiguration()).supportsDropInFilters()) {
                selected = targetSubSystem.getTargetForFilter((ISystemFilterReference)selected);
            }
            host = dlg.getSelectedConnection();
            String hostName = host.getHostName();
            IRemoteFile file = (IRemoteFile)selected;
            String path = file.getAbsolutePath();
            if (host.getSystemType().isWindows()) {
                path = path.replace('\\', '/');
            }
            path = this.fixPathForURI(path);
            try {
                return new URI("rse", hostName, path, null);
            }
            catch (URISyntaxException e) {
                SystemMessageDialog.displayErrorMessage((Shell)SystemMessageDialog.getDefaultShell(), (String)e.getLocalizedMessage());
            }
        }
        return null;
    }

    private String fixPathForURI(String path) {
        String sep = PathUtility.getSeparator((String)path);
        if (!sep.equals("/")) {
            path = path.replace(sep.charAt(0), '/');
        }
        int length = path.length();
        StringBuffer pathBuf = new StringBuffer(length + 3);
        if (length > 0 && path.charAt(0) != '/') {
            pathBuf.append('/');
        }
        if (path.startsWith("//")) {
            pathBuf.append('/').append('/');
        }
        pathBuf.append(path);
        return pathBuf.toString();
    }

    public URI getURI(String string) {
        try {
            return new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }
}

