/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.view;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.rse.core.filters.ISystemFilterReference;
import org.eclipse.rse.core.model.ISystemContainer;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.internal.ui.view.SystemViewPromptableAdapter;
import org.eclipse.rse.internal.ui.view.SystemViewRootInputAdapter;
import org.eclipse.rse.ui.view.ContextObject;
import org.eclipse.rse.ui.view.ISystemTableViewColumnManager;
import org.eclipse.rse.ui.view.ISystemViewElementAdapter;
import org.eclipse.rse.ui.view.SystemAdapterHelpers;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class SystemTableViewProvider
implements ILabelProvider,
ITableLabelProvider,
ITreeContentProvider {
    private ListenerList listeners = new ListenerList(1);
    protected Object[] _lastResults = null;
    protected Object _lastObject = null;
    protected SimpleDateFormat _dateFormat = new SimpleDateFormat();
    protected Viewer _viewer = null;
    protected int _maxCharsInColumnZero = 0;
    private Map imageTable = new Hashtable(40);
    private ISystemTableViewColumnManager _columnManager;
    private HashMap cache;

    public SystemTableViewProvider(ISystemTableViewColumnManager columnManager) {
        this._columnManager = columnManager;
        this.cache = new HashMap();
    }

    public SystemTableViewProvider() {
        this._columnManager = null;
    }

    public void inputChanged(Viewer visualPart, Object oldInput, Object newInput) {
        this._viewer = visualPart;
    }

    public boolean isDeleted(Object element) {
        return false;
    }

    public Object[] getChildren(Object object) {
        return this.getElements(object);
    }

    public Object getParent(Object object) {
        ISystemViewElementAdapter adapter = this.getAdapterFor(object);
        if (adapter != null) {
            return adapter.getParent(object);
        }
        return null;
    }

    public boolean hasChildren(Object object) {
        return false;
    }

    public Object getElementAt(Object object, int i) {
        return null;
    }

    protected ISystemViewElementAdapter getAdapterFor(Object object) {
        ISystemViewElementAdapter result = null;
        result = this._viewer != null ? SystemAdapterHelpers.getViewAdapter(object, this._viewer) : SystemAdapterHelpers.getViewAdapter(object);
        if (result != null) {
            result.setPropertySourceInput(object);
        }
        return result;
    }

    public Object[] getElements(Object object) {
        Object[] results = null;
        ISystemViewElementAdapter adapter = this.getAdapterFor(object);
        if (adapter != null) {
            adapter.setViewer(this._viewer);
            if (object instanceof ISystemFilterReference) {
                ISubSystem ss = adapter.getSubSystem(object);
                ContextObject context = new ContextObject(object, ss, (ISystemFilterReference)object);
                results = adapter.getChildren(context, (IProgressMonitor)new NullProgressMonitor());
            } else {
                results = adapter.getChildren((IAdaptable)object, (IProgressMonitor)new NullProgressMonitor());
            }
            if (adapter instanceof SystemViewRootInputAdapter) {
                ArrayList<Object> filterredResults = new ArrayList<Object>();
                int i = 0;
                while (i < results.length) {
                    Object result = results[i];
                    ISystemViewElementAdapter cadapter = this.getAdapterFor(result);
                    if (!(cadapter instanceof SystemViewPromptableAdapter)) {
                        filterredResults.add(result);
                    }
                    ++i;
                }
                results = filterredResults.toArray();
            }
            this._lastResults = results;
            this._lastObject = object;
        }
        if (results == null) {
            return new Object[0];
        }
        return results;
    }

    public String getText(Object object) {
        String result = this.getAdapterFor(object).getText(object);
        int len = result.length();
        if (len > this._maxCharsInColumnZero) {
            this._maxCharsInColumnZero = len;
        }
        return result;
    }

    public int getMaxCharsInColumnZero() {
        return this._maxCharsInColumnZero;
    }

    public Image getImage(Object object) {
        ImageDescriptor descriptor = this.getAdapterFor(object).getImageDescriptor(object);
        Image image = null;
        if (descriptor != null) {
            Object iobj = this.imageTable.get(descriptor);
            if (iobj == null) {
                image = descriptor.createImage();
                this.imageTable.put(descriptor, image);
            } else {
                image = (Image)iobj;
            }
        }
        return image;
    }

    public String getColumnText(Object obj, int index) {
        if (index == 0) {
            return this.getText(obj);
        }
        ISystemViewElementAdapter adapter = this.getAdapterFor(obj);
        IPropertyDescriptor[] descriptors = null;
        descriptors = this._columnManager != null ? this._columnManager.getVisibleDescriptors(adapter) : adapter.getUniquePropertyDescriptors();
        if (descriptors.length > --index) {
            IPropertyDescriptor descriptor = descriptors[index];
            try {
                Object key = descriptor.getId();
                Object propertyValue = adapter.getPropertyValue(key);
                if (propertyValue instanceof String) {
                    return (String)propertyValue;
                }
                if (propertyValue instanceof Date) {
                    return this._dateFormat.format((Date)propertyValue);
                }
                if (propertyValue != null) {
                    return propertyValue.toString();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return "";
    }

    public Image getColumnImage(Object obj, int i) {
        if (i == 0) {
            return this.getImage(obj);
        }
        return null;
    }

    public void addListener(ILabelProviderListener listener) {
        this.listeners.add((Object)listener);
    }

    public boolean isLabelProperty(Object element, String property) {
        return true;
    }

    public void removeListener(ILabelProviderListener listener) {
        this.listeners.remove((Object)listener);
    }

    public void setCachedObjects(Object parent, Object[] children) {
        this.cache.put(parent, children);
    }

    public Object[] getCachedObjects(Object parent) {
        return (Object[])this.cache.get(parent);
    }

    public void setCache(Object[] newCache) {
        this._lastResults = newCache;
    }

    public Object[] getCache() {
        return this._lastResults;
    }

    public boolean flushCache() {
        if (this._lastResults == null) {
            return false;
        }
        boolean cfr_ignored_0 = this._lastObject instanceof ISystemContainer;
        this._lastResults = null;
        return true;
    }

    public void dispose() {
    }
}

