/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.operations;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.model.SystemMessageObject;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.SubSystem;
import org.eclipse.rse.internal.ui.GenericMessages;
import org.eclipse.rse.internal.ui.view.SystemView;
import org.eclipse.rse.internal.ui.view.SystemViewPart;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.rse.ui.messages.SystemMessageDialog;
import org.eclipse.rse.ui.operations.ISystemRunnableContext;
import org.eclipse.rse.ui.operations.Policy;
import org.eclipse.rse.ui.operations.SystemFetchOperation;
import org.eclipse.rse.ui.operations.SystemJobRunnableContext;
import org.eclipse.rse.ui.operations.SystemProgressDialogRunnableContext;
import org.eclipse.rse.ui.view.IContextObject;
import org.eclipse.rse.ui.view.ISystemRemoteElementAdapter;
import org.eclipse.rse.ui.view.ISystemViewElementAdapter;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.progress.IElementCollector;

public class SystemFetchOperation
extends JobChangeAdapter
implements IRunnableWithProgress {
    protected IWorkbenchPart _part;
    protected Object _remoteObject;
    protected IElementCollector _collector;
    private IRunnableContext context;
    protected ISystemViewElementAdapter _adapter;
    protected boolean _canRunAsJob;
    protected InvocationTargetException _exc;
    static /* synthetic */ Class class$0;

    public SystemFetchOperation(IWorkbenchPart part, Object remoteObject, ISystemViewElementAdapter adapter, IElementCollector collector) {
        this._part = part;
        this._remoteObject = remoteObject;
        this._collector = collector;
        this._adapter = adapter;
        this._canRunAsJob = false;
    }

    public SystemFetchOperation(IWorkbenchPart part, Object remoteObject, ISystemViewElementAdapter adapter, IElementCollector collector, boolean canRunAsJob) {
        this._part = part;
        this._remoteObject = remoteObject;
        this._collector = collector;
        this._adapter = adapter;
        this._canRunAsJob = canRunAsJob;
    }

    public void setException(InvocationTargetException exc) {
        this._exc = exc;
    }

    public IWorkbenchPart getPart() {
        return this._part;
    }

    public final void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        this.startOperation();
        try {
            try {
                monitor = Policy.monitorFor(monitor);
                monitor.beginTask(null, 100);
                monitor.setTaskName(this.getTaskName());
                this.execute(Policy.subMonitorFor(monitor, 100));
                this.endOperation();
            }
            catch (InterruptedException e) {
                this.endOperation();
                monitor.setCanceled(true);
                throw e;
            }
            catch (Exception e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void startOperation() {
    }

    protected void endOperation() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute(IProgressMonitor monitor) throws Exception, InterruptedException {
        Display dis;
        Object adapter;
        SubSystem ss = null;
        Object actualRemoteObj = this._remoteObject;
        if (this._remoteObject instanceof IContextObject) {
            ss = (SubSystem)((IContextObject)this._remoteObject).getSubSystem();
            actualRemoteObj = ((IContextObject)this._remoteObject).getModelObject();
        } else {
            ss = (SubSystem)this._adapter.getSubSystem(this._remoteObject);
        }
        boolean isPromptable = false;
        if (actualRemoteObj instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)actualRemoteObj;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.rse.ui.view.ISystemViewElementAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((adapter = (ISystemViewElementAdapter)iAdaptable.getAdapter((Class)clazz)) != null) {
                isPromptable = adapter.isPromptable(actualRemoteObj);
            }
        }
        adapter = ss.getConnectorService();
        synchronized (adapter) {
            if (!(ss.isConnected() || isPromptable || ss.isOffline())) {
                dis = Display.getDefault();
                PromptForPassword prompter = new PromptForPassword(ss);
                dis.syncExec((Runnable)prompter);
                if (prompter.isCancelled()) {
                    SystemMessage cancelledMessage = RSEUIPlugin.getPluginMessage("RSEG1067");
                    SystemMessageObject cancelledMessageObject = new SystemMessageObject(cancelledMessage, 1, this._remoteObject);
                    this._collector.add((Object)cancelledMessageObject, monitor);
                    throw new InterruptedException();
                }
                try {
                    ss.getConnectorService().connect(monitor);
                    if (this._exc != null) {
                        this.showOperationErrorMessage(null, this._exc, ss);
                    }
                }
                catch (InvocationTargetException exc) {
                    this.showOperationErrorMessage(null, exc, ss);
                    return;
                }
                catch (Exception e) {
                    this.showOperationErrorMessage(null, e, ss);
                    return;
                }
                dis.asyncExec((Runnable)new UpdateRegistry(ss));
            }
        }
        Object[] children = null;
        if ((this._part == null || this._part instanceof SystemViewPart) && this._adapter instanceof ISystemRemoteElementAdapter) {
            dis = Display.getDefault();
            class GetExpandToFilter
            implements Runnable {
                private String expandToFilter;
                final /* synthetic */ SystemFetchOperation this$0;

                GetExpandToFilter(SystemFetchOperation systemFetchOperation) {
                    this.this$0 = systemFetchOperation;
                    this.expandToFilter = null;
                }

                public void run() {
                    IWorkbenchPage page;
                    IWorkbenchWindow win;
                    IWorkbenchPart activePart = this.this$0._part;
                    if (activePart == null && (win = SystemBasePlugin.getActiveWorkbenchWindow()) != null && (page = win.getActivePage()) != null && (activePart = page.getActivePart()) != null) {
                        this.this$0._part = activePart;
                    }
                    if (activePart instanceof SystemViewPart) {
                        SystemView viewer = ((SystemViewPart)activePart).getSystemView();
                        this.expandToFilter = this.this$0._remoteObject instanceof IContextObject ? viewer.getExpandToFilter(((IContextObject)this.this$0._remoteObject).getModelObject()) : viewer.getExpandToFilter(this.this$0._remoteObject);
                    }
                }

                public String getExpandToFilter() {
                    return this.expandToFilter;
                }
            }
            GetExpandToFilter getExpandTo = new GetExpandToFilter(this);
            dis.syncExec((Runnable)getExpandTo);
            String expandToFilter = getExpandTo.getExpandToFilter();
            if (expandToFilter != null) {
                children = this._remoteObject instanceof IContextObject ? this._adapter.getChildrenUsingExpandToFilter(((IContextObject)this._remoteObject).getModelObject(), expandToFilter) : this._adapter.getChildrenUsingExpandToFilter(this._remoteObject, expandToFilter);
            }
        }
        if (children == null) {
            children = this._remoteObject instanceof IContextObject ? this._adapter.getChildren((IContextObject)this._remoteObject, monitor) : this._adapter.getChildren((IAdaptable)this._remoteObject, monitor);
        }
        this._collector.add(children, monitor);
        monitor.done();
    }

    protected void showOperationErrorMessage(Shell shell, Throwable exc, SubSystem ss) {
        if (exc instanceof InvocationTargetException) {
            exc = ((InvocationTargetException)exc).getTargetException();
        }
        if (exc instanceof OperationCanceledException) {
            return;
        }
        SystemMessage sysMsg = null;
        if (exc instanceof SystemMessageException) {
            this.displayAsyncMsg(ss, (SystemMessageException)exc);
        } else {
            String excMsg = exc.getMessage();
            if (excMsg == null || excMsg.length() == 0) {
                excMsg = "Exception " + exc.getClass().getName();
            }
            sysMsg = RSEUIPlugin.getPluginMessage("RSEG1066");
            sysMsg.makeSubstitution((Object)excMsg);
            SystemMessageDialog.displayErrorMessage(shell, sysMsg, exc);
        }
    }

    protected void displayAsyncMsg(SubSystem ss, SystemMessageException msg) {
        SubSystem.DisplayErrorMessageJob job = new SubSystem.DisplayErrorMessageJob(null, msg);
        job.setPriority(10);
        job.setSystem(true);
        job.schedule();
    }

    protected String getTaskName() {
        return GenericMessages.RSEQuery_task;
    }

    public final void run() throws InvocationTargetException, InterruptedException {
        if (this.shouldRun()) {
            this.getRunnableContext().run(this);
        }
    }

    protected boolean shouldRun() {
        return true;
    }

    protected ISchedulingRule getSchedulingRule() {
        return null;
    }

    protected boolean isPostponeAutobuild() {
        return true;
    }

    protected boolean canRunAsJob() {
        return this._canRunAsJob;
    }

    protected String getJobName() {
        return "";
    }

    protected IAction getGotoAction() {
        return null;
    }

    protected URL getOperationIcon() {
        return null;
    }

    protected boolean getKeepOperation() {
        return false;
    }

    protected Shell getShell() {
        return SystemBasePlugin.getActiveWorkbenchShell();
    }

    private ISystemRunnableContext getRunnableContext() {
        if (this.context == null && this.canRunAsJob()) {
            SystemJobRunnableContext context = new SystemJobRunnableContext(this.getJobName(), this.getOperationIcon(), this.getGotoAction(), this.getKeepOperation(), (IJobChangeListener)this, this.getSite());
            context.setPostponeBuild(this.isPostponeAutobuild());
            context.setSchedulingRule(this.getSchedulingRule());
            return context;
        }
        SystemProgressDialogRunnableContext context = new SystemProgressDialogRunnableContext(this.getShell());
        context.setPostponeBuild(this.isPostponeAutobuild());
        context.setSchedulingRule(this.getSchedulingRule());
        if (this.context != null) {
            context.setRunnableContext(this.context);
        }
        return context;
    }

    private IWorkbenchSite getSite() {
        IWorkbenchPartSite site = null;
        if (this._part != null) {
            site = this._part.getSite();
        }
        return site;
    }

    public class PromptForPassword
    implements Runnable {
        public SubSystem _ss;
        private volatile boolean isCancelled = false;

        public PromptForPassword(SubSystem ss) {
            this._ss = ss;
        }

        public void run() {
            try {
                this.isCancelled = false;
                this._ss.promptForPassword();
            }
            catch (InterruptedException interruptedException) {
                this.isCancelled = true;
            }
            catch (OperationCanceledException operationCanceledException) {
                this.isCancelled = true;
            }
            catch (Exception exception) {}
        }

        public boolean isCancelled() {
            return this.isCancelled;
        }
    }

    public class UpdateRegistry
    implements Runnable {
        private SubSystem _ss;

        public UpdateRegistry(SubSystem ss) {
            this._ss = ss;
        }

        public void run() {
            ISystemRegistry registry = RSECorePlugin.getTheSystemRegistry();
            registry.connectedStatusChange((ISubSystem)this._ss, true, false);
        }
    }
}

