/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.ui.view.monitor;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.events.ISystemResourceChangeEvent;
import org.eclipse.rse.core.events.SystemResourceChangeEvent;
import org.eclipse.rse.core.model.ISystemContainer;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.internal.ui.SystemResources;
import org.eclipse.rse.internal.ui.view.monitor.SystemMonitorViewPart;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.actions.SystemCopyToClipboardAction;
import org.eclipse.rse.ui.actions.SystemPasteFromClipboardAction;
import org.eclipse.rse.ui.view.ISystemViewElementAdapter;
import org.eclipse.rse.ui.view.SystemTableView;
import org.eclipse.rse.ui.view.SystemTableViewProvider;
import org.eclipse.rse.ui.widgets.ISystemCollapsableSectionListener;
import org.eclipse.rse.ui.widgets.SystemCollapsableSection;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.CellEditorActionHandler;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;

public class MonitorViewPage
implements SelectionListener,
IPropertyChangeListener,
ISelectionChangedListener,
Listener,
FocusListener {
    private static SystemMessage _queryMessage = RSEUIPlugin.getPluginMessage("RSEG1095");
    private SystemTableView _viewer;
    private boolean _isPolling = false;
    private int _pollingInterval;
    private Group _tabFolderPage;
    private Button _pollCheckbox;
    private Scale _scale;
    private Text _scaleValue;
    private PollingThread _pollingThread;
    private SystemMonitorViewPart _viewPart;
    private String _title;
    private SystemCopyToClipboardAction _copyAction;
    private SystemPasteFromClipboardAction _pasteAction;
    private SelectAllAction _selectAllAction;
    private IActionBars _actionBars;
    static /* synthetic */ Class class$0;

    public MonitorViewPage(SystemMonitorViewPart viewPart) {
        this._viewPart = viewPart;
        this._actionBars = this._viewPart.getViewSite().getActionBars();
    }

    public Composite createTabFolderPage(CTabFolder tabFolder, CellEditorActionHandler editorActionHandler) {
        this._tabFolderPage = new Group((Composite)tabFolder, 0);
        GridLayout gridLayout = new GridLayout();
        this._tabFolderPage.setLayout((Layout)gridLayout);
        this.createControl((Composite)this._tabFolderPage);
        Clipboard clipboard = RSEUIPlugin.getTheSystemRegistryUI().getSystemClipboard();
        this._copyAction = new SystemCopyToClipboardAction(this._viewer.getShell(), clipboard);
        this._copyAction.setEnabled(false);
        this._pasteAction = new SystemPasteFromClipboardAction(this._viewer.getShell(), clipboard);
        this._pasteAction.setEnabled(false);
        editorActionHandler.setCopyAction((IAction)this._copyAction);
        editorActionHandler.setPasteAction((IAction)this._pasteAction);
        this._selectAllAction = new SelectAllAction();
        this._selectAllAction.setEnabled(false);
        editorActionHandler.setSelectAllAction((IAction)this._selectAllAction);
        this._viewer.addSelectionChangedListener(this);
        this._viewer.getControl().addFocusListener((FocusListener)this);
        return this._tabFolderPage;
    }

    public void setFocus() {
        if (this._viewPart != null) {
            this._viewPart.setActiveViewerSelectionProvider(this._viewer);
        }
    }

    public IActionBars getActionBars() {
        return this._actionBars;
    }

    public void selectionChanged(SelectionChangedEvent e) {
        IStructuredSelection sel = (IStructuredSelection)e.getSelection();
        this._copyAction.setEnabled(this._copyAction.updateSelection(sel));
        this._pasteAction.setEnabled(this._pasteAction.updateSelection(sel));
        this._selectAllAction.setEnabled(true);
    }

    public int getPollingInterval() {
        return this._pollingInterval;
    }

    public boolean isPollingEnabled() {
        return this._isPolling && !this.getViewer().getControl().isDisposed();
    }

    public void setPollingEnabled(boolean flag) {
        this._isPolling = flag;
    }

    public void setEnabled(boolean flag) {
        if (!flag) {
            Table table = this._viewer.getTable();
            Color bgcolour = this._tabFolderPage.getBackground();
            table.setBackground(bgcolour);
        }
    }

    protected void createPollControls(Composite parent) {
        SystemCollapsableSection collapsable = new SystemCollapsableSection(parent);
        collapsable.setText(SystemResources.RESID_MONITOR_POLL_CONFIGURE_POLLING_LABEL);
        collapsable.setToolTips(SystemResources.RESID_MONITOR_POLL_CONFIGURE_POLLING_COLLAPSE_TOOLTIP, SystemResources.RESID_MONITOR_POLL_CONFIGURE_POLLING_EXPAND_TOOLTIP);
        Composite inputContainer = collapsable.getPageComposite();
        this._pollCheckbox = SystemWidgetHelpers.createCheckBox(inputContainer, this, SystemResources.RESID_MONITOR_POLL_LABEL, SystemResources.RESID_MONITOR_POLL_TOOLTIP);
        GridData pg = new GridData(32);
        this._pollCheckbox.setLayoutData((Object)pg);
        this._pollingInterval = 100;
        SystemWidgetHelpers.createLabel(inputContainer, SystemResources.RESID_MONITOR_POLL_INTERVAL_LABEL);
        this._scale = new Scale(inputContainer, 0);
        this._scale.setMaximum(200);
        this._scale.setMinimum(5);
        this._scale.setSelection(this._pollingInterval);
        this._scale.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                MonitorViewPage.this._pollingInterval = MonitorViewPage.this._scale.getSelection();
                MonitorViewPage.this._scaleValue.setText(String.valueOf(MonitorViewPage.this._pollingInterval) + "s");
                if (MonitorViewPage.this._pollingThread != null) {
                    MonitorViewPage.this._pollingThread.interrupt();
                }
            }
        });
        this._scale.setToolTipText(SystemResources.RESID_MONITOR_POLL_INTERVAL_TOOLTIP);
        GridData sd = new GridData(768);
        this._scale.setLayoutData((Object)sd);
        this._scaleValue = SystemWidgetHelpers.createReadonlyTextField(inputContainer);
        this._scaleValue.setTextLimit(5);
        GridData scgd = new GridData(128);
        this._scaleValue.setLayoutData((Object)scgd);
        this._scaleValue.setText(String.valueOf(this._pollingInterval) + "s");
        GridLayout ilayout = new GridLayout();
        ilayout.numColumns = 4;
        GridData gridData1 = new GridData(768);
        inputContainer.setLayout((Layout)ilayout);
        inputContainer.setLayoutData((Object)gridData1);
        this._scale.setEnabled(this._isPolling);
        this._scaleValue.setEnabled(this._isPolling);
        collapsable.addCollapseListener(new CollapsableListener(inputContainer));
        collapsable.setCollapsed(true);
    }

    public void createControl(Composite parent) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        parent.setLayout((Layout)gridLayout);
        Table table = new Table(parent, 101122);
        this._viewer = new SystemTableView(table, this._viewPart);
        this._viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                MonitorViewPage.this.handleDoubleClick(event);
            }
        });
        table.setHeaderVisible(false);
        table.setLinesVisible(false);
        GridData gridData = new GridData(1808);
        table.setLayoutData((Object)gridData);
        this.createPollControls((Composite)this._tabFolderPage);
    }

    public void propertyChange(PropertyChangeEvent e) {
    }

    private void handleDoubleClick(DoubleClickEvent event) {
        ISystemViewElementAdapter adapter;
        IStructuredSelection s = (IStructuredSelection)event.getSelection();
        Object element = s.getFirstElement();
        if (element == null) {
            return;
        }
        IAdaptable iAdaptable = (IAdaptable)element;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.ui.view.ISystemViewElementAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((adapter = (ISystemViewElementAdapter)iAdaptable.getAdapter((Class)clazz)) != null) {
            adapter.handleDoubleClick(element);
        }
    }

    public void dispose() {
        this._viewer.dispose();
        this._tabFolderPage.dispose();
        this._isPolling = false;
    }

    public Object getInput() {
        return this._viewer.getInput();
    }

    public void setInput(IAdaptable object) {
        this.setInput(object, true);
        this.updateTitle(object);
    }

    public void updateTitle(IAdaptable object) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.ui.view.ISystemViewElementAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ISystemViewElementAdapter adapter = (ISystemViewElementAdapter)object.getAdapter((Class)clazz);
        String title = adapter.getText(object);
        this._tabFolderPage.setText(title);
    }

    public String getTitle() {
        return this._title;
    }

    public void setInput(IAdaptable object, boolean updateHistory) {
        if (this._viewer != null && object != null) {
            this._viewer.setInput(object);
        }
    }

    public void clearInput() {
        if (this._viewer != null) {
            this._viewer.setInput(null);
        }
    }

    public SystemTableView getViewer() {
        return this._viewer;
    }

    public void updateActionStates() {
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
    }

    public void focusGained(FocusEvent arg0) {
        IActionBars actionBars = this.getActionBars();
        if (actionBars != null && arg0.widget == this._viewer.getControl()) {
            actionBars.setGlobalActionHandler(ITextEditorActionConstants.COPY, (IAction)this._copyAction);
            actionBars.setGlobalActionHandler(ITextEditorActionConstants.PASTE, (IAction)this._pasteAction);
            actionBars.setGlobalActionHandler(ITextEditorActionConstants.SELECT_ALL, (IAction)this._selectAllAction);
            actionBars.updateActionBars();
        }
    }

    public void focusLost(FocusEvent arg0) {
    }

    public void handleEvent(Event event) {
        Widget w = event.widget;
        if (w == this._pollCheckbox) {
            boolean wasPolling = this._isPolling;
            this._isPolling = this._pollCheckbox.getSelection();
            this._scale.setEnabled(this._isPolling);
            this._scaleValue.setEnabled(this._isPolling);
            if (wasPolling != this._isPolling && this._isPolling) {
                this._pollingThread = new PollingThread();
                this._pollingThread.start();
            }
        }
    }

    class CollapsableListener
    implements ISystemCollapsableSectionListener {
        Composite _child;

        public CollapsableListener(Composite child) {
            this._child = child;
        }

        public void sectionCollapsed(boolean collapsed) {
        }
    }

    class PollingThread
    extends Thread {
        private boolean _querying = false;
        private ISystemViewElementAdapter _adapter;
        private Object _inputObject;

        public PollingThread() {
            this._inputObject = MonitorViewPage.this._viewer.getInput();
            IAdaptable iAdaptable = (IAdaptable)this._inputObject;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.rse.ui.view.ISystemViewElementAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this._adapter = (ISystemViewElementAdapter)iAdaptable.getAdapter((Class)clazz);
        }

        public void run() {
            while (MonitorViewPage.this.isPollingEnabled()) {
                int interval = MonitorViewPage.this.getPollingInterval() * 1000;
                try {
                    Thread.sleep(interval);
                    this.doQuery();
                    this.doRedraw();
                }
                catch (InterruptedException interruptedException) {
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        protected void doQuery() {
            Display display = Display.getDefault();
            if (display != null && !this._querying) {
                ISubSystem ss;
                this._querying = true;
                if (this._inputObject instanceof ISystemContainer) {
                    ((ISystemContainer)this._inputObject).markStale(true);
                }
                if (!(ss = this._adapter.getSubSystem(this._inputObject)).isConnected()) {
                    return;
                }
                String name = this._adapter.getName(this._inputObject);
                _queryMessage.makeSubstitution((Object)name);
                String txt = _queryMessage.getLevelOneText();
                Job job = new Job(this, txt){
                    final /* synthetic */ PollingThread this$1;
                    {
                        this.this$1 = pollingThread;
                        super($anonymous0);
                    }

                    public IStatus run(IProgressMonitor monitor) {
                        SystemTableViewProvider provider;
                        Object[] children = PollingThread.access$0(this.this$1).getChildren((IAdaptable)PollingThread.access$1(this.this$1), monitor);
                        if (children != null && (provider = (SystemTableViewProvider)MonitorViewPage.access$0(PollingThread.access$3(this.this$1)).getContentProvider()) != null) {
                            provider.setCache(children);
                        }
                        PollingThread.access$2(this.this$1, false);
                        return Status.OK_STATUS;
                    }
                };
                job.schedule();
                try {
                    job.wait();
                }
                catch (Exception exception) {}
            }
        }

        protected void doRedraw() {
            Display display = Display.getDefault();
            if (display != null) {
                display.asyncExec(new Runnable(this){
                    final /* synthetic */ PollingThread this$1;
                    {
                        this.this$1 = pollingThread;
                    }

                    public void run() {
                        ISystemRegistry registry = RSECorePlugin.getTheSystemRegistry();
                        registry.fireEvent((ISystemResourceChangeEvent)new SystemResourceChangeEvent(PollingThread.access$1(this.this$1), 95, PollingThread.access$1(this.this$1)));
                    }
                });
            }
        }

        static /* synthetic */ ISystemViewElementAdapter access$0(PollingThread pollingThread) {
            return pollingThread._adapter;
        }

        static /* synthetic */ Object access$1(PollingThread pollingThread) {
            return pollingThread._inputObject;
        }

        static /* synthetic */ void access$2(PollingThread pollingThread, boolean bl) {
            pollingThread._querying = bl;
        }

        static /* synthetic */ MonitorViewPage access$3(PollingThread pollingThread) {
            return pollingThread.MonitorViewPage.this;
        }
    }

    class SelectAllAction
    extends Action {
        public SelectAllAction() {
            super(SystemResources.ACTION_SELECT_ALL_LABEL, null);
            this.setToolTipText(SystemResources.ACTION_SELECT_ALL_TOOLTIP);
        }

        public void checkEnabledState() {
            this.setEnabled(true);
        }

        public void run() {
            SystemTableView view = MonitorViewPage.this._viewer;
            view.getTable().selectAll();
            view.setSelection(view.getSelection());
        }
    }
}

