/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.p2repo.aggregator.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.cbi.p2repo.aggregator.Aggregation;
import org.eclipse.cbi.p2repo.aggregator.AggregatorFactory;
import org.eclipse.cbi.p2repo.aggregator.AggregatorPackage;
import org.eclipse.cbi.p2repo.aggregator.Contribution;
import org.eclipse.cbi.p2repo.aggregator.MappedRepository;
import org.eclipse.cbi.p2repo.aggregator.MappedUnit;
import org.eclipse.cbi.p2repo.aggregator.MavenMapping;
import org.eclipse.cbi.p2repo.aggregator.MetadataRepositoryReference;
import org.eclipse.cbi.p2repo.aggregator.ValidationSet;
import org.eclipse.cbi.p2repo.aggregator.provider.AggregatorEditPlugin;
import org.eclipse.cbi.p2repo.aggregator.provider.AggregatorItemProviderAdapter;
import org.eclipse.cbi.p2repo.aggregator.util.GeneralUtils;
import org.eclipse.cbi.p2repo.aggregator.util.ResourceUtils;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemColorProvider;
import org.eclipse.emf.edit.provider.IItemFontProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;

public class ValidationSetItemProvider
extends AggregatorItemProviderAdapter
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource,
IItemColorProvider,
IItemFontProvider {
    public ValidationSetItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    protected void addDescriptionPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_DescriptionProvider_description_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_DescriptionProvider_description_feature", "_UI_DescriptionProvider_type"), (EStructuralFeature)AggregatorPackage.Literals.DESCRIPTION_PROVIDER__DESCRIPTION, true, true, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addEnabledPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_EnabledStatusProvider_enabled_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_EnabledStatusProvider_enabled_feature", "_UI_EnabledStatusProvider_type"), (EStructuralFeature)AggregatorPackage.Literals.ENABLED_STATUS_PROVIDER__ENABLED, true, false, false, ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE, null, null));
    }

    protected void addExtendsPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(new ItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_ValidationSet_extends_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_ValidationSet_extends_feature", "_UI_ValidationSet_type"), (EStructuralFeature)AggregatorPackage.Literals.VALIDATION_SET__EXTENDS, true, false, true, null, null, null){

            public Collection<?> getChoiceOfValues(Object object) {
                ValidationSet vs = (ValidationSet)object;
                List candidates = (List)super.getChoiceOfValues(object);
                ArrayList<ValidationSet> filtered = new ArrayList<ValidationSet>();
                for (ValidationSet candidate : candidates) {
                    if (vs.isExtensionOf(candidate)) continue;
                    filtered.add(candidate);
                }
                return filtered;
            }
        });
    }

    protected void addLabelPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_ValidationSet_label_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_ValidationSet_label_feature", "_UI_ValidationSet_type"), (EStructuralFeature)AggregatorPackage.Literals.VALIDATION_SET__LABEL, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
        newChildDescriptors.add(this.createChildParameter(AggregatorPackage.Literals.VALIDATION_SET__CONTRIBUTIONS, AggregatorFactory.eINSTANCE.createContribution()));
        newChildDescriptors.add(this.createChildParameter(AggregatorPackage.Literals.VALIDATION_SET__VALIDATION_REPOSITORIES, AggregatorFactory.eINSTANCE.createMetadataRepositoryReference()));
        newChildDescriptors.add(this.createChildParameter(AggregatorPackage.Literals.VALIDATION_SET__VALIDATION_REPOSITORIES, AggregatorFactory.eINSTANCE.createMappedRepository()));
    }

    protected Command createAddCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Collection<?> collection, int index) {
        if (feature == AggregatorPackage.Literals.VALIDATION_SET__VALIDATION_REPOSITORIES) {
            for (Object object : collection) {
                if (!(this.unwrap(object) instanceof MappedRepository)) continue;
                return UnexecutableCommand.INSTANCE;
            }
        }
        return super.createAddCommand(domain, owner, feature, collection, index);
    }

    protected EStructuralFeature getChildFeature(Object object, Object child) {
        return super.getChildFeature(object, child);
    }

    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            super.getChildrenFeatures(object);
            this.childrenFeatures.add(AggregatorPackage.Literals.VALIDATION_SET__CONTRIBUTIONS);
            this.childrenFeatures.add(AggregatorPackage.Literals.VALIDATION_SET__VALIDATION_REPOSITORIES);
        }
        return this.childrenFeatures;
    }

    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/ValidationSet" + (((ValidationSet)object).isEnabled() ? "" : "Disabled")));
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addEnabledPropertyDescriptor(object);
            this.addDescriptionPropertyDescriptor(object);
            this.addLabelPropertyDescriptor(object);
            this.addExtendsPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    public ResourceLocator getResourceLocator() {
        return AggregatorEditPlugin.INSTANCE;
    }

    public String getText(Object object) {
        EList exs;
        int top;
        ValidationSet self = (ValidationSet)object;
        String label = self.getLabel();
        StringBuilder bld = new StringBuilder(this.getString("_UI_ValidationSet_type")).append(" : ");
        if (label != null) {
            bld.append(label);
        }
        if (self.isExtension() && (top = (exs = self.getExtends()).size()) > 0) {
            bld.append(" extends ");
            bld.append(((ValidationSet)exs.get(0)).getLabel());
            int idx = 1;
            while (idx < top) {
                bld.append(", ");
                bld.append(((ValidationSet)exs.get(idx)).getLabel());
                ++idx;
            }
        }
        return bld.toString();
    }

    public void notifyChanged(Notification notification) {
        this.notifyChangedGen(notification);
        if (notification.getNotifier() instanceof ValidationSet) {
            ValidationSet vs = (ValidationSet)notification.getNotifier();
            Aggregation aggr = (Aggregation)((EObject)vs).eContainer();
            switch (notification.getFeatureID(ValidationSet.class)) {
                case 1: 
                case 3: {
                    this.fireNotifyChanged((Notification)new ViewerNotification(notification, (Object)aggr, true, true));
                    for (ValidationSet other : aggr.getValidationSets(true)) {
                        if (other == vs || !other.isExtensionOf(vs)) continue;
                        this.fireNotifyChanged((Notification)new ViewerNotification(notification, (Object)other, false, true));
                    }
                    return;
                }
            }
        }
        if (notification.getEventType() == 4) {
            Object oldV = notification.getOldValue();
            if (oldV instanceof Contribution || oldV instanceof MetadataRepositoryReference) {
                ResourceUtils.cleanUpResources((Aggregation)GeneralUtils.getAggregation((EObject)((EObject)notification.getNotifier())));
            }
            if (oldV instanceof MetadataRepositoryReference || oldV instanceof MavenMapping) {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
            }
        } else if (notification.getEventType() == 3) {
            Object newV;
            Aggregation aggregation = GeneralUtils.getAggregation((EObject)((EObject)notification.getNotifier()));
            if (aggregation != null) {
                for (ValidationSet vs : aggregation.getValidationSets(true)) {
                    for (Contribution contribution : vs.getDeclaredContributions()) {
                        for (MappedRepository mappedRepo : contribution.getRepositories(true)) {
                            for (MappedUnit unit : mappedRepo.getUnits(false)) {
                                unit.resolveAvailableVersions(true);
                            }
                        }
                    }
                }
            }
            if ((newV = notification.getNewValue()) instanceof Contribution) {
                for (MappedRepository mappedRepository : ((Contribution)newV).getRepositories(true)) {
                    ResourceUtils.loadResourceForMappedRepository((MetadataRepositoryReference)mappedRepository);
                }
            } else if (newV instanceof MetadataRepositoryReference) {
                ResourceUtils.loadResourceForMappedRepository((MetadataRepositoryReference)((MetadataRepositoryReference)newV));
            }
            if (newV instanceof MetadataRepositoryReference || newV instanceof MavenMapping) {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
            }
        }
    }

    public void notifyChangedGen(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(ValidationSet.class)) {
            case 1: 
            case 2: 
            case 3: 
            case 9: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
            case 10: 
            case 11: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                return;
            }
        }
        super.notifyChanged(notification);
    }
}

