/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.p2repo.p2.maven.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cbi.p2repo.aggregator.VersionFormat;
import org.eclipse.cbi.p2repo.util.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.equinox.p2.metadata.IVersionFormat;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;

public class VersionUtil {
    private static Pattern versionRangePattern = Pattern.compile("^(\\([)([^,]+),([^,]+)(\\)])$");
    private static final Pattern timestampPattern = Pattern.compile("^((?:19|20)\\d{2}(?:0[1-9]|1[012])(?:0[1-9]|[12][0-9]|3[01]))(?:\\.((?:[01][0-9]|2[0-3])[0-5][0-9][0-5][0-9]))?$");
    private static final Pattern mavenTrickPattern = Pattern.compile("^\\d+\\.\\d+\\.\\d+(?:\\.\\d+-[a-zA-Z][a-zA-Z0-9_]*)?$");
    private static final Pattern osgiPattern = Pattern.compile("^(\\d+\\.\\d+\\.\\d+)\\.([a-zA-Z0-9_-]+)$");

    public static Version createVersion(String versionStr) throws CoreException {
        if ((versionStr = StringUtils.trimmedOrNull((String)versionStr)) == null) {
            return null;
        }
        Matcher m = timestampPattern.matcher(versionStr);
        if (m.matches()) {
            return VersionUtil.createVersionFromFormatAndOriginal("S=[0-9];={8};[.S=[0-9];={6};='000000';]", versionStr);
        }
        try {
            return VersionUtil.createVersionFromFormatAndOriginal("n[.n=0;[.n=0;]][d?S=M;]", versionStr);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return VersionUtil.createVersionFromFormatAndOriginal("S", versionStr);
        }
    }

    public static Version createVersionFromFormatAndOriginal(String format, String versionStr) {
        return Version.parseVersion((String)("format(" + format + "):" + versionStr));
    }

    public static VersionRange createVersionRange(String versionRangeString) throws CoreException {
        String vr = StringUtils.trimmedOrNull((String)versionRangeString);
        if (vr == null) {
            return VersionRange.emptyRange;
        }
        Matcher m = versionRangePattern.matcher(vr);
        if (m.matches()) {
            return new VersionRange(VersionUtil.createVersion(m.group(2)), "[".equals(m.group(1)), VersionUtil.createVersion(m.group(3)), "[".equals(m.group(4)));
        }
        Version v = VersionUtil.createVersion(vr);
        return new VersionRange(v, true, Version.MAX_VERSION, true);
    }

    public static String getVersionString(Version version) {
        String versionString = version.getOriginal();
        if (versionString == null) {
            versionString = version.toString();
        }
        return versionString;
    }

    public static String getVersionString(Version version, VersionFormat versionFormat) {
        if (version instanceof MappedVersion) {
            return version.getOriginal();
        }
        String versionString = VersionUtil.getVersionString(version);
        if (versionFormat == VersionFormat.NORMAL) {
            return versionString;
        }
        Matcher m = mavenTrickPattern.matcher(versionString);
        if (m.matches()) {
            return versionString;
        }
        m = osgiPattern.matcher(versionString);
        if (!m.matches()) {
            return versionString;
        }
        if (versionFormat == VersionFormat.MAVEN_RELEASE) {
            return m.group(1);
        }
        StringBuilder bld = new StringBuilder();
        bld.append(m.group(1));
        bld.append('-');
        bld.append(m.group(2));
        return bld.toString();
    }

    public static Version mappedVersion(String original) {
        return new MappedVersion(Version.create((String)original), original);
    }

    private static class MappedVersion
    extends Version {
        private static final long serialVersionUID = 1L;
        private final String mappedVersion;
        private final Version version;

        public MappedVersion(Version version, String mappedVersion) {
            this.mappedVersion = mappedVersion;
            this.version = version;
        }

        public int compareTo(Version o) {
            if (o instanceof MappedVersion) {
                o = ((MappedVersion)o).version;
            }
            return this.version.compareTo((Object)o);
        }

        public IVersionFormat getFormat() {
            return this.version.getFormat();
        }

        public String getOriginal() {
            return this.mappedVersion;
        }

        public Comparable<?> getPad() {
            return this.version.getPad();
        }

        public Comparable<?> getSegment(int index) {
            return this.version.getSegment(index);
        }

        public int getSegmentCount() {
            return this.version.getSegmentCount();
        }

        public boolean isOSGiCompatible() {
            return this.version.isOSGiCompatible();
        }

        public void toString(StringBuffer sb) {
            sb.append(this.mappedVersion);
        }
    }
}

