/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.p2repo.aggregator.presentation;

import org.eclipse.cbi.p2repo.aggregator.Contribution;
import org.eclipse.cbi.p2repo.aggregator.presentation.UIUtils;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.action.ControlAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class DetachContributionResourceAction
extends ControlAction {
    private static final String LABEL_DETACH_RESOURCE = "Detach Resource";
    private static final String LABEL_ATTACH_RESOURCE = "Attach Resource";

    public DetachContributionResourceAction() {
        this.setText(LABEL_DETACH_RESOURCE);
    }

    public DetachContributionResourceAction(EditingDomain domain) {
        super(domain);
        this.setText(LABEL_DETACH_RESOURCE);
    }

    protected Resource getResource() {
        DetachContributionResourceDialog dialog = new DetachContributionResourceDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), this.domain, this.eObject);
        dialog.open();
        return dialog.getResource();
    }

    public void run() {
        String commandLabel = null;
        commandLabel = this.command == null ? LABEL_DETACH_RESOURCE : LABEL_ATTACH_RESOURCE;
        super.run();
        if (this.command != null) {
            ((AbstractCommand)this.command).setLabel(commandLabel);
        }
    }

    public boolean updateSelection(IStructuredSelection selection) {
        boolean result = super.updateSelection(selection);
        if (selection.size() != 1) {
            return false;
        }
        Object object = AdapterFactoryEditingDomain.unwrap((Object)selection.getFirstElement());
        if (!AdapterFactoryEditingDomain.isControlled((Object)object)) {
            this.setText(LABEL_DETACH_RESOURCE);
        } else {
            this.setText(LABEL_ATTACH_RESOURCE);
        }
        result = result && object instanceof Contribution;
        return result;
    }

    protected static class DetachContributionResourceDialog
    extends ControlAction.ControlResourceDialog {
        private static final String CONTRIBUTION_FILE_EXTENSION = "aggrcon";
        private static final String UNTITLED_FILE_NAME = "untitled";
        private EObject currentEObject;

        public DetachContributionResourceDialog(Shell parent, EditingDomain domain, EObject currentEObject) {
            super(parent, domain, currentEObject.eResource());
            this.currentEObject = currentEObject;
            this.title = DetachContributionResourceAction.LABEL_DETACH_RESOURCE;
        }

        protected Control createDialogArea(Composite parent) {
            Control control = super.createDialogArea(parent);
            URI uri = this.currentEObject.eResource().getURI();
            String mainResourceUri = uri.toString();
            if (uri.lastSegment().contains(".")) {
                mainResourceUri = mainResourceUri.replaceAll("\\.[^.]*$", "");
            }
            String lastSegment = UIUtils.trimmedValue(((Contribution)this.currentEObject).getLabel()) != null ? "." + ((Contribution)this.currentEObject).getLabel() + "." + CONTRIBUTION_FILE_EXTENSION : ".untitled.aggrcon";
            String newUriString = String.valueOf(mainResourceUri) + this.removeUnsupportedChars(lastSegment);
            this.uriField.setText(newUriString);
            return control;
        }

        private String removeUnsupportedChars(String lastSegment) {
            return lastSegment.replaceAll("[^\\w\\.\\(\\)]", "_");
        }
    }
}

