/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.configeditor;

import org.eclipse.jface.text.Position;
import org.eclipse.titan.common.parsers.Interval;
import org.eclipse.titan.designer.editors.FoldingSupport;

public final class ConfigFoldingSupport
extends FoldingSupport {
    @Override
    protected void recursiveTokens(Interval interval) {
        int distance;
        int endOffset = interval.getEndOffset();
        int startOffset = interval.getStartOffset();
        if (this.documentText.length() <= endOffset || this.documentText.length() <= startOffset) {
            return;
        }
        if (endOffset == -1) {
            endOffset = this.documentText.length() - 1;
        }
        if ((distance = interval.getEndLine() - interval.getStartLine()) >= this.foldingDistance) {
            char temp = this.documentText.charAt(startOffset);
            switch (temp) {
                case '[': 
                case '{': {
                    if (!this.preferencesService.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.foldStatementBlocks", true, null)) break;
                    this.positions.add(new Position(startOffset, endOffset - startOffset));
                    break;
                }
                case '(': {
                    if (!this.preferencesService.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.foldParenthesis", true, null)) break;
                    this.positions.add(new Position(startOffset, endOffset - startOffset));
                    break;
                }
                case '/': {
                    if (!this.preferencesService.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.foldComments", true, null)) break;
                    this.positions.add(new Position(startOffset, endOffset - startOffset));
                    break;
                }
            }
        }
        for (Interval subIntervall : interval.getSubIntervals()) {
            this.recursiveTokens(subIntervall);
        }
    }
}

