/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameterList;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class FieldSubReference
implements ISubReference,
ILocateableNode {
    public static final String INVALIDSUBREFERENCE = "Invalid field reference `{0}'': type `{1}'' does not have fields.";
    public static final String NONEXISTENTSUBREFERENCE = "Reference to a non-existent field `{0}'' in type `{1}''";
    private final Identifier fieldId;

    public FieldSubReference(Identifier fieldId) {
        this.fieldId = fieldId;
    }

    @Override
    public ISubReference.Subreference_type getReferenceType() {
        return ISubReference.Subreference_type.fieldSubReference;
    }

    @Override
    public Identifier getId() {
        return this.fieldId;
    }

    @Override
    public void setMyScope(Scope scope) {
    }

    @Override
    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
    }

    @Override
    public String getFullName() {
        return "";
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        return new StringBuilder();
    }

    @Override
    public INamedNode getNameParent() {
        return null;
    }

    @Override
    public void setFullNameParent(INamedNode nameParent) {
    }

    @Override
    public void setLocation(Location location) {
        if (null != this.fieldId) {
            this.fieldId.setLocation(location);
        }
    }

    @Override
    public Location getLocation() {
        return new Location(this.fieldId.getLocation());
    }

    public String toString() {
        return "fieldSubReference: " + this.fieldId.getDisplayName();
    }

    @Override
    public void appendDisplayName(StringBuilder builder) {
        if (builder.length() > 0) {
            builder.append('.');
        }
        builder.append(this.fieldId.getDisplayName());
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        reparser.updateLocation(this.fieldId.getLocation());
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
    }

    @Override
    public boolean accept(ASTVisitor v) {
        switch (v.visit(this)) {
            case 2: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        if (this.fieldId != null && !this.fieldId.accept(v)) {
            return false;
        }
        return v.leave(this) != 2;
    }

    public static String getJavaGetterName(String aTtcn3RecField) {
        return aTtcn3RecField.replace('.', '_');
    }

    @Override
    public boolean hasSingleExpression(FormalParameterList formalParameterList) {
        return true;
    }

    @Override
    public void generateCode(JavaGenData aData, ExpressionStruct expression, boolean isFirst) {
        if (this.fieldId != null) {
            if (isFirst) {
                expression.expression.append(this.fieldId.getName());
            } else {
                expression.expression.append(MessageFormat.format(".get_field_{0}()", FieldSubReference.getJavaGetterName(this.fieldId.getName())));
            }
        }
    }
}

