/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.refactoring.movefunction;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titanium.refactoring.movefunction.Destination;
import org.eclipse.titanium.refactoring.movefunction.FunctionData;
import org.eclipse.titanium.refactoring.movefunction.MoveFunctionWizardDestinationsPage;

class DestinationDataProvider
implements ITreeContentProvider {
    DestinationDataProvider() {
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof Map) {
            Map map = (Map)inputElement;
            ArrayList<FunctionData> obj = new ArrayList<FunctionData>();
            for (Map.Entry entry : map.entrySet()) {
                for (FunctionData fd : (List)entry.getValue()) {
                    if (!fd.isToBeMoved() || fd.getDestinations().isEmpty()) continue;
                    obj.add(fd);
                }
            }
            if (obj.isEmpty()) {
                return new Object[]{"No new destinations found for the function(s)."};
            }
            Collections.sort(obj);
            return obj.toArray();
        }
        return new Object[]{"No new destinations found for the function(s)."};
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof FunctionData && !((FunctionData)parentElement).getDestinations().isEmpty()) {
            ArrayList<Destination> destinations = new ArrayList<Destination>();
            for (Destination dest : ((FunctionData)parentElement).getDestinations()) {
                if (!MoveFunctionWizardDestinationsPage.displayZeros && dest.getRating() != 0) {
                    destinations.add(dest);
                    continue;
                }
                if (!MoveFunctionWizardDestinationsPage.displayZeros) continue;
                destinations.add(dest);
            }
            Collections.sort(destinations, new Comparator<Destination>(){

                @Override
                public int compare(Destination arg0, Destination arg1) {
                    int val = -1 * (arg0.getRating() - arg1.getRating());
                    int val2 = 0;
                    if (val == 0 && arg0.getNewImports() != -1) {
                        val2 = arg1.getNewImports() - arg0.getNewImports();
                    }
                    if (val == 0 && val2 == 0) {
                        return arg0.getModule().getIdentifier().getDisplayName().compareTo(arg1.getModule().getIdentifier().getDisplayName());
                    }
                    return val;
                }
            });
            return destinations.toArray();
        }
        return null;
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof Module) {
            return false;
        }
        return element instanceof FunctionData && !((FunctionData)element).getDestinations().isEmpty();
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

