/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.common.utils;

import java.io.IOException;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.utils.Appender;

public final class Joiner {
    private static final String CANNOT_HAPPEN = "Cannot happen";
    private final Appender appender;
    private final StringBuilder builder = new StringBuilder();

    public Joiner() {
        this("");
    }

    public Joiner(String delimiter) {
        this.appender = new Appender(this.builder, delimiter);
    }

    public Joiner join(Object item) {
        try {
            this.appender.append(item);
        }
        catch (IOException e) {
            ErrorReporter.logExceptionStackTrace(CANNOT_HAPPEN, e);
        }
        return this;
    }

    public Joiner join(Iterable<?> items) {
        try {
            this.appender.append(items);
        }
        catch (IOException e) {
            ErrorReporter.logExceptionStackTrace(CANNOT_HAPPEN, e);
        }
        return this;
    }

    public Appendable appendTo(Appendable appendable) throws IOException {
        return appendable.append(this.builder.toString());
    }

    public StringBuilder appendTo(StringBuilder appendable) {
        return appendable.append(this.builder.toString());
    }

    public String toString() {
        return this.builder.toString();
    }
}

