/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.runtime.core;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.titan.runtime.core.AdditionalFunctions;
import org.eclipse.titan.runtime.core.Base_Type;
import org.eclipse.titan.runtime.core.JSON;
import org.eclipse.titan.runtime.core.JSON_Tokenizer;
import org.eclipse.titan.runtime.core.Param_Types;
import org.eclipse.titan.runtime.core.RAW;
import org.eclipse.titan.runtime.core.TTCN_Buffer;
import org.eclipse.titan.runtime.core.TTCN_EncDec;
import org.eclipse.titan.runtime.core.TTCN_EncDec_ErrorContext;
import org.eclipse.titan.runtime.core.TTCN_Logger;
import org.eclipse.titan.runtime.core.Text_Buf;
import org.eclipse.titan.runtime.core.TitanCharString;
import org.eclipse.titan.runtime.core.TitanHexString_Element;
import org.eclipse.titan.runtime.core.TitanInteger;
import org.eclipse.titan.runtime.core.TitanString_Utils;
import org.eclipse.titan.runtime.core.TtcnError;

public class TitanHexString
extends Base_Type {
    public static final RAW.TTCN_RAWdescriptor TitanHexString_raw_ = new RAW.TTCN_RAWdescriptor(0, RAW.raw_sign_t.SG_NO, TTCN_EncDec.raw_order_t.ORDER_LSB, TTCN_EncDec.raw_order_t.ORDER_LSB, TTCN_EncDec.raw_order_t.ORDER_LSB, TTCN_EncDec.raw_order_t.ORDER_LSB, RAW.ext_bit_t.EXT_BIT_NO, TTCN_EncDec.raw_order_t.ORDER_LSB, TTCN_EncDec.raw_order_t.ORDER_LSB, RAW.top_bit_order_t.TOP_BIT_INHERITED, 0, 0, 0, 8, 0, null, -1, TitanCharString.CharCoding.UNKNOWN, null, false);
    public static final JSON.TTCN_JSONdescriptor TitanHexString_json_ = new JSON.TTCN_JSONdescriptor(false, null, false, null, false, false, false, 0, null, false, JSON.json_string_escaping.ESCAPE_AS_SHORT);
    public static final Base_Type.TTCN_Typedescriptor TitanHexString_descr_ = new Base_Type.TTCN_Typedescriptor("hexstring", null, TitanHexString_raw_, TitanHexString_json_, null);
    static final String HEX_DIGITS = "0123456789ABCDEF?*";
    private byte[] nibbles_ptr;

    public TitanHexString() {
    }

    public TitanHexString(byte[] otherValue) {
        this.nibbles_ptr = TitanString_Utils.copy_byte_list(otherValue);
    }

    public TitanHexString(TitanHexString otherValue) {
        otherValue.must_bound("Copying an unbound hexstring value.");
        this.nibbles_ptr = TitanString_Utils.copy_byte_list(otherValue.nibbles_ptr);
    }

    public TitanHexString(TitanHexString_Element otherValue) {
        otherValue.must_bound("Initialization from an unbound hexstring element.");
        this.nibbles_ptr = new byte[1];
        this.nibbles_ptr[0] = otherValue.get_nibble();
    }

    public TitanHexString(byte aValue) {
        this.nibbles_ptr = new byte[1];
        this.nibbles_ptr[0] = aValue;
    }

    public TitanHexString(String aValue) {
        this.nibbles_ptr = TitanHexString.hexstr2bytelist(aValue);
    }

    private void clearUnusedNibble() {
        if (this.nibbles_ptr.length % 2 == 1) {
            this.nibbles_ptr[this.nibbles_ptr.length / 2] = (byte)(this.nibbles_ptr[this.nibbles_ptr.length / 2] & 0xF);
        }
    }

    private static byte[] hexstr2bytelist(String aHexString) {
        int len = aHexString.length();
        byte[] result = new byte[len];
        for (int i = 0; i < len; ++i) {
            byte byteValue;
            char hexDigit = aHexString.charAt(i);
            result[i] = byteValue = TitanHexString.hexdigit2byte(hexDigit);
        }
        return result;
    }

    static byte hexdigit2byte(char aHexDigit) {
        byte result = '0' <= aHexDigit && aHexDigit <= '9' ? (byte)(aHexDigit - 48) : ('A' <= aHexDigit && aHexDigit <= 'F' ? (byte)(aHexDigit - 65 + 10) : ('a' <= aHexDigit && aHexDigit <= 'f' ? (byte)(aHexDigit - 97 + 10) : (byte)0));
        return result;
    }

    public byte get_nibble(int nibble_index) {
        return this.nibbles_ptr[nibble_index];
    }

    void set_nibble(int nibble_index, byte new_value) {
        this.nibbles_ptr[nibble_index] = new_value;
    }

    public byte[] get_value() {
        return this.nibbles_ptr;
    }

    public void set_value(byte[] other_value) {
        this.nibbles_ptr = other_value;
    }

    public TitanHexString operator_assign(TitanHexString otherValue) {
        otherValue.must_bound("Assignment of an unbound hexstring value.");
        if (otherValue != this) {
            this.nibbles_ptr = TitanString_Utils.copy_byte_list(otherValue.nibbles_ptr);
        }
        return this;
    }

    public TitanHexString operator_assign(TitanHexString_Element otherValue) {
        otherValue.must_bound("Assignment of an unbound hexstring element to a hexstring.");
        this.clean_up();
        this.nibbles_ptr = new byte[1];
        this.nibbles_ptr[0] = otherValue.get_nibble();
        return this;
    }

    @Override
    public TitanHexString operator_assign(Base_Type otherValue) {
        if (otherValue instanceof TitanHexString) {
            return this.operator_assign((TitanHexString)otherValue);
        }
        throw new TtcnError(MessageFormat.format("Internal Error: value `{0}'' can not be cast to hexstring", otherValue));
    }

    @Override
    public boolean is_bound() {
        return this.nibbles_ptr != null;
    }

    @Override
    public boolean is_value() {
        return this.nibbles_ptr != null;
    }

    public TitanInteger lengthof() {
        this.must_bound("Performing lengthof operation on an unbound charstring value.");
        return new TitanInteger(this.nibbles_ptr.length);
    }

    public boolean operator_equals(TitanHexString otherValue) {
        this.must_bound("Unbound left operand of hexstring comparison.");
        otherValue.must_bound("Unbound right operand of hexstring comparison.");
        return Arrays.equals(this.nibbles_ptr, otherValue.nibbles_ptr);
    }

    public boolean operator_equals(TitanHexString_Element otherValue) {
        this.must_bound("Unbound left operand of hexstring comparison.");
        otherValue.must_bound("Unbound right operand of hexstring element comparison.");
        if (this.nibbles_ptr.length != 1) {
            return false;
        }
        return this.get_nibble(0) == otherValue.get_nibble();
    }

    @Override
    public boolean operator_equals(Base_Type otherValue) {
        if (otherValue instanceof TitanHexString) {
            return this.operator_equals((TitanHexString)otherValue);
        }
        throw new TtcnError(MessageFormat.format("Internal Error: value `{0}'' can not be cast to hexstring", otherValue));
    }

    public boolean operator_not_equals(TitanHexString otherValue) {
        return !this.operator_equals(otherValue);
    }

    public boolean operator_not_equals(TitanHexString_Element otherValue) {
        return !this.operator_equals(otherValue);
    }

    @Override
    public void clean_up() {
        this.nibbles_ptr = null;
    }

    public TitanHexString_Element get_at(int index_value) {
        if (this.nibbles_ptr == null && index_value == 0) {
            this.nibbles_ptr = new byte[1];
            return new TitanHexString_Element(false, this, 0);
        }
        this.must_bound("Accessing an element of an unbound hexstring value.");
        if (index_value < 0) {
            throw new TtcnError("Accessing an hexstring element using a negative index (" + index_value + ").");
        }
        int n_nibbles = this.nibbles_ptr.length;
        if (index_value > n_nibbles) {
            throw new TtcnError("Index overflow when accessing a hexstring element: The index is " + index_value + ", but the string has only " + n_nibbles + " hexadecimal digits.");
        }
        if (index_value == n_nibbles) {
            byte[] temp = new byte[this.nibbles_ptr.length + 1];
            System.arraycopy(this.nibbles_ptr, 0, temp, 0, this.nibbles_ptr.length);
            this.nibbles_ptr = temp;
            return new TitanHexString_Element(false, this, index_value);
        }
        return new TitanHexString_Element(true, this, index_value);
    }

    public TitanHexString_Element get_at(TitanInteger index_value) {
        index_value.must_bound("Indexing a hexstring value with an unbound integer value.");
        return this.get_at(index_value.get_int());
    }

    public final TitanHexString_Element constGet_at(int index_value) {
        this.must_bound("Accessing an element of an unbound hexstring value.");
        if (index_value < 0) {
            throw new TtcnError("Accessing an hexstring element using a negative index (" + index_value + ").");
        }
        int n_nibbles = this.nibbles_ptr.length;
        if (index_value >= n_nibbles) {
            throw new TtcnError("Index overflow when accessing a hexstring element: The index is " + index_value + ", but the string has only " + n_nibbles + " hexadecimal digits.");
        }
        return new TitanHexString_Element(true, this, index_value);
    }

    public final TitanHexString_Element constGet_at(TitanInteger index_value) {
        index_value.must_bound("Indexing a hexstring value with an unbound integer value.");
        return this.constGet_at(index_value.get_int());
    }

    @Override
    public void log() {
        if (this.nibbles_ptr != null) {
            TTCN_Logger.log_char('\'');
            for (int i = 0; i < this.nibbles_ptr.length; ++i) {
                TTCN_Logger.log_hex(this.get_nibble(i));
            }
            TTCN_Logger.log_event_str("'H");
        } else {
            TTCN_Logger.log_event_unbound();
        }
    }

    public String toString() {
        if (this.nibbles_ptr == null) {
            return "<unbound>";
        }
        StringBuilder sb = new StringBuilder();
        int size = this.nibbles_ptr.length;
        for (int i = 0; i < size; ++i) {
            Byte digit = this.nibbles_ptr[i];
            sb.append(HEX_DIGITS.charAt(digit.byteValue()));
        }
        return sb.toString();
    }

    @Override
    public void encode_text(Text_Buf text_buf) {
        this.must_bound("Text encoder: Encoding an unbound hexstring value.");
        int nibbles = this.nibbles_ptr.length;
        text_buf.push_int(nibbles);
        if (nibbles > 0) {
            text_buf.push_raw(this.nibbles_ptr);
        }
    }

    @Override
    public void decode_text(Text_Buf text_buf) {
        this.clean_up();
        int n_nibbles = text_buf.pull_int().get_int();
        if (n_nibbles < 0) {
            throw new TtcnError("Text decoder: Invalid length was received for a hexstring.");
        }
        this.nibbles_ptr = new byte[n_nibbles];
        if (n_nibbles > 0) {
            text_buf.pull_raw(n_nibbles, this.nibbles_ptr);
        }
    }

    @Override
    public void set_param(Param_Types.Module_Parameter param) {
        param.basic_check(Param_Types.Module_Parameter.basic_check_bits_t.BC_VALUE.getValue() | Param_Types.Module_Parameter.basic_check_bits_t.BC_LIST.getValue(), "hexstring value");
        if (param.get_type() == Param_Types.Module_Parameter.type_t.MP_Reference) {
            param = param.get_referenced_param().get();
        }
        block0 : switch (param.get_type()) {
            case MP_Hexstring: {
                switch (param.get_operation_type()) {
                    case OT_ASSIGN: {
                        this.clean_up();
                        this.nibbles_ptr = new byte[param.get_string_size()];
                        System.arraycopy((byte[])param.get_string_data(), 0, this.nibbles_ptr, 0, param.get_string_size());
                        this.clearUnusedNibble();
                        break block0;
                    }
                    case OT_CONCAT: {
                        TitanHexString temp = new TitanHexString((byte[])param.get_string_data());
                        if (this.is_bound()) {
                            this.operator_assign(this.operator_concatenate(temp));
                            break block0;
                        }
                        this.operator_assign(temp);
                        break block0;
                    }
                }
                throw new TtcnError("Internal error: TitanHexString.set_param()");
            }
            case MP_Expression: {
                if (param.get_expr_type() == Param_Types.Module_Parameter.expression_operand_t.EXPR_CONCATENATE) {
                    TitanHexString operand1 = new TitanHexString();
                    TitanHexString operand2 = new TitanHexString();
                    operand1.set_param(param.get_operand1());
                    operand2.set_param(param.get_operand2());
                    if (param.get_operation_type() == Param_Types.Module_Parameter.operation_type_t.OT_CONCAT) {
                        this.operator_assign(this.operator_concatenate(operand1).operator_concatenate(operand2));
                        break;
                    }
                    this.operator_assign(operand1.operator_concatenate(operand2));
                    break;
                }
                param.expr_type_error("a hexstring");
                break;
            }
            default: {
                param.type_error("hexstring value");
            }
        }
    }

    @Override
    public Param_Types.Module_Parameter get_param(Param_Types.Module_Param_Name param_name) {
        if (!this.is_bound()) {
            return new Param_Types.Module_Param_Unbound();
        }
        return new Param_Types.Module_Param_Hexstring(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encode(Base_Type.TTCN_Typedescriptor p_td, TTCN_Buffer p_buf, TTCN_EncDec.coding_type p_coding, int flavour) {
        switch (p_coding) {
            case CT_RAW: {
                TTCN_EncDec_ErrorContext errorContext = new TTCN_EncDec_ErrorContext("While RAW-encoding type '%s': ", p_td.name);
                try {
                    if (p_td.raw == null) {
                        TTCN_EncDec_ErrorContext.error_internal("No RAW descriptor available for type '%s'.", p_td.name);
                    }
                    RAW.RAW_enc_tr_pos tree_position = new RAW.RAW_enc_tr_pos(0, null);
                    RAW.RAW_enc_tree root = new RAW.RAW_enc_tree(true, null, tree_position, 1, p_td.raw);
                    this.RAW_encode(p_td, root);
                    root.put_to_buf(p_buf);
                    break;
                }
                finally {
                    errorContext.leave_context();
                }
            }
            case CT_JSON: {
                TTCN_EncDec_ErrorContext errorContext = new TTCN_EncDec_ErrorContext("While JSON-encoding type '%s': ", p_td.name);
                try {
                    if (p_td.json == null) {
                        TTCN_EncDec_ErrorContext.error_internal("No JSON descriptor available for type '%s'.", p_td.name);
                    }
                    JSON_Tokenizer tok = new JSON_Tokenizer(flavour != 0);
                    this.JSON_encode(p_td, tok);
                    StringBuilder temp = tok.get_buffer();
                    for (int i = 0; i < temp.length(); ++i) {
                        char temp2 = temp.charAt(i);
                        p_buf.put_c((byte)temp2);
                    }
                    break;
                }
                finally {
                    errorContext.leave_context();
                }
            }
            default: {
                throw new TtcnError(MessageFormat.format("Unknown coding method requested to encode type `{0}''", p_td.name));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void decode(Base_Type.TTCN_Typedescriptor p_td, TTCN_Buffer p_buf, TTCN_EncDec.coding_type p_coding, int flavour) {
        switch (p_coding) {
            case CT_RAW: {
                TTCN_EncDec_ErrorContext errorContext = new TTCN_EncDec_ErrorContext("While RAW-decoding type '%s': ", p_td.name);
                try {
                    TTCN_EncDec.raw_order_t order;
                    if (p_td.raw == null) {
                        TTCN_EncDec_ErrorContext.error_internal("No RAW descriptor available for type '%s'.", p_td.name);
                    }
                    TTCN_EncDec.raw_order_t raw_order_t2 = order = p_td.raw.top_bit_order == RAW.top_bit_order_t.TOP_BIT_LEFT ? TTCN_EncDec.raw_order_t.ORDER_LSB : TTCN_EncDec.raw_order_t.ORDER_MSB;
                    if (this.RAW_decode(p_td, p_buf, p_buf.get_len() * 8, order) >= 0) break;
                    TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_INCOMPL_MSG, "Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
                    break;
                }
                finally {
                    errorContext.leave_context();
                }
            }
            case CT_JSON: {
                TTCN_EncDec_ErrorContext errorContext = new TTCN_EncDec_ErrorContext("While JSON-decoding type '%s': ", p_td.name);
                try {
                    if (p_td.json == null) {
                        TTCN_EncDec_ErrorContext.error_internal("No JSON descriptor available for type '%s'.", p_td.name);
                    }
                    byte[] data = p_buf.get_data();
                    char[] temp = new char[data.length];
                    for (int i = 0; i < data.length; ++i) {
                        temp[i] = (char)data[i];
                    }
                    JSON_Tokenizer tok = new JSON_Tokenizer(new String(temp), p_buf.get_len());
                    if (this.JSON_decode(p_td, tok, false) < 0) {
                        TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_INCOMPL_MSG, "Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
                    }
                    p_buf.set_pos(tok.get_buf_pos());
                    break;
                }
                finally {
                    errorContext.leave_context();
                }
            }
            default: {
                throw new TtcnError(MessageFormat.format("Unknown coding method requested to decode type `{0}''", p_td.name));
            }
        }
    }

    @Override
    public int JSON_encode(Base_Type.TTCN_Typedescriptor p_td, JSON_Tokenizer p_tok, boolean p_parent_is_map) {
        if (!this.is_bound()) {
            TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_UNBOUND, "Encoding an unbound hexstring value.", new Object[0]);
            return -1;
        }
        StringBuilder tmp_str = new StringBuilder();
        tmp_str.append('\"');
        for (int i = 0; i < this.nibbles_ptr.length; ++i) {
            tmp_str.append(AdditionalFunctions.hexdigit_to_char(this.nibbles_ptr[i]));
        }
        tmp_str.append('\"');
        int enc_len = p_tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_STRING, tmp_str.toString());
        return enc_len;
    }

    @Override
    public int JSON_decode(Base_Type.TTCN_Typedescriptor p_td, JSON_Tokenizer p_tok, boolean p_silent, boolean p_parent_is_map, int p_chosen_field) {
        if (p_td.json.getActualDefaultValue() != null && 0 == p_tok.get_buffer_length()) {
            this.operator_assign(p_td.json.getActualDefaultValue());
            return 0;
        }
        AtomicReference<JSON_Tokenizer.json_token_t> token = new AtomicReference<JSON_Tokenizer.json_token_t>(JSON_Tokenizer.json_token_t.JSON_TOKEN_NONE);
        StringBuilder value = new StringBuilder();
        AtomicInteger value_len = new AtomicInteger(0);
        boolean error = false;
        int dec_len = p_tok.get_next_token(token, value, value_len);
        if (JSON_Tokenizer.json_token_t.JSON_TOKEN_ERROR == token.get()) {
            if (!p_silent) {
                TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_INVAL_MSG, "Failed to extract valid token, invalid JSON format%s", "");
            }
            return -2;
        }
        if (JSON_Tokenizer.json_token_t.JSON_TOKEN_STRING == token.get()) {
            if (value_len.get() >= 2 && value.charAt(0) == '\"' && value.charAt(value_len.get() - 1) == '\"') {
                String valueWithoutQuotes = value.substring(1, value.length() - 1);
                value.setLength(0);
                value.append(valueWithoutQuotes);
                value_len.set(value.length());
                int nibbles = value_len.get();
                for (int i = 0; i < value_len.get(); ++i) {
                    if (value.charAt(i) == ' ') {
                        --nibbles;
                        continue;
                    }
                    if (TitanHexString.isxdigit(value.charAt(i))) continue;
                    if (value.charAt(i) == '\\' && i + 1 < value_len.get() && (value.charAt(i + 1) == 'n' || value.charAt(i + 1) == 'r' || value.charAt(i + 1) == 't')) {
                        ++i;
                        nibbles -= 2;
                        continue;
                    }
                    error = true;
                    break;
                }
                if (!error) {
                    this.init_struct(nibbles);
                    int nibble_index = 0;
                    for (int i = 0; i < value_len.get(); ++i) {
                        if (!TitanHexString.isxdigit(value.charAt(i))) continue;
                        this.set_nibble(nibble_index, AdditionalFunctions.char_to_hexdigit(value.charAt(i)));
                        ++nibble_index;
                    }
                }
            } else {
                error = true;
            }
        } else {
            return -1;
        }
        if (error) {
            if (!p_silent) {
                TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_INVAL_MSG, "Invalid JSON %s format, expecting %s value", "string", "hexstring");
            }
            return -2;
        }
        return dec_len;
    }

    static boolean isxdigit(char hexdigit) {
        return HEX_DIGITS.indexOf(Character.toUpperCase(hexdigit)) >= 0;
    }

    private void init_struct(int n_nibbles) {
        if (n_nibbles < 0) {
            this.nibbles_ptr = null;
            throw new TtcnError("Initializing a hexstring with a negative length.");
        }
        this.nibbles_ptr = n_nibbles == 0 ? new byte[0] : new byte[n_nibbles];
    }

    @Override
    public boolean is_present() {
        return this.is_bound();
    }

    public TitanHexString operator_concatenate(TitanHexString other_value) {
        this.must_bound("Unbound left operand of hexstring concatenation.");
        other_value.must_bound("Unbound right operand of hexstring concatenation.");
        if (this.nibbles_ptr.length == 0) {
            return new TitanHexString(other_value);
        }
        if (other_value.nibbles_ptr.length == 0) {
            return new TitanHexString(this);
        }
        TitanHexString result = new TitanHexString();
        result.nibbles_ptr = new byte[this.nibbles_ptr.length + other_value.nibbles_ptr.length];
        System.arraycopy(this.nibbles_ptr, 0, result.nibbles_ptr, 0, this.nibbles_ptr.length);
        System.arraycopy(other_value.nibbles_ptr, 0, result.nibbles_ptr, this.nibbles_ptr.length, other_value.nibbles_ptr.length);
        return result;
    }

    public TitanHexString operator_concatenate(TitanHexString_Element other_value) {
        this.must_bound("Unbound left operand of hexstring concatenation.");
        other_value.must_bound("Unbound right operand of hexstring element concatenation.");
        TitanHexString result = new TitanHexString();
        result.nibbles_ptr = new byte[this.nibbles_ptr.length + 1];
        System.arraycopy(this.nibbles_ptr, 0, result.nibbles_ptr, 0, this.nibbles_ptr.length);
        result.nibbles_ptr[this.nibbles_ptr.length] = other_value.get_nibble();
        return result;
    }

    public TitanHexString not4b() {
        this.must_bound("Unbound hexstring operand of operator not4b.");
        int n_bytes = (this.nibbles_ptr.length + 1) / 2;
        if (n_bytes == 0) {
            return new TitanHexString(this);
        }
        TitanHexString result = new TitanHexString();
        result.nibbles_ptr = new byte[this.nibbles_ptr.length];
        for (int i = 0; i < this.nibbles_ptr.length; ++i) {
            result.nibbles_ptr[i] = (byte)(~this.nibbles_ptr[i] & 0xF);
        }
        result.clearUnusedNibble();
        return result;
    }

    public TitanHexString and4b(TitanHexString otherValue) {
        this.must_bound("Left operand of operator and4b is an unbound hexstring value.");
        otherValue.must_bound("Right operand of operator and4b is an unbound hexstring value.");
        if (this.nibbles_ptr.length != otherValue.nibbles_ptr.length) {
            throw new TtcnError("The hexstring operands of operator and4b must have the same length.");
        }
        if (this.nibbles_ptr.length == 0) {
            return new TitanHexString(this);
        }
        TitanHexString result = new TitanHexString();
        result.nibbles_ptr = new byte[this.nibbles_ptr.length];
        for (int i = 0; i < this.nibbles_ptr.length; ++i) {
            result.nibbles_ptr[i] = (byte)(this.nibbles_ptr[i] & otherValue.nibbles_ptr[i]);
        }
        this.clearUnusedNibble();
        return result;
    }

    public TitanHexString and4b(TitanHexString_Element otherValue) {
        this.must_bound("Left operand of operator and4b is an unbound hexstring value.");
        otherValue.must_bound("Right operand of operator and4b is an unbound hexstring element.");
        if (this.nibbles_ptr.length != 1) {
            throw new TtcnError("The hexstring operands of operator and4b must have the same length.");
        }
        byte result = (byte)(this.get_nibble(0) & otherValue.get_nibble());
        return new TitanHexString(result);
    }

    public TitanHexString or4b(TitanHexString otherValue) {
        this.must_bound("Left operand of operator or4b is an unbound hexstring value.");
        otherValue.must_bound("Right operand of operator or4b is an unbound hexstring value.");
        if (this.nibbles_ptr.length != otherValue.nibbles_ptr.length) {
            throw new TtcnError("The hexstring operands of operator or4b must have the same length.");
        }
        if (this.nibbles_ptr.length == 0) {
            return new TitanHexString(this);
        }
        TitanHexString result = new TitanHexString();
        result.nibbles_ptr = new byte[this.nibbles_ptr.length];
        for (int i = 0; i < this.nibbles_ptr.length; ++i) {
            result.nibbles_ptr[i] = (byte)(this.nibbles_ptr[i] | otherValue.nibbles_ptr[i]);
        }
        this.clearUnusedNibble();
        return result;
    }

    public TitanHexString or4b(TitanHexString_Element otherValue) {
        this.must_bound("Left operand of operator or4b is an unbound hexstring value.");
        otherValue.must_bound("Right operand of operator or4b is an unbound hexstring element.");
        if (this.nibbles_ptr.length != 1) {
            throw new TtcnError("The hexstring operands of operator or4b must have the same length.");
        }
        byte result = (byte)(this.get_nibble(0) | otherValue.get_nibble());
        return new TitanHexString(result);
    }

    public TitanHexString xor4b(TitanHexString otherValue) {
        this.must_bound("Left operand of operator xor4b is an unbound hexstring value.");
        otherValue.must_bound("Right operand of operator xor4b is an unbound hexstring value.");
        if (this.nibbles_ptr.length != otherValue.nibbles_ptr.length) {
            throw new TtcnError("The hexstring operands of operator xor4b must have the same length.");
        }
        if (this.nibbles_ptr.length == 0) {
            return new TitanHexString(this);
        }
        TitanHexString result = new TitanHexString();
        result.nibbles_ptr = new byte[this.nibbles_ptr.length];
        for (int i = 0; i < this.nibbles_ptr.length; ++i) {
            result.nibbles_ptr[i] = (byte)(this.nibbles_ptr[i] ^ otherValue.nibbles_ptr[i]);
        }
        this.clearUnusedNibble();
        return result;
    }

    public TitanHexString xor4b(TitanHexString_Element otherValue) {
        this.must_bound("Left operand of operator xor4b is an unbound hexstring value.");
        otherValue.must_bound("Right operand of operator xor4b is an unbound hexstring element.");
        if (this.nibbles_ptr.length != 1) {
            throw new TtcnError("The hexstring operands of operator xor4b must have the same length.");
        }
        byte result = (byte)(this.get_nibble(0) ^ otherValue.get_nibble());
        return new TitanHexString(result);
    }

    public TitanHexString shift_left(int shift_count) {
        this.must_bound("Unbound hexstring operand of shift left operator.");
        if (shift_count > 0) {
            int i;
            if (this.nibbles_ptr.length == 0) {
                return new TitanHexString(this);
            }
            int n_nibbles = this.nibbles_ptr.length;
            TitanHexString result = new TitanHexString();
            result.nibbles_ptr = new byte[this.nibbles_ptr.length];
            if (shift_count > n_nibbles) {
                shift_count = n_nibbles;
            }
            for (i = 0; i < n_nibbles - shift_count; ++i) {
                result.nibbles_ptr[i] = this.nibbles_ptr[i + shift_count];
            }
            for (i = n_nibbles - shift_count; i < n_nibbles; ++i) {
                result.nibbles_ptr[i] = 0;
            }
            return result;
        }
        if (shift_count == 0) {
            return new TitanHexString(this);
        }
        return this.shift_right(-shift_count);
    }

    public TitanHexString shift_left(TitanInteger shift_count) {
        shift_count.must_bound("Unbound right operand of hexstring shift left operator.");
        return this.shift_left(shift_count.get_int());
    }

    public TitanHexString shift_right(int shift_count) {
        this.must_bound("Unbound operand of hexstring shift right operator.");
        if (shift_count > 0) {
            int i;
            if (this.nibbles_ptr.length == 0) {
                return new TitanHexString(this);
            }
            int n_nibbles = this.nibbles_ptr.length;
            TitanHexString result = new TitanHexString();
            result.nibbles_ptr = new byte[this.nibbles_ptr.length];
            if (shift_count > n_nibbles) {
                shift_count = n_nibbles;
            }
            for (i = 0; i < shift_count; ++i) {
                result.nibbles_ptr[i] = 0;
            }
            for (i = 0; i < n_nibbles - shift_count; ++i) {
                result.nibbles_ptr[i + shift_count] = this.nibbles_ptr[i];
            }
            return result;
        }
        if (shift_count == 0) {
            return new TitanHexString(this);
        }
        return this.shift_left(-shift_count);
    }

    public TitanHexString shift_right(TitanInteger shift_count) {
        shift_count.must_bound("Unbound right operand of hexstring right left operator.");
        return this.shift_right(shift_count.get_int());
    }

    public TitanHexString rotate_left(int rotate_count) {
        this.must_bound("Unbound hexstring operand of rotate left operator.");
        if (this.nibbles_ptr.length == 0) {
            return new TitanHexString(this);
        }
        if (rotate_count >= 0) {
            if ((rotate_count %= this.nibbles_ptr.length) == 0) {
                return new TitanHexString(this);
            }
            return this.shift_left(rotate_count).or4b(this.shift_right(this.nibbles_ptr.length - rotate_count));
        }
        return this.rotate_right(-rotate_count);
    }

    public TitanHexString rotate_left(TitanInteger rotate_count) {
        rotate_count.must_bound("Unbound right operand of hexstring rotate left operator.");
        return this.rotate_left(rotate_count.get_int());
    }

    public TitanHexString rotate_right(int rotateCount) {
        this.must_bound("Unbound hexstring operand of rotate right operator.");
        if (this.nibbles_ptr.length == 0) {
            return new TitanHexString(this);
        }
        if (rotateCount >= 0) {
            if ((rotateCount %= this.nibbles_ptr.length) == 0) {
                return new TitanHexString(this);
            }
            return this.shift_right(rotateCount).or4b(this.shift_left(this.nibbles_ptr.length - rotateCount));
        }
        return this.rotate_left(-rotateCount);
    }

    public TitanHexString rotate_right(TitanInteger rotateCount) {
        rotateCount.must_bound("Unbound right operand of hexstring rotate right operator.");
        return this.rotate_right(rotateCount.get_int());
    }

    @Override
    public int RAW_encode(Base_Type.TTCN_Typedescriptor p_td, RAW.RAW_enc_tree myleaf) {
        int align_length;
        if (!this.is_bound()) {
            TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_UNBOUND, "Encoding an unbound value.", new Object[0]);
        }
        int nbits = this.nibbles_ptr.length * 4;
        int n = align_length = p_td.raw.fieldlength != 0 ? p_td.raw.fieldlength - nbits : 0;
        if (nbits + align_length < nbits) {
            TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_LEN_ERR, "There is no sufficient bits to encode '%s': ", p_td.name);
            nbits = p_td.raw.fieldlength;
            align_length = 0;
        }
        myleaf.data_array = new byte[(this.nibbles_ptr.length + 1) / 2];
        for (int i = 1; i < this.nibbles_ptr.length; i += 2) {
            myleaf.data_array[i / 2] = (byte)(this.nibbles_ptr[i] << 4 | this.nibbles_ptr[i - 1] & 0xF);
        }
        if ((this.nibbles_ptr.length & 1) == 1) {
            myleaf.data_array[this.nibbles_ptr.length / 2] = (byte)(this.nibbles_ptr[this.nibbles_ptr.length - 1] & 0xF);
        }
        myleaf.align = p_td.raw.endianness == TTCN_EncDec.raw_order_t.ORDER_MSB ? -align_length : align_length;
        myleaf.coding_par.csn1lh = p_td.raw.csn1lh;
        myleaf.length = nbits + align_length;
        return myleaf.length;
    }

    @Override
    public int RAW_decode(Base_Type.TTCN_Typedescriptor p_td, TTCN_Buffer buff, int limit, TTCN_EncDec.raw_order_t top_bit_ord) {
        return this.RAW_decode(p_td, buff, limit, top_bit_ord, false, -1, true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int RAW_decode(Base_Type.TTCN_Typedescriptor p_td, TTCN_Buffer buff, int limit, TTCN_EncDec.raw_order_t top_bit_ord, boolean no_err, int sel_field, boolean first_call, RAW.RAW_Force_Omit force_omit) {
        int prepaddlength = buff.increase_pos_padd(p_td.raw.prepadding);
        int decode_length = p_td.raw.fieldlength == 0 ? (limit -= prepaddlength) / 4 * 4 : p_td.raw.fieldlength;
        TTCN_EncDec_ErrorContext errorcontext = new TTCN_EncDec_ErrorContext();
        try {
            boolean orders;
            if (p_td.raw.fieldlength > limit || p_td.raw.fieldlength > buff.unread_len_bit()) {
                if (no_err) {
                    int n = -TTCN_EncDec.error_type.ET_LEN_ERR.ordinal();
                    return n;
                }
                TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_LEN_ERR, "There is not enough bits in the buffer to decode type %s.", p_td.name);
                decode_length = (limit > buff.unread_len_bit() ? buff.unread_len_bit() : limit) / 4 * 4;
            }
            RAW.RAW_coding_par cp = new RAW.RAW_coding_par();
            boolean bl = orders = p_td.raw.bitorderinoctet == TTCN_EncDec.raw_order_t.ORDER_MSB;
            if (p_td.raw.bitorderinfield == TTCN_EncDec.raw_order_t.ORDER_MSB) {
                orders = !orders;
            }
            cp.bitorder = orders ? TTCN_EncDec.raw_order_t.ORDER_MSB : TTCN_EncDec.raw_order_t.ORDER_LSB;
            boolean bl2 = orders = p_td.raw.byteorder == TTCN_EncDec.raw_order_t.ORDER_MSB;
            if (p_td.raw.bitorderinfield == TTCN_EncDec.raw_order_t.ORDER_MSB) {
                orders = !orders;
            }
            cp.byteorder = orders ? TTCN_EncDec.raw_order_t.ORDER_MSB : TTCN_EncDec.raw_order_t.ORDER_LSB;
            cp.fieldorder = p_td.raw.fieldorder;
            cp.hexorder = p_td.raw.hexorder;
            cp.csn1lh = p_td.raw.csn1lh;
            this.nibbles_ptr = new byte[decode_length / 4];
            byte[] tmp_nibbles = new byte[decode_length / 4];
            buff.get_b(decode_length, tmp_nibbles, cp, top_bit_ord);
            if (tmp_nibbles.length == 1) {
                this.nibbles_ptr[0] = tmp_nibbles[0];
            } else {
                int i = 0;
                int j = 0;
                while (i < this.nibbles_ptr.length) {
                    this.nibbles_ptr[i] = (byte)(tmp_nibbles[j] & 0xF);
                    if (i + 1 != this.nibbles_ptr.length) {
                        this.nibbles_ptr[i + 1] = (byte)((tmp_nibbles[j] & 0xFF) >> 4 & 0xF);
                    }
                    i += 2;
                    ++j;
                }
            }
            if (p_td.raw.length_restrition != -1 && decode_length > p_td.raw.length_restrition && p_td.raw.endianness == TTCN_EncDec.raw_order_t.ORDER_MSB) {
                if ((decode_length - this.nibbles_ptr.length * 4) % 8 != 0) {
                    int bound = (decode_length - this.nibbles_ptr.length * 4) % 8;
                    int maxindex = (decode_length - 1) / 8;
                    int a = 0;
                    int b = (decode_length - this.nibbles_ptr.length * 4 - 1) / 8;
                    while (a < (this.nibbles_ptr.length * 4 + 7) / 8) {
                        this.nibbles_ptr[a] = (byte)(this.nibbles_ptr[b] >> bound);
                        if (b < maxindex) {
                            this.nibbles_ptr[a] = (byte)(this.nibbles_ptr[b + 1] << 8 - bound);
                        }
                        ++a;
                        ++b;
                    }
                } else {
                    System.arraycopy(this.nibbles_ptr, (decode_length - this.nibbles_ptr.length * 4) / 8, this.nibbles_ptr, 0, this.nibbles_ptr.length * 8);
                }
            }
            this.clearUnusedNibble();
        }
        finally {
            errorcontext.leave_context();
        }
        return (decode_length += buff.increase_pos_padd(p_td.raw.padding)) + prepaddlength;
    }

    public static TitanHexString convert_to_HexString(TitanHexString otherValue) {
        return otherValue;
    }

    public static TitanHexString convert_to_HexString(TitanHexString_Element otherValue) {
        return new TitanHexString(otherValue);
    }
}

