/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.runtime.core;

import java.io.IOException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.titan.runtime.core.Changeable_Double;
import org.eclipse.titan.runtime.core.Event_Handler;
import org.eclipse.titan.runtime.core.TitanAlt_Status;
import org.eclipse.titan.runtime.core.TitanTimer;
import org.eclipse.titan.runtime.core.TtcnError;

public final class TTCN_Snapshot {
    private static final long MAX_BLOCK_TIME = Long.MAX_VALUE;
    public static ThreadLocal<Selector> selector = new ThreadLocal<Selector>(){

        @Override
        protected Selector initialValue() {
            return null;
        }
    };
    private static ThreadLocal<Boolean> else_branch_found = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    private static ThreadLocal<Double> alt_begin = new ThreadLocal<Double>(){

        @Override
        protected Double initialValue() {
            return TTCN_Snapshot.time_now();
        }
    };
    public static final ThreadLocal<HashMap<SelectableChannel, Event_Handler.Channel_Event_Handler>> channelMap = new ThreadLocal<HashMap<SelectableChannel, Event_Handler.Channel_Event_Handler>>(){

        @Override
        protected HashMap<SelectableChannel, Event_Handler.Channel_Event_Handler> initialValue() {
            return new HashMap<SelectableChannel, Event_Handler.Channel_Event_Handler>();
        }
    };
    private static ThreadLocal<ArrayList<Event_Handler.Channel_And_Timeout_Event_Handler>> timedList = new ThreadLocal<ArrayList<Event_Handler.Channel_And_Timeout_Event_Handler>>(){

        @Override
        protected ArrayList<Event_Handler.Channel_And_Timeout_Event_Handler> initialValue() {
            return new ArrayList<Event_Handler.Channel_And_Timeout_Event_Handler>();
        }
    };

    private TTCN_Snapshot() {
    }

    public static void initialize() {
        try {
            selector.set(Selector.open());
        }
        catch (IOException exception) {
            throw new TtcnError(exception);
        }
        else_branch_found.set(false);
        alt_begin.set(TTCN_Snapshot.time_now());
    }

    public static void re_open() {
        try {
            selector.set(Selector.open());
        }
        catch (IOException exception) {
            throw new TtcnError(exception);
        }
    }

    public static void terminate() {
    }

    public static void else_branch_reached() {
        if (!else_branch_found.get().booleanValue()) {
            else_branch_found.set(true);
            TtcnError.TtcnWarning("An [else] branch of an alt construct has been reached.Re-configuring the snapshot manager to call the event handlers even when taking the first snapshot.");
        }
    }

    public static double time_now() {
        return (double)System.currentTimeMillis() / 1000.0;
    }

    public static double get_alt_begin() {
        return alt_begin.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void take_new(boolean blockExecution) {
        block34: {
            if (blockExecution || else_branch_found.get().booleanValue()) {
                Selector localSelector;
                double timeout;
                double difference;
                long pollTimeout;
                do {
                    timeout = 0.0;
                    pollTimeout = 0L;
                    boolean handleTimer = false;
                    if (blockExecution) {
                        Changeable_Double timerTimeout = new Changeable_Double(0.0);
                        boolean isTimerTimeout = TitanTimer.get_min_expiration(timerTimeout);
                        if (isTimerTimeout) {
                            double currentTime;
                            timeout = timerTimeout.getValue();
                            double blockTime = timeout - (currentTime = TTCN_Snapshot.time_now());
                            if (blockTime > 0.0) {
                                if (blockTime < 9.223372036854776E18) {
                                    pollTimeout = (long)Math.floor(blockTime * 1000.0);
                                    handleTimer = true;
                                } else {
                                    TtcnError.TtcnWarning(MessageFormat.format("The time needed for the first timer expiry is {0} seconds. The operating system does not support such long waiting at once. The maximum time of blocking was set to {1} seconds (ca. {2} days).", blockTime, Long.MAX_VALUE, 106751991167300L));
                                    timeout = currentTime + 9.223372036854776E18;
                                    pollTimeout = -1000L;
                                    handleTimer = true;
                                }
                            } else {
                                handleTimer = true;
                            }
                        } else {
                            pollTimeout = -1L;
                        }
                    }
                    localSelector = selector.get();
                    int selectReturn = 0;
                    if (localSelector.keys().isEmpty()) {
                        if (pollTimeout > 0L) {
                            try {
                                selectReturn = localSelector.select(pollTimeout);
                            }
                            catch (IOException exception) {
                                throw new TtcnError("Interrupted while taking snapshot.");
                            }
                        } else if (pollTimeout < 0L) {
                            throw new TtcnError("There are no active timers and no installed event handlers. Execution would block forever.");
                        }
                    } else {
                        if (pollTimeout > 0L) {
                            try {
                                selectReturn = localSelector.select(pollTimeout);
                            }
                            catch (IOException exception) {
                                throw new TtcnError("Interrupted while taking snapshot.");
                            }
                        }
                        if (pollTimeout < 0L) {
                            try {
                                selectReturn = localSelector.select(0L);
                            }
                            catch (IOException exception) {
                                throw new TtcnError("Interrupted while taking snapshot.");
                            }
                        }
                        try {
                            selectReturn = localSelector.selectNow();
                        }
                        catch (IOException exception) {
                            throw new TtcnError("Interrupted while taking snapshot.");
                        }
                    }
                    if (selectReturn > 0) {
                        Set<SelectionKey> selectedKeys = localSelector.selectedKeys();
                        try {
                            HashMap<SelectableChannel, Event_Handler.Channel_Event_Handler> localChannelMap = channelMap.get();
                            for (SelectionKey key : selectedKeys) {
                                boolean isWritable;
                                SelectableChannel keyChannel = key.channel();
                                Event_Handler.Channel_Event_Handler handler = localChannelMap.get(keyChannel);
                                int readyOps = key.readyOps();
                                boolean isReadable = key.isValid() && (readyOps & 0x11) != 0;
                                boolean bl = isWritable = key.isValid() && (readyOps & 4) != 0;
                                if (handler == null) continue;
                                handler.Handle_Event(keyChannel, isReadable, isWritable);
                            }
                            break block34;
                        }
                        finally {
                            selectedKeys.clear();
                        }
                    }
                    if (selectReturn != 0 || !handleTimer) break block34;
                } while (pollTimeout > 0L && (difference = TTCN_Snapshot.time_now() - timeout) < 0.0);
                Set<SelectionKey> selectedKeys = localSelector.selectedKeys();
                try {
                    HashMap<SelectableChannel, Event_Handler.Channel_Event_Handler> localChannelMap = channelMap.get();
                    for (SelectionKey key : selectedKeys) {
                        boolean isWritable;
                        SelectableChannel keyChannel = key.channel();
                        Event_Handler.Channel_Event_Handler handler = localChannelMap.get(keyChannel);
                        int readyOps = key.readyOps();
                        boolean isReadable = key.isValid() && (readyOps & 0x11) != 0;
                        boolean bl = isWritable = key.isValid() && (readyOps & 4) != 0;
                        if (handler == null) continue;
                        handler.Handle_Event(keyChannel, isReadable, isWritable);
                    }
                }
                finally {
                    selectedKeys.clear();
                }
            }
        }
        alt_begin.set(TTCN_Snapshot.time_now());
        if (TitanAlt_Status.ALT_YES == TitanTimer.testcaseTimer.timeout()) {
            throw new TtcnError("Guard timer has expired. Execution of current test case will be interrupted.");
        }
    }

    public static void set_timer(Event_Handler.Channel_And_Timeout_Event_Handler handler, double call_interval, boolean is_timeout, boolean call_anyway, boolean is_periodic) {
        if (call_interval == 0.0) {
            if (handler.list == timedList.get()) {
                timedList.get().remove(handler);
                handler.list = null;
            }
            handler.callIntervall = 0.0;
        } else {
            if (handler.list == null) {
                timedList.get().add(handler);
                handler.list = timedList.get();
            }
            handler.callIntervall = call_interval;
            handler.last_called = TTCN_Snapshot.time_now();
            handler.isTimeout = is_timeout;
            handler.callAnyway = call_anyway;
            handler.isPeriodic = is_periodic;
        }
    }
}

