/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.runtime.core;

import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.titan.runtime.core.Default_Base;
import org.eclipse.titan.runtime.core.TTCN_Logger;
import org.eclipse.titan.runtime.core.TitanAlt_Status;
import org.eclipse.titan.runtime.core.TitanDefault;
import org.eclipse.titan.runtime.core.TitanLoggerApi;
import org.eclipse.titan.runtime.core.TtcnError;

public final class TTCN_Default {
    private static int defaultCount = 0;
    private static int backupCount = 0;
    private static final ThreadLocal<LinkedList<Default_Base>> DEFAULTS = new ThreadLocal<LinkedList<Default_Base>>(){

        @Override
        protected LinkedList<Default_Base> initialValue() {
            return new LinkedList<Default_Base>();
        }
    };
    private static final ThreadLocal<LinkedList<Default_Base>> BACKUP_DEFAULTS = new ThreadLocal<LinkedList<Default_Base>>(){

        @Override
        protected LinkedList<Default_Base> initialValue() {
            return new LinkedList<Default_Base>();
        }
    };
    private static ThreadLocal<Boolean> controlDefaultsSaved = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };

    private TTCN_Default() {
    }

    public static int activate(Default_Base newDefault) {
        DEFAULTS.get().addLast(newDefault);
        return defaultCount++;
    }

    public static void deactivate(Default_Base removableDefault) {
        LinkedList<Default_Base> localDefaults = DEFAULTS.get();
        if (localDefaults.contains(removableDefault)) {
            localDefaults.remove(removableDefault);
            return;
        }
        TtcnError.TtcnWarning("Performing a deactivate operation on an inactive default reference.");
    }

    public static void deactivate(TitanDefault removableDefault) {
        removableDefault.must_bound("Performing a deactivate operation on an unbound default reference.");
        if (removableDefault.default_ptr == null) {
            TTCN_Logger.log_defaultop_deactivate(null, 0);
        } else {
            TTCN_Default.deactivate(removableDefault.default_ptr);
        }
    }

    public static void deactivate_all() {
        DEFAULTS.get().clear();
    }

    public static TitanAlt_Status try_altsteps() {
        TitanAlt_Status returnValue = TitanAlt_Status.ALT_NO;
        LinkedList<Default_Base> localDefaults = DEFAULTS.get();
        block6: for (int i = localDefaults.size() - 1; i >= 0; --i) {
            Default_Base actualDefault = localDefaults.get(i);
            switch (actualDefault.call_altstep()) {
                case ALT_YES: {
                    TTCN_Logger.log_defaultop_exit(actualDefault.get_alstep_name(), actualDefault.get_default_id(), TitanLoggerApi.DefaultEnd.enum_type.finish.ordinal());
                    return TitanAlt_Status.ALT_YES;
                }
                case ALT_REPEAT: {
                    TTCN_Logger.log_defaultop_exit(actualDefault.get_alstep_name(), actualDefault.get_default_id(), TitanLoggerApi.DefaultEnd.enum_type.repeat__.ordinal());
                    return TitanAlt_Status.ALT_REPEAT;
                }
                case ALT_BREAK: {
                    TTCN_Logger.log_defaultop_exit(actualDefault.get_alstep_name(), actualDefault.get_default_id(), TitanLoggerApi.DefaultEnd.enum_type.break__.ordinal());
                    return TitanAlt_Status.ALT_BREAK;
                }
                case ALT_MAYBE: {
                    returnValue = TitanAlt_Status.ALT_MAYBE;
                    continue block6;
                }
            }
        }
        return returnValue;
    }

    public static void log(Default_Base par_default) {
        if (par_default == TitanDefault.UNBOUND_DEFAULT) {
            TTCN_Logger.log_event_unbound();
        } else if (par_default == null) {
            TTCN_Logger.log_event_str("null");
        } else {
            LinkedList<Default_Base> localDefaults = DEFAULTS.get();
            for (int i = 0; i < localDefaults.size(); ++i) {
                Default_Base actualDefault = localDefaults.get(i);
                if (actualDefault != par_default) continue;
                actualDefault.log();
                return;
            }
            TTCN_Logger.log_event_str("default reference: already deactivated");
        }
    }

    public static void save_control_defaults() {
        if (controlDefaultsSaved.get().booleanValue()) {
            throw new TtcnError("Internal error: Control part defaults are already saved.");
        }
        BACKUP_DEFAULTS.get().addAll((Collection<Default_Base>)DEFAULTS.get());
        DEFAULTS.get().clear();
        backupCount = defaultCount;
        defaultCount = 0;
        controlDefaultsSaved.set(true);
    }

    public static void restore_control_defaults() {
        if (!controlDefaultsSaved.get().booleanValue()) {
            throw new TtcnError("Internal error: Control part defaults are not saved.");
        }
        if (!DEFAULTS.get().isEmpty()) {
            throw new TtcnError("Internal Error: There are defaults. Control part defaults can not be restored.");
        }
        DEFAULTS.get().addAll((Collection<Default_Base>)BACKUP_DEFAULTS.get());
        BACKUP_DEFAULTS.get().clear();
        defaultCount = backupCount;
        backupCount = 0;
        controlDefaultsSaved.set(false);
    }

    public static void reset_counter() {
        if (controlDefaultsSaved.get().booleanValue()) {
            throw new TtcnError("Internal error: Default counter cannot be reset when the control part defaults are saved.");
        }
        if (!DEFAULTS.get().isEmpty()) {
            throw new TtcnError("Internal error: Default counter cannot be reset when there are active defaults.");
        }
        defaultCount = 0;
    }
}

