/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.statements;

import java.text.MessageFormat;
import org.eclipse.titan.designer.AST.ASTNode;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.NULL_Location;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Var;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Var_Template;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameter;
import org.eclipse.titan.designer.AST.TTCN3.statements.Variable_Entries;
import org.eclipse.titan.designer.AST.TTCN3.statements.Variable_Entry;
import org.eclipse.titan.designer.AST.TTCN3.templates.DecodeMatch_template;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.NamedTemplate;
import org.eclipse.titan.designer.AST.TTCN3.templates.Named_Template_List;
import org.eclipse.titan.designer.AST.TTCN3.templates.TTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.TemplateInstance;
import org.eclipse.titan.designer.AST.TTCN3.types.SignatureFormalParameter;
import org.eclipse.titan.designer.AST.TTCN3.types.SignatureFormalParameterList;
import org.eclipse.titan.designer.AST.TTCN3.types.Signature_Type;
import org.eclipse.titan.designer.AST.TTCN3.values.Charstring_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public abstract class Parameter_Redirection
extends ASTNode
implements ILocateableNode,
IIncrementallyUpdateable {
    protected static final String SIGNATUREWITHOUTPARAMETERS = "Parameter redirect cannot be used because signature `{0}'' does not have parameters";
    private Location location = NULL_Location.INSTANCE;
    protected CompilationTimeStamp lastTimeChecked;

    @Override
    public final void setLocation(Location location) {
        this.location = location;
    }

    @Override
    public final Location getLocation() {
        return this.location;
    }

    public abstract void setCodeSection(GovernedSimple.CodeSectionType var1);

    public abstract boolean hasDecodedModifier();

    public abstract void checkErroneous(CompilationTimeStamp var1);

    public final void checkVariableReference(CompilationTimeStamp timestamp, Reference reference, IType type) {
        if (reference == null) {
            return;
        }
        IType variableType = reference.checkVariableReference(timestamp);
        if (type != null && variableType != null && !type.isIdentical(timestamp, variableType)) {
            String message = MessageFormat.format("Type mismatch in parameter redirect: A variable of type `{0}'' was expected instead of `{1}''", type.getTypename(), variableType.getTypename());
            reference.getLocation().reportSemanticError(message);
            return;
        }
        Assignment assignment = reference.getRefdAssignment(timestamp, true);
        if (assignment != null) {
            switch (assignment.getAssignmentType()) {
                case A_PAR_VAL: 
                case A_PAR_VAL_OUT: 
                case A_PAR_VAL_INOUT: {
                    ((FormalParameter)assignment).setWritten();
                    break;
                }
                case A_VAR: {
                    ((Def_Var)assignment).setWritten();
                    break;
                }
                case A_PAR_TEMP_OUT: 
                case A_PAR_TEMP_INOUT: {
                    ((FormalParameter)assignment).setWritten();
                    break;
                }
                case A_VAR_TEMPLATE: {
                    ((Def_Var_Template)assignment).setWritten();
                    break;
                }
            }
        }
    }

    public abstract void check(CompilationTimeStamp var1, Signature_Type var2, boolean var3);

    public abstract void generateCode(JavaGenData var1, ExpressionStruct var2, TemplateInstance var3, String var4, boolean var5);

    protected void internalGenerateCode(JavaGenData aData, ExpressionStruct expression, Variable_Entries entries, TemplateInstance matched_ti, String lastGenTIExpression, boolean is_out) {
        if (this.hasDecodedModifier()) {
            expression.expression.append(MessageFormat.format("{0}, ", lastGenTIExpression));
        }
        for (int i = 0; i < entries.getNofEntries(); ++i) {
            Reference ref;
            if (i > 0) {
                expression.expression.append(", ");
            }
            Variable_Entry entry = entries.getEntryByIndex(i);
            Value stringEncoding = null;
            if (entry.isDecoded() && entry.getStringEncoding() != null && entry.getStringEncoding().isUnfoldable(CompilationTimeStamp.getBaseTimestamp())) {
                stringEncoding = entry.getStringEncoding();
            }
            if ((ref = entry.getReference()) == null) {
                expression.expression.append("null");
                if (stringEncoding == null) continue;
                expression.expression.append(", TitanCharString()");
                continue;
            }
            ref.generateCode(aData, expression);
            if (stringEncoding == null) continue;
            expression.expression.append(", ");
            stringEncoding.generateCodeExpression(aData, expression, true);
        }
    }

    public abstract void generateCodeDecoded(JavaGenData var1, StringBuilder var2, TemplateInstance var3, String var4, boolean var5);

    public void internalGenerateCodeDecoded(JavaGenData aData, StringBuilder source, Variable_Entries entries, TemplateInstance matched_ti, String tempID, boolean is_out) {
        Scope scope = this.getMyScope();
        StringBuilder membersString = new StringBuilder();
        StringBuilder constructorParameters = new StringBuilder();
        StringBuilder baseConstructorParameters = new StringBuilder();
        StringBuilder constructorInitList = new StringBuilder();
        StringBuilder setParametersString = new StringBuilder();
        IType sigType = matched_ti.getTemplateBody().getMyGovernor().getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
        Type returnType = ((Signature_Type)sigType).getSignatureReturnType();
        if (returnType != null && is_out) {
            constructorParameters.append("Value_Redirect_Interface return_redirect, ");
            baseConstructorParameters.append("return_redirect");
        }
        String sigTypeGenTempName = sigType.getGenNameTemplate(aData, source);
        membersString.append(MessageFormat.format("{0} ptr_matched_temp;\n", sigTypeGenTempName));
        constructorParameters.append(MessageFormat.format("{0} par_matched_temp", sigTypeGenTempName));
        constructorInitList.append("ptr_matched_temp = par_matched_temp;\n");
        SignatureFormalParameterList parList = ((Signature_Type)sigType).getParameterList();
        for (int i = 0; i < entries.getNofEntries(); ++i) {
            Variable_Entry variableEntry = entries.getEntryByIndex(i);
            SignatureFormalParameter parameter = is_out ? parList.getOutParameterByIndex(i) : parList.getInParameterByIndex(i);
            String parameterName = parameter.getIdentifier().getName();
            if (constructorParameters.length() > 0) {
                constructorParameters.append(", ");
            }
            if (baseConstructorParameters.length() > 0) {
                baseConstructorParameters.append(", ");
            }
            if (variableEntry.isDecoded()) {
                IType declarationType = variableEntry.getDeclarationType();
                String veGenName = declarationType.getGenNameValue(aData, source);
                membersString.append(MessageFormat.format("private {0} ptr_{1}_dec;\n", veGenName, parameterName));
                constructorParameters.append(MessageFormat.format("{0} par_{1}_dec", veGenName, parameterName));
                baseConstructorParameters.append("null");
                setParametersString.append(MessageFormat.format("if (ptr_{0}_dec != null) '{'\n", parameterName));
                TTCN3Template lastMatchedTemplate = matched_ti.getTemplateBody().getTemplateReferencedLast(CompilationTimeStamp.getBaseTimestamp());
                NamedTemplate matchedNamedTemplate = null;
                if (lastMatchedTemplate.getTemplatetype() == ITTCN3Template.Template_type.NAMED_TEMPLATE_LIST) {
                    matchedNamedTemplate = ((Named_Template_List)lastMatchedTemplate).getNamedTemplate(parameter.getIdentifier());
                }
                ITTCN3Template matchedTemplate = null;
                if (matchedNamedTemplate != null) {
                    matchedTemplate = matchedNamedTemplate.getTemplate().getTemplateReferencedLast(CompilationTimeStamp.getBaseTimestamp());
                }
                boolean useDecmatchResult = matchedTemplate != null && matchedTemplate.getTemplatetype() == ITTCN3Template.Template_type.DECODE_MATCH;
                boolean needsDecode = true;
                ExpressionStruct redirCodingExpression = new ExpressionStruct();
                IType paramLastType = parameter.getType().getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
                if (paramLastType.getTypetypeTtcn3() == IType.Type_type.TYPE_UCHARSTRING) {
                    aData.addBuiltinTypeImport("TitanCharString.CharCoding");
                    IValue temp = variableEntry.getStringEncoding();
                    if (temp != null) {
                        temp = temp.getValueRefdLast(CompilationTimeStamp.getBaseTimestamp(), null);
                    }
                    if (temp == null || !temp.isUnfoldable(CompilationTimeStamp.getBaseTimestamp())) {
                        Charstring_Value stringEncoding = (Charstring_Value)temp;
                        String redirCodingString = stringEncoding == null || "UTF-8".equals(stringEncoding.getValue()) ? "UTF_8" : ("UTF-16".equals(stringEncoding.getValue()) || "UTF-16BE".equals(stringEncoding.getValue()) ? "UTF16BE" : ("UTF-16LE".equals(stringEncoding.getValue()) ? "UTF16LE" : ("UTF-32LE".equals(stringEncoding.getValue()) ? "UTF32LE" : "UTF32BE")));
                        redirCodingExpression.expression.append(MessageFormat.format("CharCoding.{0}", redirCodingString));
                    } else {
                        redirCodingExpression.preamble.append(MessageFormat.format("CharCoding coding = TitanUniversalCharString.get_character_coding(enc_fmt_{0}.get_value().toString(), \"decoded parameter redirect\");\n", parameterName));
                        redirCodingExpression.expression.append("coding");
                    }
                }
                if (useDecmatchResult) {
                    needsDecode = false;
                    TemplateInstance decodeTarget = ((DecodeMatch_template)matchedTemplate).getDecodeTarget();
                    IType targetGovernor = decodeTarget.getExpressionGovernor(CompilationTimeStamp.getBaseTimestamp(), Expected_Value_type.EXPECTED_TEMPLATE);
                    IType decmatchType = targetGovernor.getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
                    if (declarationType != decmatchType) {
                        needsDecode = true;
                        useDecmatchResult = false;
                    } else if (paramLastType.getTypetypeTtcn3() == IType.Type_type.TYPE_UCHARSTRING) {
                        IValue temp;
                        boolean differentUstrEncoding = false;
                        boolean unkonwnUstrEncodings = false;
                        if (variableEntry.getStringEncoding() == null) {
                            if (((DecodeMatch_template)matchedTemplate).getStringEncoding() != null) {
                                temp = ((DecodeMatch_template)matchedTemplate).getStringEncoding();
                                if (temp.isUnfoldable(CompilationTimeStamp.getBaseTimestamp())) {
                                    unkonwnUstrEncodings = true;
                                } else {
                                    Charstring_Value stringEncoding = (Charstring_Value)temp.getValueRefdLast(CompilationTimeStamp.getBaseTimestamp(), null);
                                    if (!"UTF-8".equals(stringEncoding.getValue())) {
                                        differentUstrEncoding = true;
                                    }
                                }
                            }
                        } else if (variableEntry.getStringEncoding().isUnfoldable(CompilationTimeStamp.getBaseTimestamp())) {
                            unkonwnUstrEncodings = true;
                        } else if (((DecodeMatch_template)matchedTemplate).getStringEncoding() == null) {
                            temp = variableEntry.getStringEncoding().getValueRefdLast(CompilationTimeStamp.getBaseTimestamp(), null);
                            if ("UTF-8".equals(((Charstring_Value)temp).getValue())) {
                                differentUstrEncoding = true;
                            }
                        } else if (((DecodeMatch_template)matchedTemplate).getStringEncoding().isUnfoldable(CompilationTimeStamp.getBaseTimestamp())) {
                            unkonwnUstrEncodings = true;
                        } else {
                            IValue redirectionTemp = variableEntry.getStringEncoding().getValueRefdLast(CompilationTimeStamp.getBaseTimestamp(), null);
                            Value templateTemp = ((DecodeMatch_template)matchedTemplate).getStringEncoding();
                            Charstring_Value tempStringEncoding = (Charstring_Value)templateTemp.getValueRefdLast(CompilationTimeStamp.getBaseTimestamp(), null);
                            if (!((Charstring_Value)redirectionTemp).getValue().equals(tempStringEncoding.getValue())) {
                                differentUstrEncoding = true;
                            }
                        }
                        if (unkonwnUstrEncodings) {
                            needsDecode = true;
                            setParametersString.append(MessageFormat.format("{0}if ( {1} == ptr_matched_temp.constGet_field_{2}().get_decmatch_str_enc()) '{'\n", redirCodingExpression.preamble, redirCodingExpression.expression, parameterName));
                        } else if (differentUstrEncoding) {
                            needsDecode = true;
                            useDecmatchResult = false;
                        }
                    }
                } else {
                    boolean unfoldable;
                    boolean bl = unfoldable = matchedTemplate == null;
                    if (!unfoldable) {
                        switch (matchedTemplate.getTemplatetype()) {
                            case ANY_VALUE: 
                            case ANY_OR_OMIT: 
                            case BSTR_PATTERN: 
                            case CSTR_PATTERN: 
                            case HSTR_PATTERN: 
                            case OSTR_PATTERN: 
                            case USTR_PATTERN: 
                            case COMPLEMENTED_LIST: 
                            case VALUE_LIST: 
                            case VALUE_RANGE: {
                                break;
                            }
                            default: {
                                unfoldable = true;
                            }
                        }
                    }
                    if (unfoldable) {
                        useDecmatchResult = true;
                        if (redirCodingExpression.preamble.length() > 0) {
                            setParametersString.append((CharSequence)redirCodingExpression.preamble);
                        }
                        String typeDescriptorName = declarationType.getGenNameTypeDescriptor(aData, setParametersString);
                        setParametersString.append(MessageFormat.format("if (ptr_matched_temp.constGet_field_{0}().get_selection() == template_sel.DECODE_MATCH && {1}_descr_ == ptr_matched_temp.constGet_field_{0}().get_decmatch_type_descr()", parameterName, typeDescriptorName));
                        if (redirCodingExpression.expression.length() > 0) {
                            setParametersString.append(MessageFormat.format("&& {0} == ptr_matched_temp.constGet_field_{1}().get_decmatch_str_enc()", redirCodingExpression.expression, parameterName));
                        }
                        setParametersString.append(") {\n");
                    }
                }
                if (useDecmatchResult) {
                    setParametersString.append(MessageFormat.format("ptr_{0}_dec.operator_assign(({1})ptr_matched_temp.constGet_field_{2}().get_decmatch_dec_res());\n", parameterName, declarationType.getGenNameValue(aData, setParametersString), parameterName));
                }
                if (needsDecode) {
                    if (useDecmatchResult) {
                        setParametersString.append("} else {\n");
                    }
                    aData.addBuiltinTypeImport("TitanOctetString");
                    aData.addBuiltinTypeImport("AdditionalFunctions");
                    setParametersString.append("TitanOctetString buff = new TitanOctetString(");
                    IType.Type_type tt = paramLastType.getTypetypeTtcn3();
                    switch (tt) {
                        case TYPE_BITSTRING: {
                            setParametersString.append(MessageFormat.format("AdditionalFunctions.bit2oct(par.constGet_field_{0}())", parameterName));
                            break;
                        }
                        case TYPE_HEXSTRING: {
                            setParametersString.append(MessageFormat.format("AdditionalFunctions.hex2oct(par.constGet_field_{0}())", parameterName));
                            break;
                        }
                        case TYPE_OCTETSTRING: {
                            setParametersString.append(MessageFormat.format("par.{0}()", parameterName));
                            break;
                        }
                        case TYPE_CHARSTRING: {
                            setParametersString.append(MessageFormat.format("AdditionalFunctions.char2oct(par.constGet_field_{0}())", parameterName));
                            break;
                        }
                        case TYPE_UCHARSTRING: {
                            setParametersString.append(MessageFormat.format("AdditionalFunctions.unichar2oct(par.constGet_field_{0}(), ", parameterName));
                            if (variableEntry.getStringEncoding() == null) {
                                setParametersString.append("\"UTF-8\"");
                            } else if (!variableEntry.getStringEncoding().isUnfoldable(CompilationTimeStamp.getBaseTimestamp())) {
                                IValue temp = variableEntry.getStringEncoding();
                                temp = temp.getValueRefdLast(CompilationTimeStamp.getBaseTimestamp(), null);
                                setParametersString.append(MessageFormat.format("\"{0}\"", ((Charstring_Value)temp).getValue()));
                            } else {
                                membersString.append(MessageFormat.format("TitanCharString enc_fmt_{0};\n", parameterName));
                                constructorParameters.append(MessageFormat.format(", TitanCharString par_fmt_{0}", parameterName));
                                constructorInitList.append(MessageFormat.format("enc_fmt_{0} = par_fmt_{0};\n", parameterName));
                                setParametersString.append(MessageFormat.format("enc_fmt_{0}", parameterName));
                            }
                            setParametersString.append(')');
                            break;
                        }
                    }
                    setParametersString.append(");\n");
                    String coderName = variableEntry.getDeclarationType().getGenNameCoder(aData, setParametersString, scope);
                    String codingName = declarationType.getGenNameDefaultCoding(aData, setParametersString, scope);
                    setParametersString.append(MessageFormat.format("if ({0}_decoder(buff, ptr_{1}_dec, {2}_default_coding) != 0) '{'\n", coderName, parameterName, codingName));
                    setParametersString.append(MessageFormat.format("throw new TtcnError(\"Decoding failed in parameter (for parameter `{0}'').\");\n", parameterName));
                    setParametersString.append("}\n");
                    setParametersString.append("if (buff.lengthof().operator_not_equals(0)) {\n");
                    setParametersString.append(MessageFormat.format("throw new TtcnError(MessageFormat.format(\"Parameter redirect (for parameter `{0}'' failed, because the buffer was not empty after decoding. Remaining octets: '{'0'}'\", buff.lengthof().get_int()));\n", parameterName));
                    setParametersString.append("}\n");
                    if (useDecmatchResult) {
                        setParametersString.append("}\n");
                    }
                }
                setParametersString.append("}\n");
                continue;
            }
            constructorParameters.append(MessageFormat.format("{0} par_{1}", parameter.getType().getGenNameValue(aData, source), parameterName));
            baseConstructorParameters.append(MessageFormat.format("par_{0}", parameterName));
        }
        String qualifiedSignatureName = sigType.getGenNameOwn(aData);
        String unqualifiedSignatureName = sigType.getGenNameOwn();
        String opName = is_out ? "reply" : "call";
        source.append(MessageFormat.format("class {0}_{1}_redirect_{2} extends {3}_{1}_redirect '{'\n", unqualifiedSignatureName, opName, tempID, qualifiedSignatureName));
        source.append((CharSequence)membersString);
        source.append(MessageFormat.format("public {0}_{1}_redirect_{2}({3}) '{'\n", unqualifiedSignatureName, opName, tempID, constructorParameters));
        source.append(MessageFormat.format("super({0});\n", baseConstructorParameters));
        source.append((CharSequence)constructorInitList);
        source.append("}\n");
        source.append(MessageFormat.format("public void set_parameters({0}_{1} par) '{'\n", qualifiedSignatureName, opName));
        source.append((CharSequence)setParametersString);
        source.append("super.set_parameters(par);\n");
        source.append("}\n");
        source.append("};\n");
    }
}

