/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.definitions;

import java.text.MessageFormat;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.DocumentComment;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.TTCN3.TemplateRestriction;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_FunctionBase;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameter;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameterList;
import org.eclipse.titan.designer.AST.TTCN3.statements.StatementBlock;
import org.eclipse.titan.designer.AST.TTCN3.types.Class_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.SignatureExceptions;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.editors.controls.HoverContentType;
import org.eclipse.titan.designer.editors.controls.Ttcn3HoverContent;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;
import org.eclipse.ui.IEditorPart;

public class Def_AbsFunction
extends Def_FunctionBase {
    private static final String CONCRETEABSTRACT = "Concrete class type `{0}'' cannot have abstract methods";
    private static final String KIND = "abstract function";
    private final SignatureExceptions exceptions;

    public Def_AbsFunction(Identifier identifier, FormalParameterList formalParameterList, Reference runsOnRef, Reference mtcReference, Reference systemReference, Reference portReference, Type returnType, boolean returnsTemplate, TemplateRestriction.Restriction_type templateRestriction, SignatureExceptions exceptions, StatementBlock block, StatementBlock finallyBlock, boolean isClassFunction, boolean isAbstract, boolean isFinal, Location classModifierLocation, boolean isDeterministic, boolean isControl, Location funcModifierLocation) {
        super(identifier, block, isAbstract, isFinal, isDeterministic, isControl, formalParameterList, returnType);
        this.exceptions = exceptions;
        this.assignmentType = returnType == null ? Assignment.Assignment_type.A_FUNCTION : (returnsTemplate ? Assignment.Assignment_type.A_FUNCTION_RTEMP : Assignment.Assignment_type.A_FUNCTION_RVAL);
    }

    @Override
    public String getProposalKind() {
        return KIND;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
    }

    @Override
    public String getAssignmentName() {
        return KIND;
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        this.check(timestamp, null);
    }

    @Override
    public void check(CompilationTimeStamp timestamp, IReferenceChain refChain) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
        this.removeSyntaxDecoration();
        Class_Type myClass = this.myScope.getScopeClass();
        if (myClass == null) {
            // empty if block
        }
        if (!myClass.isAbstract() && !myClass.isTrait()) {
            this.getSignatureLocation().reportSemanticError(MessageFormat.format(CONCRETEABSTRACT, myClass.getDefiningAssignment().getType(timestamp).getTypename()));
        }
        this.formalParameterList.check(timestamp, this.assignmentType);
        if (this.returnType != null) {
            this.returnType.check(timestamp);
            this.returnType.checkAsReturnType(timestamp, this.assignmentType == Assignment.Assignment_type.A_FUNCTION_RVAL, "n abstract function");
        }
        if (this.exceptions != null) {
            // empty if block
        }
        this.checkDocumentComment();
    }

    @Override
    public void generateCode(JavaGenData aData, boolean cleanUp) {
    }

    @Override
    public Ttcn3HoverContent getHoverContent(IEditorPart editor) {
        super.getHoverContent(editor);
        DocumentComment dc = null;
        if (this.hasDocumentComment() && (dc = this.parseDocumentComment()).isDeprecated()) {
            this.hoverContent.addDeprecated();
        }
        this.hoverContent.addIcon(this.getOutlineIcon()).addText(KIND).addStyledText(this.isDeterministic ? " @deterministic" : "", 2).addStyledText(this.isControl ? " @control " : " ", 2).addStyledText(this.getFullName(), 1).addText("(");
        for (int i = 0; i < this.formalParameterList.getNofParameters(); ++i) {
            FormalParameter fp = this.formalParameterList.getParameterByIndex(i);
            if (i > 0) {
                this.hoverContent.addText(", ");
            }
            this.hoverContent.addText(fp.getFormalParamType()).addText(" ").addText(fp.getType(this.lastTimeChecked).getTypename()).addText(" ").addText(fp.getIdentifier().getDisplayName());
        }
        this.hoverContent.addText(")");
        this.hoverContent.closeHeader();
        this.getHoverContentFromComment(this.hoverContent, dc, this.formalParameterList);
        this.hoverContent.addContent(HoverContentType.INFO);
        return this.hoverContent;
    }

    @Override
    public String generateDocComment(String indentation) {
        return this.generateCommonDocComment(indentation, this.formalParameterList, this.returnType);
    }

    @Override
    public FormalParameterList.IsIdenticalResult isIdentical(CompilationTimeStamp timestamp, Def_FunctionBase other) {
        return null;
    }
}

