/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.refactoring.runsonscopereduction;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Function;
import org.eclipse.titan.designer.AST.TTCN3.types.ComponentTypeBody;
import org.eclipse.titan.designer.AST.TTCN3.types.Component_Type;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

class ReferenceCheck
extends ASTVisitor {
    private final Set<Identifier> setOfIdentifier = new HashSet<Identifier>();

    public ReferenceCheck() {
        this.setOfIdentifier.clear();
    }

    public Set<Identifier> getIdentifiers() {
        return this.setOfIdentifier;
    }

    public int visit(IVisitableNode node) {
        if (node instanceof Reference) {
            Assignment assignment;
            CompilationTimeStamp timestamp = CompilationTimeStamp.getBaseTimestamp();
            if (((Reference)node).getIsErroneous(timestamp)) {
                return 3;
            }
            Reference reference = (Reference)node;
            if (reference != null && (assignment = reference.getRefdAssignment(timestamp, false)) != null) {
                if (assignment instanceof Def_Function) {
                    Component_Type componentType = ((Def_Function)assignment).getRunsOnType(timestamp);
                    if (componentType == null) {
                        return 3;
                    }
                    Identifier sc = componentType.getComponentBody().getIdentifier();
                    this.setOfIdentifier.add(sc);
                }
                if (assignment.getMyScope() instanceof ComponentTypeBody) {
                    Identifier sc = ((ComponentTypeBody)assignment.getMyScope()).getIdentifier();
                    this.setOfIdentifier.add(sc);
                }
            }
        }
        return 3;
    }
}

