/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.tools.api.editing;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.sirius.common.tools.api.editing.EditingDomainFactoryDescriptor;

public final class EditingDomainFactoryRegistry {
    private static final List<EditingDomainFactoryDescriptor> EXTENSIONS = new ArrayList<EditingDomainFactoryDescriptor>();
    private static final Map<String, EditingDomainFactoryDescriptor> ID_TO_DESCRITPOR_MAP = new HashMap<String, EditingDomainFactoryDescriptor>();

    private EditingDomainFactoryRegistry() {
    }

    public static void addExtension(EditingDomainFactoryDescriptor extension) {
        EXTENSIONS.add(extension);
        ID_TO_DESCRITPOR_MAP.put(extension.getId(), extension);
    }

    public static void clearRegistry() {
        EXTENSIONS.clear();
        ID_TO_DESCRITPOR_MAP.clear();
    }

    public static List<EditingDomainFactoryDescriptor> getRegisteredExtensions() {
        return new ArrayList<EditingDomainFactoryDescriptor>(EXTENSIONS);
    }

    public static void removeExtension(String id) {
        for (EditingDomainFactoryDescriptor extension : EditingDomainFactoryRegistry.getRegisteredExtensions()) {
            if (!extension.getId().equals(id)) continue;
            EXTENSIONS.remove(extension);
            ID_TO_DESCRITPOR_MAP.remove(extension.getId());
        }
    }

    public static EditingDomainFactoryDescriptor getDescriptorFromId(String id) {
        return ID_TO_DESCRITPOR_MAP.get(id);
    }
}

