/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amalgam.explorer.activity.ui.api.editor.pages.helper;

import java.util.List;
import org.eclipse.amalgam.explorer.activity.ui.internal.Couple;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class FormHelper {
    public static Composite createCompositeWithLayoutType(FormToolkit toolkit_p, Composite parent_p, LayoutType layoutType_p, int numColumns_p, boolean equalWidth_p) {
        Composite result = toolkit_p.createComposite(parent_p);
        FormHelper.updateCompositeLayoutWithLayoutType(result, layoutType_p, numColumns_p, equalWidth_p);
        return result;
    }

    public static Couple<Label, Text> createLabelAndText(FormToolkit toolkit_p, Composite parent_p, String labelMessage_p, String initialText_p, boolean editable_p) {
        Label label = toolkit_p.createLabel(parent_p, labelMessage_p, 64);
        label.setForeground(toolkit_p.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        Text text = new Text(parent_p, 2048);
        text.setLayoutData((Object)new GridData(768));
        if (initialText_p != null) {
            text.setText(initialText_p);
        }
        text.setEditable(editable_p);
        return new Couple<Label, Text>(label, text);
    }

    public static Couple<Text, Button> createLabelTextAndButton(FormToolkit toolkit_p, Composite parent_p, String labelMessage_p, String buttonLabel_p, SelectionListener listener_p) {
        Couple<Label, Text> labelAndText = FormHelper.createLabelAndText(toolkit_p, parent_p, labelMessage_p, null, true);
        Button button = toolkit_p.createButton(parent_p, buttonLabel_p, 8);
        if (listener_p != null) {
            button.addSelectionListener(listener_p);
        }
        return new Couple<Text, Button>(labelAndText.getValue(), button);
    }

    public static ImageHyperlink createLinkWithDescription(FormToolkit toolkit_p, Composite parent_p, Image icon_p, String linkText_p, Object linkRef_p, String linkDescription_p, IHyperlinkListener listener_p) {
        ImageHyperlink specificationLink = toolkit_p.createImageHyperlink(parent_p, 64);
        specificationLink.setText(linkText_p);
        if (linkDescription_p != null) {
            specificationLink.setToolTipText(linkDescription_p);
        }
        if (icon_p != null) {
            specificationLink.setImage(icon_p);
        }
        if (linkRef_p != null) {
            specificationLink.setHref(linkRef_p);
        }
        if (listener_p != null) {
            specificationLink.addHyperlinkListener(listener_p);
        }
        return specificationLink;
    }

    public static FormText createRichText(FormToolkit toolkit_p, Composite parent_p, String content_p, IHyperlinkListener listener_p) {
        FormText text = toolkit_p.createFormText(parent_p, false);
        if (content_p != null) {
            try {
                text.setText(content_p, true, false);
            }
            catch (SWTException e) {
                text.setText(e.getMessage(), false, false);
            }
        }
        if (listener_p != null) {
            text.addHyperlinkListener(listener_p);
        }
        return text;
    }

    public static Couple<Section, Composite> createSectionWithChildComposite(FormToolkit toolkit_p, Composite parent_p, int sectionStyle_p, LayoutType layoutType_p, int childNumColumns_p, boolean equalWidth_p) {
        Section resultingSection = toolkit_p.createSection(parent_p, sectionStyle_p);
        FormHelper.updateControlLayoutDataWithLayoutTypeData((Control)resultingSection, layoutType_p);
        Composite childComposite = FormHelper.createCompositeWithLayoutType(toolkit_p, (Composite)resultingSection, layoutType_p, childNumColumns_p, equalWidth_p);
        resultingSection.setClient((Control)childComposite);
        return new Couple<Section, Composite>(resultingSection, childComposite);
    }

    public static Couple<Section, Composite> createSectionWithDescription(FormToolkit toolkit_p, Composite parent_p, String title_p, String description_p) {
        int sectionStyle = 256;
        if (description_p != null) {
            sectionStyle |= 0x80;
        }
        Couple<Section, Composite> createdSectionWithChildComposite = FormHelper.createSectionWithChildComposite(toolkit_p, parent_p, sectionStyle, LayoutType.GRID_LAYOUT, 1, true);
        Section section = createdSectionWithChildComposite.getKey();
        section.setText(title_p);
        if (description_p != null) {
            section.setDescription(description_p);
        }
        return createdSectionWithChildComposite;
    }

    public static Couple<Section, Composite> createTwistieSectionWithDescription(final IManagedForm managedForm_p, Composite parent_p, String title_p, String description_p) {
        int sectionStyle = 258;
        if (description_p != null) {
            sectionStyle |= 0x80;
        }
        Couple<Section, Composite> createdSectionWithChildComposite = FormHelper.createSectionWithChildComposite(managedForm_p.getToolkit(), parent_p, sectionStyle, LayoutType.TABLEWRAP_LAYOUT, 1, true);
        Section section = createdSectionWithChildComposite.getKey();
        section.setLayoutData((Object)new TableWrapData(256));
        section.setText(title_p);
        if (description_p != null) {
            section.setDescription(description_p);
        }
        section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                managedForm_p.reflow(false);
            }
        });
        return createdSectionWithChildComposite;
    }

    public static Couple<Section, Composite> createTwistieSectionWithToolbar(Composite sectionContainer_p, IManagedForm managedForm_p, String title_p, String description_p, boolean isExpanded_p, List<? extends IAction> toolbarActions_p) {
        Couple<Section, Composite> createdSection = FormHelper.createTwistieSectionWithDescription(managedForm_p, sectionContainer_p, title_p, description_p);
        Section section = createdSection.getKey();
        section.setExpanded(isExpanded_p);
        if (toolbarActions_p != null) {
            FormHelper.createSectionToolbar(section, toolbarActions_p);
        }
        return createdSection;
    }

    public static void forceControlSize(Control control_p, int widthInChars_p, int heightInChars_p) {
        if (control_p == null || widthInChars_p <= 0 || heightInChars_p <= 0) {
            return;
        }
        GC gc = new GC((Drawable)control_p);
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        Object layoutData = control_p.getLayoutData();
        if (layoutData instanceof GridData) {
            GridData data = (GridData)layoutData;
            data.widthHint = Dialog.convertWidthInCharsToPixels((FontMetrics)fontMetrics, (int)widthInChars_p);
            data.heightHint = Dialog.convertHeightInCharsToPixels((FontMetrics)fontMetrics, (int)heightInChars_p);
        } else if (layoutData instanceof TableWrapData) {
            TableWrapData data = (TableWrapData)layoutData;
            data.heightHint = Dialog.convertHeightInCharsToPixels((FontMetrics)fontMetrics, (int)heightInChars_p);
        }
    }

    public static Object updateCompositeLayoutWithLayoutType(Composite composite_p, LayoutType layoutType_p, int numColumns_p, boolean equalWidth_p) {
        GridLayout selectedLayout = null;
        if (LayoutType.GRID_LAYOUT.equals((Object)layoutType_p)) {
            GridLayout layout = new GridLayout();
            layout.numColumns = numColumns_p;
            layout.makeColumnsEqualWidth = equalWidth_p;
            selectedLayout = layout;
        } else if (LayoutType.TABLEWRAP_LAYOUT.equals((Object)layoutType_p)) {
            TableWrapLayout layout = new TableWrapLayout();
            layout.numColumns = numColumns_p;
            layout.makeColumnsEqualWidth = equalWidth_p;
            selectedLayout = layout;
        }
        if (selectedLayout != null) {
            composite_p.setLayout(selectedLayout);
        }
        return selectedLayout;
    }

    public static Object updateControlLayoutDataWithLayoutTypeData(Control control_p, LayoutType layoutType_p) {
        GridData layoutData = null;
        if (LayoutType.GRID_LAYOUT.equals((Object)layoutType_p)) {
            layoutData = new GridData(4, 4, true, true);
        } else if (LayoutType.TABLEWRAP_LAYOUT.equals((Object)layoutType_p)) {
            layoutData = new TableWrapData(256);
        }
        if (layoutData != null) {
            control_p.setLayoutData((Object)layoutData);
        }
        return layoutData;
    }

    public static void createSectionToolbar(Section section_p, List<? extends IAction> actions_p) {
        if (actions_p == null || actions_p.isEmpty() || section_p == null) {
            return;
        }
        ToolBarManager toolBarManager = new ToolBarManager(0x800000);
        ToolBar toolbar = toolBarManager.createControl((Composite)section_p);
        final Cursor handCursor = new Cursor((Device)Display.getCurrent(), 21);
        toolbar.setCursor(handCursor);
        toolbar.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (handCursor != null && !handCursor.isDisposed()) {
                    handCursor.dispose();
                }
            }
        });
        for (IAction iAction : actions_p) {
            toolBarManager.add(iAction);
        }
        toolBarManager.update(true);
        section_p.setTextClient((Control)toolbar);
    }

    public static void adaptRecursively(FormToolkit toolkit_p, Composite composite_p) {
        Control[] children;
        if (composite_p == null || toolkit_p == null) {
            return;
        }
        toolkit_p.adapt((Control)composite_p, true, true);
        Control[] controlArray = children = composite_p.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (control != null) {
                toolkit_p.adapt(control, true, true);
                if (control instanceof Composite) {
                    FormHelper.adaptRecursively(toolkit_p, (Composite)control);
                }
            }
            ++n2;
        }
    }

    public static void adaptBackgroundColor(Composite composite_p, Color color_p, boolean ignoreEditableTextField_p) {
        Control[] children;
        if (composite_p == null || color_p == null) {
            return;
        }
        composite_p.setBackground(color_p);
        Control[] controlArray = children = composite_p.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (control != null) {
                boolean applyColor = true;
                if (control instanceof Text && !ignoreEditableTextField_p && ((Text)control).getEditable()) {
                    applyColor = false;
                }
                if (applyColor) {
                    control.setBackground(color_p);
                }
                if (control instanceof Composite) {
                    FormHelper.adaptBackgroundColor((Composite)control, color_p, ignoreEditableTextField_p);
                }
            }
            ++n2;
        }
    }

    public static enum LayoutType {
        GRID_LAYOUT,
        TABLEWRAP_LAYOUT;

    }
}

