/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.ui.tools.internal.preference;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.sirius.common.ui.Messages;

public class DynamicConfigurationHelper
implements IPropertyChangeListener {
    private final IPreferenceStore store;
    private final Map<String, String> bindings = Maps.newHashMap();

    public DynamicConfigurationHelper(IPreferenceStore store) {
        this.store = (IPreferenceStore)Preconditions.checkNotNull((Object)store);
        store.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    protected void bindInt(String propertyName, String fieldName) {
        this.bindings.put(propertyName, fieldName);
        int value = this.store.getInt(propertyName);
        this.setInt(fieldName, value);
    }

    protected void bindBoolean(String propertyName, String fieldName) {
        this.bindings.put(propertyName, fieldName);
        boolean value = this.store.getBoolean(propertyName);
        this.setBoolean(fieldName, value);
    }

    protected void bindString(String propertyName, String fieldName) {
        this.bindings.put(propertyName, fieldName);
        String value = this.store.getString(propertyName);
        this.setString(fieldName, value);
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        String fieldName = this.bindings.get(property);
        if (fieldName != null) {
            Object rawValue = event.getNewValue();
            if (rawValue instanceof Integer) {
                this.setInt(fieldName, (Integer)rawValue);
            } else if (rawValue instanceof Boolean) {
                this.setBoolean(fieldName, (Boolean)rawValue);
            } else if (rawValue instanceof String) {
                this.setString(fieldName, (String)rawValue);
            }
        }
    }

    public void dispose() {
        this.store.removePropertyChangeListener((IPropertyChangeListener)this);
    }

    private void setInt(String field, int value) throws IllegalArgumentException {
        Field f = this.getAccessibleField(this.getClass(), field);
        try {
            f.setInt(this, value);
        }
        catch (IllegalAccessException illegalAccessException) {}
    }

    private void setBoolean(String field, boolean value) throws IllegalArgumentException {
        Field f = this.getAccessibleField(this.getClass(), field);
        try {
            f.setBoolean(this, value);
        }
        catch (IllegalAccessException illegalAccessException) {}
    }

    private void setString(String field, String value) throws IllegalArgumentException {
        Field f = this.getAccessibleField(this.getClass(), field);
        try {
            f.set(this, value);
        }
        catch (IllegalAccessException illegalAccessException) {}
    }

    private Field getAccessibleField(Class<?> klass, String fieldName) {
        Field result = null;
        if (klass != null) {
            Field[] fieldArray = klass.getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field f = fieldArray[n2];
                if (fieldName.equals(f.getName())) {
                    if (!f.isAccessible()) {
                        f.setAccessible(true);
                    }
                    result = f;
                    break;
                }
                ++n2;
            }
            if (result == null) {
                result = this.getAccessibleField(klass.getSuperclass(), fieldName);
            }
        }
        if (result != null) {
            return result;
        }
        throw new IllegalArgumentException(MessageFormat.format(Messages.DynamicConfigurationHelper_unknownField, fieldName, klass.getName()));
    }
}

