/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.movida.registry;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.business.internal.movida.registry.Entry;
import org.eclipse.sirius.business.internal.movida.registry.ViewpointRegistry;
import org.eclipse.sirius.business.internal.movida.registry.ViewpointState;

public class StatusUpdater {
    private static final String DIAGNOSTICS_SOURCE = "Sirius Registry";
    private static final int UNDECLARED_DEPENDENCY = 0;
    private static final int DECLARED_DEPENDENCY_UNAVAILABLE = 1;
    private static final int PHYSICAL_DEPENDENCY_UNAVAILABLE = 2;
    private final ResourceSetImpl resourceSet;
    private final Map<URI, Entry> entries;
    private final ViewpointRegistry.RegistryChange change;

    public StatusUpdater(ResourceSetImpl resourceSet, Map<URI, Entry> entries, ViewpointRegistry.RegistryChange change) {
        this.resourceSet = (ResourceSetImpl)Preconditions.checkNotNull((Object)resourceSet);
        this.entries = (Map)Preconditions.checkNotNull(Collections.unmodifiableMap(entries));
        this.change = (ViewpointRegistry.RegistryChange)Preconditions.checkNotNull((Object)change);
    }

    public void updateStatus() {
        this.checkAllLogicalDependenciesAreAvailable();
        this.checkAllActualDependenciesAreDeclared();
        this.checkAllActualDependenciesAreAvailable();
        this.resolveCrossResourcesReferences();
        this.performSemanticValidation();
    }

    private void performSemanticValidation() {
        for (Entry entry : this.entries.values()) {
            this.performSemanticValidation(entry);
        }
    }

    private void performSemanticValidation(Entry entry) {
        Diagnostic result = Diagnostician.INSTANCE.validate((EObject)entry.getSirius());
        if (result.getSeverity() > 2) {
            entry.setState(ViewpointState.INVALID);
        }
        entry.getDiagnostics().add(result);
    }

    private void resolveCrossResourcesReferences() {
        for (Entry entry : this.entries.values()) {
            if (entry.getState() == ViewpointState.INVALID) continue;
            try {
                EcoreUtil.resolveAll((EObject)entry.getSirius());
                entry.setState(ViewpointState.RESOLVED);
            }
            catch (RuntimeException runtimeException) {
                entry.setState(ViewpointState.INVALID);
            }
        }
    }

    private void checkAllActualDependenciesAreAvailable() {
        for (Entry entry : this.entries.values()) {
            this.checkAllActualDependenciesAreAvailable(entry);
        }
    }

    private void checkAllActualDependenciesAreAvailable(Entry entry) {
        ImmutableSet availablePhysical;
        ImmutableSet actualPhysical = ImmutableSet.copyOf((Iterable)Iterables.transform(entry.getActualDependencies(), (Function)new Function<URI, URI>(){

            public URI apply(URI from) {
                return StatusUpdater.this.resourceSet.getURIConverter().normalize(from);
            }
        }));
        Sets.SetView unavailable = Sets.difference((Set)actualPhysical, (Set)(availablePhysical = ImmutableSet.copyOf((Iterable)Iterables.transform(this.entries.values(), (Function)new Function<Entry, URI>(){

            public URI apply(Entry from) {
                return from.getResource().getURI();
            }
        }))));
        if (!unavailable.isEmpty()) {
            entry.setState(ViewpointState.INVALID);
            Object[] data = Iterables.toArray((Iterable)Iterables.transform((Iterable)unavailable, (Function)Functions.toStringFunction()), String.class);
            this.addDiagnostic(entry, 4, 2, "Sirius definition depends on resources not available.", data);
        }
    }

    private void checkAllLogicalDependenciesAreAvailable() {
        for (Entry entry : this.entries.values()) {
            this.checkLogicalDependenciesAvailable(entry);
        }
    }

    private void checkLogicalDependenciesAvailable(Entry entry) {
        for (URI dependency : entry.getDeclaredDependencies()) {
            if (this.entries.containsKey(dependency)) continue;
            entry.setState(ViewpointState.INVALID);
            this.addDiagnostic(entry, 4, 1, "Invalid dependency declared to unavailable Sirius.", new Object[]{dependency});
        }
    }

    private void checkAllActualDependenciesAreDeclared() {
        for (Entry entry : this.entries.values()) {
            this.checkActualDependencies(entry);
        }
    }

    private void checkActualDependencies(Entry entry) {
        HashSet declared = Sets.newHashSet(entry.getDeclaredDependencies());
        HashSet declaredResolved = Sets.newHashSet((Iterable)Iterables.transform((Iterable)declared, (Function)new Function<URI, URI>(){

            public URI apply(URI from) {
                return StatusUpdater.this.resourceSet.getURIConverter().normalize(from);
            }
        }));
        declared.addAll(declaredResolved);
        Set<URI> actual = entry.getActualDependencies();
        Sets.SetView undeclared = Sets.difference(actual, (Set)declared);
        if (!undeclared.isEmpty()) {
            entry.setState(ViewpointState.INVALID);
            Object[] data = Iterables.toArray((Iterable)Iterables.transform((Iterable)undeclared, (Function)Functions.toStringFunction()), String.class);
            this.addDiagnostic(entry, 4, 0, "Sirius has undeclared dependencies to other resources.", data);
        }
    }

    private void addDiagnostic(Entry entry, int severity, int code, String message, Object[] data) {
        entry.getDiagnostics().add((Diagnostic)new BasicDiagnostic(severity, DIAGNOSTICS_SOURCE, code, message, data));
    }
}

