/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amalgam.explorer.contextual.core.ui.view.ext;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.amalgam.explorer.contextual.core.ext.AbstractExtensionPointManager;
import org.eclipse.amalgam.explorer.contextual.core.ui.ExplorerContextualActivator;
import org.eclipse.amalgam.explorer.contextual.core.ui.view.ext.ISelectionHelper;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPart;

public class SelectionHelpersManager
extends AbstractExtensionPointManager
implements ISelectionHelper {
    private static SelectionHelpersManager _instance;
    private static final String _SELECTION_HELPER = "selectionHelper";
    private Map<String, ISelectionHelper> _extensions = new HashMap<String, ISelectionHelper>();

    public static SelectionHelpersManager getInstance() {
        if (_instance == null) {
            _instance = new SelectionHelpersManager();
        }
        return _instance;
    }

    private SelectionHelpersManager() {
        this.initExtensionRegistry();
    }

    @Override
    public Object getSelection(IWorkbenchPart part_p, ISelection selection_p, Object selectedObject) {
        Object result = null;
        if (!this._extensions.isEmpty()) {
            for (ISelectionHelper iSelectionHelper : this._extensions.values()) {
                Object selection = iSelectionHelper.getSelection(part_p, selection_p, selectedObject);
                if (selection == null) continue;
                result = selection;
                break;
            }
        }
        return result;
    }

    public void initExtensionRegistry() {
        IConfigurationElement[] confElements;
        IConfigurationElement[] iConfigurationElementArray = confElements = SelectionHelpersManager.getConfigurationElementsFor((String)"org.eclipse.amalgam.explorer.contextual.core.ui", (String)_SELECTION_HELPER);
        int n = confElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
            String id = iConfigurationElement.getAttribute("id");
            ISelectionHelper helper = (ISelectionHelper)SelectionHelpersManager.createTypedInstance((IConfigurationElement)iConfigurationElement, (String)"class", ISelectionHelper.class);
            if (!this._extensions.containsKey(id)) {
                this._extensions.put(id, helper);
            } else {
                String message = "Many Selection helpers share id : " + id;
                Status status = new Status(2, "org.eclipse.amalgam.explorer.contextual.core.ui", message);
                ExplorerContextualActivator.getDefault().getLog().log((IStatus)status);
            }
            ++n2;
        }
    }
}

