/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.importer;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.wizards.ClassPathDetector;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.ui.wizards.datatransfer.ProjectConfigurator;

public class ProjectWithJavaResourcesImportConfigurator
implements ProjectConfigurator {
    private static final String CLASSPATH = ".classpath";
    private static final String BIN = "bin";

    public boolean canConfigure(IProject project, Set<IPath> ignoredDirectories, IProgressMonitor monitor) {
        JavaResourceExistsFinder javaResourceFinder = new JavaResourceExistsFinder(ignoredDirectories);
        try {
            project.accept((IResourceVisitor)javaResourceFinder);
        }
        catch (CoreException ex) {
            JavaPlugin.log((IStatus)new Status(4, "org.eclipse.jdt.core", ex.getMessage(), (Throwable)ex));
            return false;
        }
        return javaResourceFinder.hasJavaFile();
    }

    public void configure(IProject project, Set<IPath> ignoredDirectories, IProgressMonitor monitor) {
        try {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)6);
            IProjectDescription description = project.getDescription();
            List<String> natures = Arrays.asList(description.getNatureIds());
            IJavaProject javaNature = null;
            if (!natures.contains("org.eclipse.jdt.core.javanature")) {
                ArrayList<String> newNatures = new ArrayList<String>(natures);
                newNatures.add("org.eclipse.jdt.core.javanature");
                description.setNatureIds(newNatures.toArray(new String[newNatures.size()]));
                project.setDescription(description, (IProgressMonitor)subMonitor.split(1));
                javaNature = JavaCore.create((IProject)project);
                javaNature.open((IProgressMonitor)subMonitor.split(1));
            } else {
                javaNature = (IJavaProject)project.getNature("org.eclipse.jdt.core.javanature");
                subMonitor.worked(2);
            }
            if (!project.getFile(CLASSPATH).exists()) {
                ClassPathDetector detector = new ClassPathDetector(project, (IProgressMonitor)subMonitor.split(2));
                IClasspathEntry[] entries = detector.getClasspath();
                IPath outputLocation = detector.getOutputLocation();
                if (entries.length == 0) {
                    entries = PreferenceConstants.getDefaultJRELibrary();
                }
                javaNature.setRawClasspath(entries, (IProgressMonitor)subMonitor.split(1));
                if (outputLocation == null) {
                    IFolder binFolder = project.getFolder(BIN);
                    if (!binFolder.exists()) {
                        binFolder.create(false, true, (IProgressMonitor)subMonitor.split(1));
                    } else {
                        subMonitor.worked(1);
                    }
                    outputLocation = binFolder.getFullPath();
                } else {
                    subMonitor.worked(1);
                }
                javaNature.setOutputLocation(outputLocation, (IProgressMonitor)subMonitor.split(1));
            } else {
                subMonitor.worked(4);
            }
        }
        catch (Exception ex) {
            JavaPlugin.log((IStatus)new Status(4, "org.eclipse.jdt.core", ex.getMessage(), (Throwable)ex));
        }
    }

    public boolean shouldBeAnEclipseProject(IContainer container, IProgressMonitor monitor) {
        return false;
    }

    public Set<IFolder> getFoldersToIgnore(IProject project, IProgressMonitor monitor) {
        HashSet<IFolder> res = new HashSet<IFolder>();
        try {
            IJavaProject javaProject = (IJavaProject)project.getNature("org.eclipse.jdt.core.javanature");
            if (javaProject == null) {
                return res;
            }
            IResource resource = project.getWorkspace().getRoot().findMember(javaProject.getOutputLocation());
            if (resource != null && resource.exists() && resource.getType() == 2) {
                res.add((IFolder)resource);
            }
            IClasspathEntry[] iClasspathEntryArray = javaProject.getRawClasspath();
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (entry.getEntryKind() == 3) {
                    IFolder sourceFolder = project.getFolder(entry.getPath());
                    res.add(sourceFolder);
                }
                ++n2;
            }
        }
        catch (CoreException ex) {
            JavaPlugin.log((IStatus)new Status(4, "org.eclipse.jdt.core", ex.getMessage(), (Throwable)ex));
        }
        return res;
    }

    public Set<File> findConfigurableLocations(File root, IProgressMonitor monitor) {
        return null;
    }

    private static final class JavaResourceExistsFinder
    implements IResourceVisitor {
        private boolean hasJavaFile;
        private Set<IPath> ignoredDirectories;

        public JavaResourceExistsFinder(Set<IPath> ignoredDirectories) {
            this.ignoredDirectories = ignoredDirectories;
        }

        public boolean visit(IResource resource) throws CoreException {
            if (this.ignoredDirectories != null) {
                for (IPath ignoredDirectory : this.ignoredDirectories) {
                    if (!ignoredDirectory.isPrefixOf(resource.getLocation())) continue;
                    return false;
                }
            }
            this.hasJavaFile = this.hasJavaFile || resource.getType() == 1 && resource.getName().endsWith(".java");
            return !this.hasJavaFile;
        }

        public boolean hasJavaFile() {
            return this.hasJavaFile;
        }
    }
}

