/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.time4sys.builder.design.arinc653;

import java.util.function.Predicate;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.time4sys.builder.design.Annotations;
import org.polarsys.time4sys.builder.design.DesignBuilder;
import org.polarsys.time4sys.builder.design.ProcessorBuilder;
import org.polarsys.time4sys.builder.design.ReferenceBuilder;
import org.polarsys.time4sys.builder.design.TaskBuilder;
import org.polarsys.time4sys.builder.design.arinc653.Arinc653DesignBuilder;
import org.polarsys.time4sys.builder.design.arinc653.Arinc653PlatformBuilder;
import org.polarsys.time4sys.marte.gqam.Reference;
import org.polarsys.time4sys.marte.grm.GrmFactory;
import org.polarsys.time4sys.marte.grm.Resource;
import org.polarsys.time4sys.marte.grm.SchedPolicyKind;
import org.polarsys.time4sys.marte.grm.Scheduler;
import org.polarsys.time4sys.marte.grm.SchedulingParameter;
import org.polarsys.time4sys.marte.grm.SecondaryScheduler;
import org.polarsys.time4sys.marte.grm.TableEntryType;
import org.polarsys.time4sys.marte.hrm.HardwareProcessor;
import org.polarsys.time4sys.marte.nfp.Duration;
import org.polarsys.time4sys.marte.nfp.NfpFactory;
import org.polarsys.time4sys.marte.srm.SoftwareSchedulableResource;

public class Arinc653MIFBuilder {
    public static final String PARTITION_ATTR = "partition";
    public static final String REF_ATTR = "reference";
    private TaskBuilder taskBuilder;
    private DesignBuilder designBuilder;
    private TaskBuilder[] subTasks;
    private SecondaryScheduler sched;
    private String timeBudget;
    private ReferenceBuilder ref;
    private ReferenceBuilder startRef;

    public static boolean hasASecondaryScheduler(final SoftwareSchedulableResource result) {
        return result.getOwnedResource().stream().anyMatch(new Predicate<Resource>(){

            @Override
            public boolean test(Resource value) {
                if (value instanceof SecondaryScheduler) {
                    return ((SecondaryScheduler)value).getVirtualProcessingUnit().contains((Object)result);
                }
                return false;
            }
        });
    }

    public static boolean isInstance(SoftwareSchedulableResource task) {
        String partAttr = Annotations.getAttr((EModelElement)task, "http://www.polarsys.org/time4sys/org.polarsys.time4sys.builder.design.arinc653", PARTITION_ATTR);
        if (partAttr != null) {
            try {
                return Boolean.parseBoolean(partAttr);
            }
            catch (Exception exception) {}
        }
        return false;
    }

    public static Arinc653MIFBuilder as(SoftwareSchedulableResource value) {
        Arinc653DesignBuilder db = Arinc653DesignBuilder.containing((EObject)value);
        return new Arinc653MIFBuilder(db, value);
    }

    public static Arinc653MIFBuilder aMIF() {
        return new Arinc653MIFBuilder();
    }

    public static Arinc653MIFBuilder aPartition() {
        return Arinc653MIFBuilder.aMIF();
    }

    public static boolean isMIF(SoftwareSchedulableResource aTask) {
        TaskBuilder taskBuilder = new TaskBuilder(null, aTask);
        if (taskBuilder.hasAnnotation("http://www.polarsys.org/time4sys/org.polarsys.time4sys.builder.design.arinc653")) {
            String partitionVal = (String)taskBuilder.annotate("http://www.polarsys.org/time4sys/org.polarsys.time4sys.builder.design.arinc653").getDetails().get((Object)PARTITION_ATTR);
            return partitionVal != null && Boolean.parseBoolean(partitionVal);
        }
        return false;
    }

    public Arinc653MIFBuilder() {
        this.taskBuilder = new TaskBuilder();
        this.taskBuilder.annotate("http://www.polarsys.org/time4sys/org.polarsys.time4sys.builder.design.arinc653").getDetails().put((Object)PARTITION_ATTR, (Object)Boolean.TRUE.toString());
    }

    public Arinc653MIFBuilder(Arinc653DesignBuilder db, SoftwareSchedulableResource value) {
        this.taskBuilder = new TaskBuilder(db, value);
        this.designBuilder = db;
        EAnnotation annot = this.taskBuilder.annotate("http://www.polarsys.org/time4sys/org.polarsys.time4sys.builder.design.arinc653");
        if (!Boolean.TRUE.toString().equals(annot.getDetails().get((Object)PARTITION_ATTR))) {
            annot.getDetails().put((Object)PARTITION_ATTR, (Object)Boolean.TRUE.toString());
        }
    }

    public Arinc653MIFBuilder called(String value) {
        this.taskBuilder.called(value);
        return this;
    }

    public Arinc653MIFBuilder ofTimeBudget(String value) {
        this.timeBudget = value;
        if (this.designBuilder != null) {
            Duration d = NfpFactory.eINSTANCE.createDurationFromString(value);
            this.getOrCreateTableEntry().setInitialBudget(d);
        }
        return this;
    }

    public Duration getTimeBudget() {
        return this.getOrCreateTableEntry().getInitialBudget();
    }

    public Arinc653MIFBuilder withOffset(String offset) {
        return this;
    }

    public Arinc653MIFBuilder withNoOffset() {
        return this.withOffset("0ms");
    }

    public Arinc653MIFBuilder withMIFDuration(Duration t) {
        this.getOrCreateTableEntry().getTimeSlot().add((Object)t);
        return this;
    }

    public TableEntryType getOrCreateTableEntry() {
        if (this.designBuilder == null) {
            throw new IllegalStateException("getOrCreateTableEntry cannot be called until it has been built");
        }
        SoftwareSchedulableResource raw = this.taskBuilder.build(this.designBuilder);
        for (SchedulingParameter param : raw.getSchedParams()) {
            if (!(param instanceof TableEntryType)) continue;
            return (TableEntryType)param;
        }
        TableEntryType entry = GrmFactory.eINSTANCE.createTableEntryType();
        raw.getSchedParams().add((Object)entry);
        return entry;
    }

    public Duration getMIFDuration() {
        EList timeSlots = this.getOrCreateTableEntry().getTimeSlot();
        if (timeSlots == null || timeSlots.isEmpty()) {
            return null;
        }
        return (Duration)timeSlots.get(0);
    }

    public String getName() {
        return this.taskBuilder.getName();
    }

    public SoftwareSchedulableResource build(DesignBuilder designBuilder) {
        this.designBuilder = designBuilder;
        if (this.timeBudget != null) {
            this.ofTimeBudget(this.timeBudget);
        }
        SoftwareSchedulableResource result = this.taskBuilder.build(designBuilder);
        if (this.subTasks != null) {
            TaskBuilder[] taskBuilderArray = this.subTasks;
            int n = this.subTasks.length;
            int n2 = 0;
            while (n2 < n) {
                TaskBuilder tb = taskBuilderArray[n2];
                tb.build(designBuilder);
                ++n2;
            }
        }
        this.getOrCreateTableEntry().setName(String.valueOf(this.getName()) + " Slot");
        if (this.startRef != null) {
            this.startRef.called(String.valueOf(this.getName()) + "_start");
        }
        if (!Arinc653MIFBuilder.hasASecondaryScheduler(result)) {
            this.under(SchedPolicyKind.FIXED_PRIORITY);
        }
        return result;
    }

    public SoftwareSchedulableResource build() {
        if (this.designBuilder == null) {
            throw new IllegalStateException("Build() cannot be called until it has been built with a DesignBuilder once.");
        }
        return this.taskBuilder.build();
    }

    public void addOwnedResource(TaskBuilder tb) {
        this.taskBuilder.addOwnedResource(tb);
    }

    private void addOwnedResource(Resource res) {
        this.taskBuilder.addOwnedResource(res);
    }

    public long countTasks() {
        return this.taskBuilder.getOwnedResource().stream().filter(new Predicate<Resource>(){

            @Override
            public boolean test(Resource p) {
                return p instanceof SoftwareSchedulableResource;
            }
        }).count();
    }

    public Arinc653MIFBuilder runs(TaskBuilder ... tasks) {
        return this.thatRuns(tasks);
    }

    public Arinc653MIFBuilder thatRuns(TaskBuilder ... tasks) {
        this.subTasks = tasks;
        TaskBuilder[] taskBuilderArray = tasks;
        int n = tasks.length;
        int n2 = 0;
        while (n2 < n) {
            TaskBuilder tb = taskBuilderArray[n2];
            this.addOwnedResource(tb);
            if (this.designBuilder != null) {
                tb.build(this.designBuilder);
            }
            ++n2;
        }
        return this;
    }

    public Arinc653MIFBuilder under(SchedPolicyKind kind) {
        SoftwareSchedulableResource mifTask = this.taskBuilder.build();
        if (this.sched == null) {
            for (Resource res : this.taskBuilder.getOwnedResource()) {
                SecondaryScheduler secSched;
                EList virtualProcs;
                if (!(res instanceof SecondaryScheduler) || !(virtualProcs = (secSched = (SecondaryScheduler)res).getVirtualProcessingUnit()).isEmpty() && !virtualProcs.contains((Object)mifTask)) continue;
                this.sched = secSched;
                break;
            }
        }
        if (this.sched == null) {
            this.sched = GrmFactory.eINSTANCE.createSecondaryScheduler();
        }
        this.addOwnedResource((Resource)this.sched);
        if (!this.sched.getVirtualProcessingUnit().contains((Object)mifTask)) {
            this.sched.getVirtualProcessingUnit().add((Object)mifTask);
            this.sched.setName(String.valueOf(mifTask.getName()) + " Scheduler");
        }
        ProcessorBuilder.initSchedulerPolicy((Scheduler)this.sched, (Resource)mifTask, kind);
        return this;
    }

    public SecondaryScheduler getScheduler() {
        return this.sched;
    }

    public EAnnotation annotate(String source) {
        return this.taskBuilder.annotate(source);
    }

    public synchronized ReferenceBuilder reference() {
        if (this.ref == null) {
            for (EObject obj : this.annotate("http://www.polarsys.org/time4sys/org.polarsys.time4sys.builder.design.arinc653").getReferences()) {
                if (!(obj instanceof Reference)) continue;
                this.ref = new ReferenceBuilder((Reference)obj);
            }
            String refname = "Ref " + this.taskBuilder.getName();
            if (this.ref == null) {
                this.ref = this.designBuilder.reference(refname);
                if (this.ref != null) {
                    this.annotate("http://www.polarsys.org/time4sys/org.polarsys.time4sys.builder.design.arinc653").getReferences().add((Object)this.ref.build());
                }
            }
            if (this.ref == null) {
                this.ref = this.designBuilder.hasAReference().called(refname);
                this.annotate("http://www.polarsys.org/time4sys/org.polarsys.time4sys.builder.design.arinc653").getReferences().add((Object)this.ref.build());
            }
        }
        return this.ref;
    }

    public Arinc653PlatformBuilder getPlatform() {
        EObject container = this.taskBuilder.build().eContainer();
        if (container instanceof HardwareProcessor) {
            Arinc653PlatformBuilder platform = Arinc653PlatformBuilder.as((HardwareProcessor)container);
            platform.addPartition(this);
            return platform;
        }
        return null;
    }

    public ReferenceBuilder hasAReference() {
        EAnnotation annot = this.taskBuilder.annotate("http://www.polarsys.org/time4sys/org.polarsys.time4sys.builder.design.arinc653");
        for (EObject obj : annot.getReferences()) {
            if (!(obj instanceof Reference)) continue;
            this.startRef = new ReferenceBuilder((Reference)obj);
            break;
        }
        if (this.startRef == null) {
            this.startRef = this.designBuilder.hasAReference();
            annot.getReferences().add((Object)this.startRef.build());
        }
        return this.startRef;
    }

    public void setNotAPartition() {
        Annotations.setAttr((EModelElement)this.taskBuilder.build(), "http://www.polarsys.org/time4sys/org.polarsys.time4sys.builder.design.arinc653", PARTITION_ATTR, Boolean.FALSE.toString());
    }
}

