/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.time4sys.builder.design;

import java.util.function.Predicate;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.time4sys.builder.design.AlarmBuilder;
import org.polarsys.time4sys.builder.design.Annotations;
import org.polarsys.time4sys.builder.design.DesignBuilder;
import org.polarsys.time4sys.builder.design.StepBuilder;
import org.polarsys.time4sys.builder.design.TableDrivenSchedPolicyBuilder;
import org.polarsys.time4sys.builder.design.TaskBuilder;
import org.polarsys.time4sys.design.DesignFactory;
import org.polarsys.time4sys.marte.gqam.GqamFactory;
import org.polarsys.time4sys.marte.grm.ComputingResource;
import org.polarsys.time4sys.marte.grm.GrmFactory;
import org.polarsys.time4sys.marte.grm.GrmPackage;
import org.polarsys.time4sys.marte.grm.ProcessingResource;
import org.polarsys.time4sys.marte.grm.Resource;
import org.polarsys.time4sys.marte.grm.SchedPolicyKind;
import org.polarsys.time4sys.marte.grm.SchedulableResource;
import org.polarsys.time4sys.marte.grm.Scheduler;
import org.polarsys.time4sys.marte.grm.SchedulingPolicy;
import org.polarsys.time4sys.marte.hrm.HardwareProcessor;
import org.polarsys.time4sys.marte.hrm.HrmFactory;
import org.polarsys.time4sys.marte.nfp.NfpFactory;
import org.polarsys.time4sys.marte.srm.SoftwareConcurrentResource;
import org.polarsys.time4sys.marte.srm.SoftwareSchedulableResource;
import org.polarsys.time4sys.marte.srm.SrmFactory;

public class ProcessorBuilder {
    protected static DesignFactory df = DesignFactory.eINSTANCE;
    protected static GqamFactory gqamFactory = GqamFactory.eINSTANCE;
    protected static SrmFactory srmFactory = SrmFactory.eINSTANCE;
    protected static GrmFactory grmFactory = GrmFactory.eINSTANCE;
    protected static HrmFactory hrmFactory = HrmFactory.eINSTANCE;
    protected static NfpFactory nfpFactory = NfpFactory.eINSTANCE;
    private HardwareProcessor proc;
    private DesignBuilder designBuilder;

    public static Scheduler initSchedulerPolicy(Scheduler sched, Resource proc, SchedPolicyKind polKind) {
        SchedulingPolicy pol;
        proc.getOwnedResource().add((Object)sched);
        if (sched.eIsSet((EStructuralFeature)GrmPackage.eINSTANCE.getScheduler_Policy())) {
            pol = sched.getPolicy();
        } else {
            pol = grmFactory.createSchedulingPolicy(polKind);
            sched.setPolicy(pol);
        }
        for (Resource res : proc.getOwnedResource()) {
            if (!(res instanceof SchedulableResource)) continue;
            sched.getSchedulableResource().add((Object)((SchedulableResource)res));
        }
        if (proc instanceof ComputingResource && sched.getHost() != proc) {
            sched.setHost((ComputingResource)proc);
        }
        return sched;
    }

    public static Scheduler setSchedulerPolicy(ProcessingResource proc, SchedPolicyKind polKind) {
        Scheduler sched;
        if (proc.eIsSet((EStructuralFeature)GrmPackage.eINSTANCE.getProcessingResource_MainScheduler())) {
            sched = proc.getMainScheduler();
        } else {
            sched = srmFactory.createSoftwareScheduler();
            proc.setMainScheduler(sched);
        }
        ProcessorBuilder.initSchedulerPolicy(sched, (Resource)proc, polKind);
        if (!sched.getProcessingUnits().contains((Object)proc)) {
            sched.getProcessingUnits().add((Object)proc);
        }
        return sched;
    }

    public ProcessorBuilder(DesignBuilder designBuilder, HardwareProcessor proc) {
        this.proc = proc;
        this.designBuilder = designBuilder;
    }

    public ProcessorBuilder called(String name) {
        this.proc.setName(name);
        return this;
    }

    public ProcessorBuilder thatRuns(TaskBuilder ... tasks) {
        TaskBuilder[] taskBuilderArray = tasks;
        int n = tasks.length;
        int n2 = 0;
        while (n2 < n) {
            TaskBuilder tb = taskBuilderArray[n2];
            this.addOwnedResource((SoftwareConcurrentResource)tb.build(this.designBuilder));
            ++n2;
        }
        return this;
    }

    public ProcessorBuilder thatRuns(StepBuilder ... steps) {
        StepBuilder[] stepBuilderArray = steps;
        int n = steps.length;
        int n2 = 0;
        while (n2 < n) {
            StepBuilder step = stepBuilderArray[n2];
            this.addOwnedResource((SoftwareConcurrentResource)step.getTask().build(this.designBuilder));
            ++n2;
        }
        return this;
    }

    public ProcessorBuilder runs(TaskBuilder ... tasks) {
        return this.thatRuns(tasks);
    }

    public ProcessorBuilder thatHandles(AlarmBuilder ... alarms) {
        AlarmBuilder[] alarmBuilderArray = alarms;
        int n = alarms.length;
        int n2 = 0;
        while (n2 < n) {
            AlarmBuilder alrm = alarmBuilderArray[n2];
            this.addOwnedResource((SoftwareConcurrentResource)alrm.build(this.designBuilder));
            ++n2;
        }
        return this;
    }

    public ProcessorBuilder under(SchedPolicyKind polKind) {
        ProcessorBuilder.setSchedulerPolicy((ProcessingResource)this.proc, polKind);
        return this;
    }

    public TableDrivenSchedPolicyBuilder underTableDrivenSchedPolicy() {
        this.under(SchedPolicyKind.TIME_TABLE_DRIVEN);
        if (this.proc.getMainScheduler().getHost() != this.proc) {
            this.proc.getMainScheduler().setHost((ComputingResource)this.proc);
        }
        return new TableDrivenSchedPolicyBuilder(this.proc.getMainScheduler());
    }

    public HardwareProcessor build() {
        return this.proc;
    }

    public void addOwnedResource(SoftwareConcurrentResource value) {
        this.proc.getOwnedResource().add((Object)value);
    }

    public long countTasks() {
        return this.proc.getOwnedResource().stream().filter(new Predicate<Resource>(){

            @Override
            public boolean test(Resource p) {
                return p instanceof SoftwareSchedulableResource;
            }
        }).count();
    }

    public void addSchedulable(SoftwareSchedulableResource task) {
        this.proc.getMainScheduler().getSchedulableResource().add((Object)task);
    }

    public EAnnotation annotate(String url) {
        return Annotations.annotate((EModelElement)this.proc, url);
    }
}

