/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.internal.search.ISearchHitCollector;
import org.eclipse.help.internal.search.ISearchQuery;
import org.eclipse.help.internal.search.QueryTooComplexException;
import org.eclipse.help.internal.search.SearchHit;

public class SearchProgressMonitor
implements IProgressMonitor {
    protected static Map<String, SearchProgressMonitor> progressMonitors = new HashMap<String, SearchProgressMonitor>();
    protected static ISearchHitCollector dummy_collector = new ISearchHitCollector(){

        @Override
        public void addHits(List<SearchHit> hits, String s) {
        }

        @Override
        public void addQTCException(QueryTooComplexException exception) throws QueryTooComplexException {
            throw exception;
        }
    };
    private boolean started = false;
    private boolean done = false;
    private boolean canceled = false;
    private int totalWork = -1;
    private double currWork;

    public void beginTask(String name, int totalWork) {
        this.totalWork = totalWork;
        this.started = true;
    }

    public void done() {
        this.currWork = this.totalWork;
        this.done = true;
        this.started = true;
    }

    public void setTaskName(String name) {
    }

    public void subTask(String name) {
    }

    public void worked(int work) {
        this.internalWorked(work);
    }

    public void internalWorked(double work) {
        this.currWork += work;
        if (this.currWork > (double)this.totalWork) {
            this.currWork = this.totalWork;
        } else if (this.currWork < 0.0) {
            this.currWork = 0.0;
        }
    }

    public int getPercentage() {
        if (this.done) {
            return 100;
        }
        if (this.totalWork == -1) {
            return 0;
        }
        if (this.currWork >= (double)this.totalWork) {
            return 100;
        }
        return (int)(100.0 * this.currWork / (double)this.totalWork);
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void started() {
        this.started = true;
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isDone() {
        return this.done;
    }

    public void setCanceled(boolean canceled) {
        this.canceled = canceled;
    }

    public static synchronized SearchProgressMonitor getProgressMonitor(final String locale) {
        if (progressMonitors.get(locale) != null) {
            return progressMonitors.get(locale);
        }
        final SearchProgressMonitor pm = new SearchProgressMonitor();
        progressMonitors.put(locale, pm);
        Thread indexer = new Thread(new Runnable(){

            @Override
            public void run() {
                block3: {
                    try {
                        BaseHelpSystem.getSearchManager().search(new DummySearchQuery(locale), dummy_collector, pm);
                    }
                    catch (OperationCanceledException operationCanceledException) {
                        progressMonitors.remove(locale);
                    }
                    catch (Exception e) {
                        progressMonitors.remove(locale);
                        if (HelpBasePlugin.getDefault() == null) break block3;
                        HelpBasePlugin.logError("Problem occurred during indexing of documentation.", e);
                    }
                }
            }
        });
        indexer.setName("HelpSearchIndexer");
        indexer.start();
        while (!pm.isStarted()) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
            if (progressMonitors.get(locale) == null) break;
        }
        return pm;
    }

    public static synchronized void reinit(String locale) {
        progressMonitors.remove(locale);
    }

    static class DummySearchQuery
    implements ISearchQuery {
        private String l;

        DummySearchQuery(String loc) {
            this.l = loc;
        }

        @Override
        public Collection<String> getFieldNames() {
            return new ArrayList<String>();
        }

        @Override
        public String getSearchWord() {
            return "dummy";
        }

        @Override
        public boolean isFieldSearch() {
            return false;
        }

        @Override
        public String getLocale() {
            return this.l;
        }
    }
}

