/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.time4sys.marte.nfp.impl;

import java.math.MathContext;
import java.util.NoSuchElementException;
import java.util.Scanner;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.polarsys.time4sys.marte.nfp.Bucket;
import org.polarsys.time4sys.marte.nfp.CompositeDistribution;
import org.polarsys.time4sys.marte.nfp.DataSize;
import org.polarsys.time4sys.marte.nfp.DataSizeUnitKind;
import org.polarsys.time4sys.marte.nfp.DataTxRate;
import org.polarsys.time4sys.marte.nfp.DataTxRateUnitKind;
import org.polarsys.time4sys.marte.nfp.DiscreteDistribution;
import org.polarsys.time4sys.marte.nfp.DiscreteDistributionKind;
import org.polarsys.time4sys.marte.nfp.Duration;
import org.polarsys.time4sys.marte.nfp.GeneralizedExtremeValueDistribution;
import org.polarsys.time4sys.marte.nfp.NfpFactory;
import org.polarsys.time4sys.marte.nfp.NfpPackage;
import org.polarsys.time4sys.marte.nfp.NormalDistribution;
import org.polarsys.time4sys.marte.nfp.ProbabilisticDuration;
import org.polarsys.time4sys.marte.nfp.TimeInterval;
import org.polarsys.time4sys.marte.nfp.TimeUnitKind;
import org.polarsys.time4sys.marte.nfp.UniformDistribution;
import org.polarsys.time4sys.marte.nfp.impl.BucketImpl;
import org.polarsys.time4sys.marte.nfp.impl.CompositeDistributionImpl;
import org.polarsys.time4sys.marte.nfp.impl.DataSizeImpl;
import org.polarsys.time4sys.marte.nfp.impl.DataTxRateImpl;
import org.polarsys.time4sys.marte.nfp.impl.DiscreteDistributionImpl;
import org.polarsys.time4sys.marte.nfp.impl.DurationImpl;
import org.polarsys.time4sys.marte.nfp.impl.GeneralizedExtremeValueDistributionImpl;
import org.polarsys.time4sys.marte.nfp.impl.LongDurationImpl;
import org.polarsys.time4sys.marte.nfp.impl.NormalDistributionImpl;
import org.polarsys.time4sys.marte.nfp.impl.ProbabilisticDurationImpl;
import org.polarsys.time4sys.marte.nfp.impl.TimeIntervalImpl;
import org.polarsys.time4sys.marte.nfp.impl.UniformDistributionImpl;

public class NfpFactoryImpl
extends EFactoryImpl
implements NfpFactory {
    public static NfpFactory init() {
        try {
            NfpFactory theNfpFactory = (NfpFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.polarsys.org/time4sys/marte/nfp/1.0");
            if (theNfpFactory != null) {
                return theNfpFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new NfpFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createBucket();
            }
            case 1: {
                return this.createCompositeDistribution();
            }
            case 2: {
                return this.createDataSize();
            }
            case 3: {
                return this.createDataTxRate();
            }
            case 4: {
                return this.createDiscreteDistribution();
            }
            case 5: {
                return this.createDuration();
            }
            case 6: {
                return this.createGeneralizedExtremeValueDistribution();
            }
            case 7: {
                return this.createNormalDistribution();
            }
            case 8: {
                return this.createProbabilisticDuration();
            }
            case 9: {
                return this.createTimeInterval();
            }
            case 10: {
                return this.createUniformDistribution();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 11: {
                return this.createDataSizeUnitKindFromString(eDataType, initialValue);
            }
            case 12: {
                return this.createDataTxRateUnitKindFromString(eDataType, initialValue);
            }
            case 13: {
                return this.createDiscreteDistributionKindFromString(eDataType, initialValue);
            }
            case 14: {
                return this.createTimeUnitKindFromString(eDataType, initialValue);
            }
            case 15: {
                return this.createMathContextFromString(eDataType, initialValue);
            }
            case 16: {
                return this.createNFP_DurationFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 11: {
                return this.convertDataSizeUnitKindToString(eDataType, instanceValue);
            }
            case 12: {
                return this.convertDataTxRateUnitKindToString(eDataType, instanceValue);
            }
            case 13: {
                return this.convertDiscreteDistributionKindToString(eDataType, instanceValue);
            }
            case 14: {
                return this.convertTimeUnitKindToString(eDataType, instanceValue);
            }
            case 15: {
                return this.convertMathContextToString(eDataType, instanceValue);
            }
            case 16: {
                return this.convertNFP_DurationToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public Duration createDuration() {
        LongDurationImpl duration = new LongDurationImpl();
        return duration;
    }

    @Override
    public TimeInterval createTimeInterval() {
        TimeIntervalImpl timeInterval = new TimeIntervalImpl();
        return timeInterval;
    }

    @Override
    public DataSize createDataSize() {
        DataSizeImpl dataSize = new DataSizeImpl();
        return dataSize;
    }

    @Override
    public DataTxRate createDataTxRate() {
        DataTxRateImpl dataTxRate = new DataTxRateImpl();
        return dataTxRate;
    }

    @Override
    public ProbabilisticDuration createProbabilisticDuration() {
        ProbabilisticDurationImpl probabilisticDuration = new ProbabilisticDurationImpl();
        return probabilisticDuration;
    }

    @Override
    public DiscreteDistribution createDiscreteDistribution() {
        DiscreteDistributionImpl discreteDistribution = new DiscreteDistributionImpl();
        return discreteDistribution;
    }

    @Override
    public Bucket createBucket() {
        BucketImpl bucket = new BucketImpl();
        return bucket;
    }

    @Override
    public NormalDistribution createNormalDistribution() {
        NormalDistributionImpl normalDistribution = new NormalDistributionImpl();
        return normalDistribution;
    }

    @Override
    public GeneralizedExtremeValueDistribution createGeneralizedExtremeValueDistribution() {
        GeneralizedExtremeValueDistributionImpl generalizedExtremeValueDistribution = new GeneralizedExtremeValueDistributionImpl();
        return generalizedExtremeValueDistribution;
    }

    @Override
    public UniformDistribution createUniformDistribution() {
        UniformDistributionImpl uniformDistribution = new UniformDistributionImpl();
        return uniformDistribution;
    }

    @Override
    public CompositeDistribution createCompositeDistribution() {
        CompositeDistributionImpl compositeDistribution = new CompositeDistributionImpl();
        return compositeDistribution;
    }

    public TimeUnitKind createTimeUnitKindFromString(EDataType eDataType, String initialValue) {
        TimeUnitKind result = TimeUnitKind.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertTimeUnitKindToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public DataSizeUnitKind createDataSizeUnitKindFromString(EDataType eDataType, String initialValue) {
        DataSizeUnitKind result = DataSizeUnitKind.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertDataSizeUnitKindToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public DataTxRateUnitKind createDataTxRateUnitKindFromString(EDataType eDataType, String initialValue) {
        DataTxRateUnitKind result = DataTxRateUnitKind.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertDataTxRateUnitKindToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public DiscreteDistributionKind createDiscreteDistributionKindFromString(EDataType eDataType, String initialValue) {
        DiscreteDistributionKind result = DiscreteDistributionKind.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertDiscreteDistributionKindToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public Duration createNFP_DurationFromString(EDataType eDataType, String initialValue) {
        return this.createDurationFromString(initialValue);
    }

    public String convertNFP_DurationToString(EDataType eDataType, Object instanceValue) {
        assert (instanceValue == null || instanceValue instanceof Duration);
        return this.convertDurationToString((Duration)instanceValue);
    }

    public MathContext createMathContextFromString(EDataType eDataType, String initialValue) {
        return (MathContext)super.createFromString(eDataType, initialValue);
    }

    public String convertMathContextToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    @Override
    public NfpPackage getNfpPackage() {
        return (NfpPackage)this.getEPackage();
    }

    @Deprecated
    public static NfpPackage getPackage() {
        return NfpPackage.eINSTANCE;
    }

    @Override
    public Duration createDurationFromString(String value) {
        DurationImpl duration;
        String unitStr;
        if (value == null) {
            return LongDurationImpl.ZERO;
        }
        Scanner scan = new Scanner(value);
        String valueStr = scan.findInLine("\\d+(\\.\\d+)?((E|e)\\d+)?");
        try {
            unitStr = scan.next();
        }
        catch (NoSuchElementException noSuchElementException) {
            unitStr = "ms";
        }
        scan.close();
        TimeUnitKind u = TimeUnitKind.getByName(unitStr);
        if (u == null) {
            u = TimeUnitKind.get(unitStr);
        }
        if (valueStr == null) {
            duration = LongDurationImpl.ZERO;
        } else {
            assert (u != null);
            duration = new LongDurationImpl(Double.parseDouble(valueStr), u);
        }
        return duration;
    }

    @Override
    public TimeInterval createTimeIntervalFromString(String value) {
        TimeIntervalImpl anInterval = new TimeIntervalImpl();
        Scanner scan = new Scanner(value);
        String leftPar = scan.findInLine("\\]|\\[");
        anInterval.setMinOpen("]".equals(leftPar));
        String leftStr = scan.findInLine("[^,]*");
        anInterval.setMin(this.createDurationFromString(leftStr));
        scan.findInLine(",");
        String rightStr = scan.findInLine("[^\\]\\[]*");
        if (rightStr == null) {
            rightStr = leftStr;
        }
        anInterval.setMax(this.createDurationFromString(rightStr));
        String rightPar = scan.findInLine("\\]|\\[");
        anInterval.setMaxOpen("[".equals(rightPar));
        scan.close();
        return anInterval;
    }

    public static String convertDoubleToString(double v) {
        String nominalStr = Double.toString(v);
        int pointIdx = nominalStr.indexOf(46);
        if (pointIdx == -1) {
            return nominalStr;
        }
        String reducedStr = nominalStr.substring(0, pointIdx);
        double vv = Double.parseDouble(reducedStr);
        if (Double.doubleToRawLongBits(v) == Double.doubleToRawLongBits(vv)) {
            return reducedStr;
        }
        return nominalStr;
    }

    @Override
    public String convertDurationToString(Duration instanceValue) {
        if (instanceValue == null) {
            instanceValue = this.createDuration();
        }
        return instanceValue.toString();
    }

    @Override
    public String convertTimeIntervalToString(TimeInterval instanceValue) {
        if (instanceValue == null) {
            instanceValue = this.createTimeInterval();
        }
        return instanceValue.toString();
    }
}

