/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.editor.tabbar;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.sirius.common.tools.api.util.EclipseUtil;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.api.editor.tabbar.ITabbarContributor;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.tabbar.ITabbarContributorProvider;
import org.eclipse.sirius.viewpoint.SiriusPlugin;

public class ExtensionPointTabbarContributorProvider
implements ITabbarContributorProvider {
    public static final String EXTENSION_ID = "org.eclipse.sirius.diagram.ui.tabbarContributor";
    private List<ITabbarContributor> loadedExtensions;

    @Override
    public boolean hasContributor() {
        if (this.loadedExtensions == null) {
            this.loadExtensions();
        }
        return !this.loadedExtensions.isEmpty();
    }

    @Override
    public ITabbarContributor getContributor() {
        return this.getContributor(null);
    }

    @Override
    public ITabbarContributor getContributor(ISelection selection) {
        if (this.loadedExtensions == null) {
            this.loadExtensions();
        }
        for (ITabbarContributor extension : this.loadedExtensions) {
            if (!extension.accept(selection)) continue;
            return extension;
        }
        return null;
    }

    private void loadExtensions() {
        IConfigurationElement[] configurationElements;
        this.loadedExtensions = new ArrayList<ITabbarContributor>();
        IConfigurationElement[] iConfigurationElementArray = configurationElements = EclipseUtil.getConfigurationElementsFor((String)EXTENSION_ID);
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            try {
                Object contribution = configurationElement.createExecutableExtension("class");
                if (contribution instanceof ITabbarContributor) {
                    this.loadedExtensions.add((ITabbarContributor)contribution);
                }
            }
            catch (CoreException e) {
                String extensionId = null;
                Object parent = configurationElement.getParent();
                if (parent instanceof IExtension) {
                    extensionId = ((IExtension)parent).getUniqueIdentifier();
                }
                String message = "";
                message = extensionId != null ? MessageFormat.format(Messages.DefaultTabbarContributorProvider_contributionError_withId, extensionId) : Messages.DefaultTabbarContributorProvider_contributionError;
                SiriusPlugin.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.sirius.diagram.ui", message, (Throwable)e));
            }
            ++n2;
        }
    }
}

