/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.tools.api.command.view;

import java.util.Set;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.Messages;
import org.eclipse.sirius.diagram.business.api.helper.graphicalfilters.HideFilterHelper;
import org.eclipse.sirius.diagram.business.api.query.DDiagramElementQuery;

public class HideDDiagramElement
extends RecordingCommand {
    public static final String HIDE_ELEMENT_LABEL = Messages.HideDDiagramElement_hideElementLabel;
    public static final String HIDE_ELEMENTS_LABEL = Messages.HideDDiagramElement_hideElementsLabel;
    private final Set<?> objectsToHide;

    public HideDDiagramElement(TransactionalEditingDomain domain, Set<?> elementsToHide) {
        super(domain);
        if (elementsToHide != null && elementsToHide.size() > 1) {
            this.setLabel(HIDE_ELEMENTS_LABEL);
        } else {
            this.setLabel(HIDE_ELEMENT_LABEL);
        }
        this.objectsToHide = elementsToHide;
    }

    protected void setInvisible(DDiagramElement element) {
        if (!new DDiagramElementQuery(element).isHidden()) {
            HideFilterHelper.INSTANCE.hide(element);
        }
    }

    protected void doExecute() {
        for (Object obj : this.objectsToHide) {
            if (!(obj instanceof DDiagramElement)) continue;
            this.setInvisible((DDiagramElement)obj);
        }
    }
}

